/*
 * UUX-		Perform Unix to Unix Remote Execute Requests.  
 * 		This entire program is a quick, ugly  hack.  Sloppiness
 *		abounds.  There isn't much error checking.  I'm ashamed of
 *		it.  However, it does handle the restricted cases that it
 *		needs to - in particular running remote rmail and remote
 *		rnews.  As long as you're gentle with it....
 *
 *		This program needs work in handling local commands and
 *		the handling of remote I/O redirection.  These features
 * 		will be added in future versions of this program.
 *
 * Usage:	uux [-plrv] [-g grade] [-a user] [-] host!cmd arg ...
 *
 * Version:	1.6	02/17/90
 *
 * Authors:	Peter S. Housel (housel@ecn.purdue.edu)
 *		Fred van Kempen (waltje@minixug.hobbynet.nl)
 */
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <string.h>
#include <stdio.h>
#include "uucp.h"


static char *Version = "@(#) uux 1.6 (02/17/90)";
static char *seqname = SPOOLSEQ;
static char *lseqname = LSPOOLSEQ;
static char *tempname = "/usr/spool/uucp/TM.XXXXXX";


char luser[16];			/* local user name */
char mysite[SITENAMELEN];	/* this host's uucpname */
char cmdsite[SITENAMELEN];	/* site where command is run */
char cmd[64];			/* remote command name */
char arglist[2048] = "";	/* remote argument list */
FILE *fdcfile;			/* the "C." spool command file */
FILE *fdxfile;			/* the "X." remote spool execute file */
char grade = 'A';		/* transfer grade */
int nocico = 0;			/* "don't run uucico" flag */
int trylink = 0;		/* try spoolfile links before copying */
int readstdin = 0;		/* read standard input ("-" or "-p") */


extern int getopt(), optind, opterr;
extern char *optarg;


/*
 * Uucpname() returns a pointer to the local host's UUCP nodename.
 * There are several possible means of determining this, depending
 * on the operating system version. For now, this version just reads
 * one line from the NODENAME file, which is usually "/etc/uucpname".
 */
char *uucpname()
{
  FILE *uufile;
  static char uuname[SITENAMELEN];

  if ((uufile = fopen(NODENAME, "r")) == (FILE *)NULL) return("unknown");
  fgets(uuname, sizeof uuname, uufile);
  uuname[strlen(uuname) - 1] = '\0';	/* remove '\n' */
  fclose(uufile);

  return(uuname);
}


/*
 * Knowhost() checks if we know a host with the given name.
 * If so, 1 is returned, else 0.
 */
int knowhost(host)
char *host;
{
  FILE *sysfile;
  char line[256];
  char *p, *q;

  if ((sysfile = fopen(LSYS, "r")) == (FILE *)NULL) return(0);
  while(fgets(line, sizeof line, sysfile) != NULL) {
	for (p = host, q = line; !isspace(*q); p++, q++)
		if (*p != *q) break;

		if ('\0' == *p && isspace(*q)) {
			fclose(sysfile);
			return(1);
		}
	}
  fclose(sysfile);
  return(0);
}


char *whoami()
{
  struct passwd *pw;

  if ((pw = getpwuid(getuid())) != (struct passwd *)NULL) return(pw->pw_name);
    else return("nobody");
}


/*
 * Read the SPOOLSEQ file and return that ID.
 */
long readseq(void)
{
  char seqline[10];			/* read buffer */
  long seq;				/* the decoded number */
  FILE *spoolseq;			/* the file pointer */
  int i;

  if (access(seqname, 0) != 0) return(-1L);

  while(link(seqname, lseqname) != 0) {
  	sleep(5);
  	if (++i > 5) return(-1L);
  }

  spoolseq = fopen(seqname, "r");
  fgets(seqline, sizeof(seqline), spoolseq);
  fclose(spoolseq);
  unlink(lseqname);

  seq = atol(seqline);		/* read the current ID */
  seq++;			/* and use next */

  return(seq);
}


/*
 * Update the SPOOLSEQ file.
 */
void writeseq(seq)
long seq;
{
  FILE *spoolseq;			/* the file pointer */
  int i;

  if (access(seqname, 0) != 0) {	/* create file, owned by UUCP */
	close(creat(seqname, 0600));
	chown(seqname, UUCPUID, UUCPGID);
  }

  while(link(seqname, lseqname) != 0) {	/* lock it */
  	sleep(5);
  	if (++i > 5) return(-1L);
  }

  /* Write new contents. */
  if ((spoolseq = fopen(seqname, "w")) != (FILE *)NULL) {
	fprintf(spoolseq, "%ld\n", seq);
	fclose(spoolseq);
  }

  unlink(lseqname);			/* remove lock */
}


/*
 * Creates a unique UUCP file name, and returns a pointer
 * to it. The filename is a combination of prefix, grade, system name
 * and a sequential number taken from SPOOLSEQ.
 */
char *genname(prefix, grade, sys)
int prefix, grade;
char *sys;
{
  static char _gen_buf[128];
  long seq;

  seq = readseq();
  if (seq == -1L) seq = 1L;
  writeseq(seq);

  if (grade == 0) sprintf(_gen_buf, "%c.%.7s%lx", prefix, sys, seq);
    else sprintf(_gen_buf, "%c.%.7s%c%lx", prefix, sys, grade, seq);

  return(_gen_buf);
}


char *filesite(name)
register char *name;
{
  static char site[SITENAMELEN];
  register char *p, *q;

  if ((p = strchr(name, '!')) == (char *)NULL) return((char *)NULL);

  q = site;
  while(name < p) *q++ = *name++;
  *q = '\0';

  return(site);
}


char *filepath(name)
register char *name;
{
  register char *p;

  if ((p = strrchr(name, '!')) == (char *)NULL) return((char *)NULL);
  return(++p);
}


char *basename(name)
register char *name;
{
  register char *p;

  if ((p = strrchr(name, '/')) == (char *)NULL) return(name);
    else return(++p);
}


/*
 * Copy stdin to a data-spoolfile.
 */
void dostdin()
{
  char name[128], spoolname[128];	/* spool data filename */
  FILE *data;			/* spool data file */
  int c;				/* char from stdin */

  strcpy(name, genname('D', 0, mysite));
  sprintf(spoolname, "%s/%s", SPOOLDIR, name);
  if ((data = fopen(spoolname, "w")) == (FILE *)NULL) {
	fprintf(stderr, "uux: can't copy stdin\n");
      	return;
  }
  while((c = getc(stdin)) != EOF) putc(c, data);
  fclose(data);

  fprintf(fdxfile, "F %s\nI %s\n", name, name);
  fprintf(fdcfile, "S %s %s %s - %s 0666\n", name, name, luser, name);
}


/*
 * Copy argument as input.
 */
void doarg(arg)
char *arg;
{
  char dname[128], spoolname[128];	/* spool data filename */
  FILE *data;				/* spool data file */
  FILE *source;				/* source data file */
  int c;				/* char from input */

  if (arg[0]=='(' && arg[strlen(arg) - 1]==')') {
	strcat(arglist, arg + 1);
      	arglist[strlen(arglist) - 1] = '\0';
  } else if (strchr(arg, '!') == (char *)NULL) strcat(arglist, arg);
	 else
         if (strcmp(filesite(arg), cmdsite) == 0) {
		strcat(arglist, filepath(arg));
	 } else
	 if (strlen(filesite(arg)) == 0) {
		strcpy(dname, genname('D', 0, mysite));
    		sprintf(spoolname, "%s/%s", SPOOLDIR, dname);

    		if (!trylink || link(filepath(arg), spoolname) < 0) {
		if ((data = fopen(spoolname, "w")) == (FILE *)NULL ||
		    (source = fopen(filepath(arg), "r")) == (FILE *)NULL) {
			fprintf(stderr,
				"uux: can't copy %s to spool directory",
		  					      filepath(arg));
	  			exit(1);
	 		}
       			while((c = getc(source)) != EOF) putc(c, data);
       			fclose(data);
       			fclose(source);
      		}
    		fprintf(fdcfile, "S %s %s %s - %s 0666\n",
			filepath(arg), dname, luser, dname);
    		fprintf(fdxfile, "F %s %s\n", dname, basename(filepath(arg)));
    		strcat(arglist, basename(filepath(arg)));
       	} else {
    		fprintf(stderr, "uux: illegal argument %s\n", arg);
    		return;
   	}

  strcat(arglist, " ");
}
  

void usage()
{
  fprintf(stderr, 
	"usage: uux [-plrv] [-g grade] [-a user] [-] host!cmd arg ...\n");
}


int main(argc, argv)
int argc; char *argv[];
{
  int c;			/* option character */
  char *p;			/* equally ubiquitous scratch pointer */
  char scratch[128];		/* scratch pad for filenames */
  char bname[32];		/* filename of B-file */
 
  umask(0137);			/* set mask to -rw-r----- */

  strcpy(mysite, uucpname());
  if (strlen(mysite) == 0) {
	fprintf(stderr, "uux: can't get my own uucpname\n");
      	exit(1);
  }
  strcpy(luser, whoami());

  opterr = 0;
  while((c = getopt(argc, argv, "lprva:g:")) != EOF) switch(c) {
	case 'r':
		nocico = nocico - 1;
		break;
	case 'g':
	  	if (isalnum(optarg[0]) && '\0' == optarg[1])
						grade = optarg[0];
	    	  else fprintf(stderr, "uux: %s: illegal grade\n", optarg);
	  	break;
	case 'l':
	  	trylink = 1;
	  	break;
	case 'p':
	  	readstdin = 1;
	  	break;
	case 'a':
	  	break;
	default:
	  	usage();
	  	exit(1);
  }

  if (optind < argc && strcmp(argv[optind], "-") == 0) {
    	++optind;
      	readstdin = 1;
  }

  if (optind >= argc) {
	usage();
      	exit(1);
  }
 
  if ((p = filesite(argv[optind])) == (char *)NULL) {
	fprintf(stderr, "uux: illegal command\n");
      	exit(1);
  }
  
  strcpy(cmdsite, p);
  if ((p = filepath(argv[optind])) == (char *)NULL) {
 	fprintf(stderr, "uux: illegal command\n");
      	exit(1);
  }
  
  strcpy(cmd, p);
  ++optind;
  if (strlen(cmdsite) == 0) {
	fprintf(stderr, "uux: local commands not implemented yet\n");
      	exit(1);
  } else if (!knowhost(cmdsite)) {
		fprintf(stderr, "uux: site %s unknown\n", cmdsite);
    	      	exit(1);
   	 }

  if ((fdcfile = fopen(mktemp(tempname), "w")) == (FILE *)NULL) {
	fprintf(stderr, "uux: can't open ");
      	perror(tempname);
        exit(1);
  }

  strcpy(bname, genname('B', grade, cmdsite));
  sprintf(scratch, "%s/%s", SPOOLDIR, bname);
  if ((fdxfile = fopen(scratch, "w")) == (FILE *)NULL) {
	fprintf(stderr, "uux: can't open ");
      	perror(scratch);
      	exit(1);
  }
  fprintf(fdcfile, "S %s X.%s %s - %s 0666\n",
			bname, &bname[2], luser, bname);
  fprintf(fdxfile, "U %s %s\nR %s\n", luser, mysite, luser);

  if (readstdin) dostdin();

  while(optind < argc)
 	doarg(argv[optind++]);

  fprintf(fdxfile, "C %s %s\n", cmd, arglist);
  fclose(fdxfile);
  fclose(fdcfile);
  sprintf(scratch, "%s/%s", SPOOLDIR, genname('C', grade, cmdsite));
  
  if (link(tempname, scratch) == 0) unlink(tempname);
    else {
    	  fprintf(stderr, "uux: couldn't rename commandfile");
    	  exit(1);
    }

  if (nocico) exit(0);
    else execl(UUCICO, UUCICO, "-r1", "-s", cmdsite, (char *)NULL);
}
