#uucico
NAME
    uucico - file transport program for the uucp system

SYNOPSIS
    /usr/lib/uucp/uucico [ -r role_number ]
	[ -x debug_level ] [ -d spool_directory ] [ -s system_name ]

DESCRIPTION
    Uucico is the file transport program for uucp work file transfers.
    The -r option should be specified  as the digit 1 for  master mode
    when uucico is  started by a  program  or cron.  Uux and uucp both
    queue jobs that  will be transferred  by uucico.  It  is  normally
    started by  the scheduler, uusched, but  can be started  manually;
    this is done for debugging.  For  example, the shell  script Uutry
    starts uucico with debugging  turned  on.  A single digit  must be
    used for the -x option with higher numbers for more debugging.

FILES
    /usr/lib/uucp/L.sys
    /usr/lib/uucp/L-devices
    /usr/spool/uucp/*
    /usr/spool/locks/LCK*
    /usr/spool/uucppublic/*

SEE ALSO
    uucp(1), uux(1), cron(1M), uutry(1M).
    *.doc in the /usr/doc/uucp directory

AUTHORS
    Richard H. Lamb
    Stuart A. Lynne
    Peter S. Housel
    Fred N.G. van Kempen

#uuxqt
NAME
    uuxqt - execute remote command requests

SYNOPSIS
    /usr/lib/uucp/uuxqt [-s system] [-x debug_level]

DESCRIPTION
    Uuxqt is the program that executes remote job requests from remo-
    te systems generated by the  use of the uux command.  Uuxqt sear-
    ches the spool directories looking for X. files.  For each X file
    uuxqt checks to see if all the required data files are  available
    and accessible, and if the requested commands are  permitted  for
    the requesting system.

FILES
    /usr/spool/uucp/*
    /usr/spool/locks/LCK*

SEE ALSO
    uucp(1), uux(1), uucico(1M).
    *.doc in the /usr/doc/uucp directory

AUTHORS
    Peter S. Housel
    Fred van Kempen

#uucp
NAME
    uucp - UNIX system to UNIX system copy

SYNOPSIS
    uucp [ options ] source-files destination-file 
DESCRIPTION
    Uucp copies files named by the source-file arguments to the desti-
    nation-file argument.  Afile name may be a pathname on your machi-
    ne, or may have the form:

    system!path-name

    where  'system'  is  taken from a list of  system names which uucp
    knows about.  System may also be a list of names such as

    system!system!...!system!path-name

    in  which  case an attempt is made to send the file via the speci-
    fied  route to the  destination.  See WARNINGS  and BUGS below for
    restrictions.  Care should  be taken  to insure  that intermediate
    nodes  in  the  route  are  willing  to  forward  information (see
    WARNINGS below for restrictions).

    The  shell metacharacters ?, * and [...] appearing  in  'pathname'
    will be expanded on the appropriate system.
    Path names may be oneof:

	(1) a full pathname;

	(2) a path namepreceded by ~user where 'user' is a login  name
	    on the specified system and is replaced by that user's
	    login directory;

	(3) a path name preceded by ~/destination where destination is
	    appended to /usr/spool/uucppublic.  NOTE: This destination
	    will be treated as a file name unless more than  one  file
	    is  being transferred by this requestor the destination is
	    already a directory.  To  ensure  that it is  a directory,
	    follow the destination with a /.  For  example, ~/dan/  as
	    the destination will make the directory

		/usr/spool/uucppublic/dan

	    if it does not exist and put the requested file(s) in that
	    directory.

	(4) anything else is prefixed by the current directory.

    If the result is an erroneous pathname for t he  remote system the
    copy will fail.  If the destination-file is a directory, the  last
    part of the source-file name is used.

    Uucp preserves execute permissions  across  the  transmission  and
    gives 0666 read and write permissions (see chmod(2)).

    The following options are interpreted by uucp:

	-c Do  not copy local file to the spool directory for transfer
	   to the remote machine (default).

	-C Force  the  copy  of local files to the spool directory for
	   transfer.

	-d Make all necessary directories for the file copy (default).

	-f Do not make intermediate directories for the file copy.

	-ggrade
	  Grade is a single letter/number; lower ASCII sequence
	  characters will cause the job to be transmitted earlier
	  during a particular conversation.

	-j Output the job identification ASCII string on the standard
	   output.

	-mfile Send mail to the requester when the copy is completed.

	-nuser Notify user on the remote system that a file was sent.

	-r Queue job but do not start the file transfer process.

	-sfile Report status of the transfer to file. Note that the
	 file must be a full path name.

	-xdebug_level
	 Produce debugging output on standard output.  the debuglevel
	 is a number between 0 and 9; higher numbers give more detailed
	 information.

FILES
    /usr/spool/uucp          spool directory
    /usr/spool/uucppublic/*  public directory for receiving and sending
    /usr/lib/uucp/*          other data and program files

SEE ALSO
    mail(1), uustat(1), uux(1), uucico(1M) and uuxqt(1M).
    *.doc in the /usr/doc/uucp directory

WARNINGS
    The domain of remotely accessible files can (and for obvious secu-
    rity  reasons, usually  should) be  severely restricted.  You will
    very likely not be able to fetch files by path name; ask a respon-
    sible  person on  the remote system  to send them to you.  For the
    same reasons, you will probably not be able to send files to arbi-
    trary path names.  As distributed, the  remotely  accessible files
    are those whose names begin with

	/usr/spool/uucppublic	(equivalent to ~/).

    All files received by uucp will be owned by uucp.

    The -m  option will  only work sending files or receiving a single
    file.  Receiving multiple files specified by special shell charac-
    ters ? * [...] will not activate the -m option.

    The forwarding of files through other systems may not be compatib-
    le with previous  versions  of  uucp.  If  forwarding is used, all
    systems in the route must have the same version of uucp.

BUGS
    Protected  files and  files that are in protected directories that
    are not owned by the requestor cannot be sent by uucp.  Also, many
    of the options  described  above do  not  yet perform the function
    they  are  supposed  to perform.  Uucp is very much in the "alpha"
    stage of development.

#uuname,hostname
NAME
    Uuname - print names of accessible UUCP sites
    Hostname - print name of this UUCP site

SYNOPSIS
    uuname
    hostname

DESCRIPTION
    Uuname scans the Systems file (/usr/lib/uucp/L.sys) for the  names
    of all  callable UUCP systems, and displays these names.  Hostname
    displays  the name of this system, which is contained in the  file
    /etc/uucpname.

FILES
    /usr/lib/uucp/L.sys
    /etc/uucpname

SEE ALSO
    uucp(1), uux(1), uucico(1M).
    *.doc in the /usr/doc/uucp directory

AUTHOR
    Fred van Kempen, MicroWalt Corporation

#uux
NAME
    uux - UNIX-to-UNIX system command execution

SYNOPSIS
    uux [ options ] command-string

DESCRIPTION
   Uux will  gather  zero or more files from various systems, execute a
   command  on a  specified system  and  then send standard output to a
   file  on a specified system.  Note that, for security reasons,  many
   installations will  limit  the list of commands executable on behalf
   of an incoming request from uux. Many sites will  permit little more
   than the receipt of mail and news via uux.

   The  command-string  is  made  up of one or more arguments that look
   like a  shell command  line, except that  the command and file names
   may be prefixed  by  system-name!.  A null systemname is interpreted
   as the local system.

   File names may be one of

   (1) A full path name

   (2) A path name preceded by ~x where x is a login name on the speci-
       fied system and is replaced by that user's login directory

   (3) Anything else is prefixed by the current directory.

   Any special shell characters such as <>;| should be quoted either by
   quoting the entire command-string, or quoting the special characters
   as individual arguments.

   Uux  will  attempt  to  get  all files to the execution system.  For
   files  which  are  output files, the file name must be escaped using
   parentheses.

   Uux  will  notify  you if the requested command on the remote system
   was disallowed.  This notification can be turned off by the -n option.
   The response comes by remote mail from the remote machine.

   The following options are interpreted by uux:

   -	    The standard input to uux is made the standard input to the
	    command-string.

   -aname   Use name as the user identification replacing the initiator
	    user-id. (Notification will be returned to the user.)

   -b       Return standard input to the command if the exit status is
	    nonzero.

   -c       Do not copy local file to the spool directory for transfer
	    to the remote machine (default).

   -C       Force the copy of local files to the spool directory for
	    transfer.

   -ggrade  Grade is a single letter/number; lower ASCII sequence
	    characters will cause the job to be transmitted earlier
	    during a particular conversation.

   -j       Output the jobid ASCII string on the standard output
	    which is the job identification.

   -n       Do not notify the user if the command fails.

   -p       Same as -: The standard input to uux is made the standard
	    output to the command-string.

   -r       Do not start the file transfer, just queue the job.

   -sfile   Report status of the transfer in file.

   -xdebug_level
	    Produce debugging output on the standard output.  The debug-
 	    level is a number between 0 and 9; higher numbers give more
	    detailed information.

   -z       Send success notification to the user.

FILES
    /usr/spool/uucp/* spool directory
    /usr/lib/uucp/* other data and programs

SEE ALSO
    mail(1), uucp(1C), uustat(1C).
    *.doc in the /usr/doc/uucp directory

#uuclean
NAME
    uuclean - clean up the UUCP lock files.

SYNOPSIS
    uuclean

DESCRIPTION
    Uuclean is a small shell script that will remove ALL present file
    locks in the UUCP LOCKS directory (which is defined in the script
    itself). Note, that it is a very DUMB script; just have a look at
    it.

SEE ALSO
    uucp(1), uux(1), uucico(1M).
    *.doc in the /usr/doc/uucp directory

AUTHOR
    Fred van Kempen, MicroWalt Corporation

#uutry
NAME
    uutry - try to contact a remote system with debugging on.

SYNOPSIS
    uutry system_name

DESCRIPTION
    Uutry is a small shell script that tries to call a remote system
    with debugging turned on. This may be helpful in tracking down
    connection problems.  Note, that it is a very DUMB script; just
    have a look at it.

SEE ALSO
    uucp(1), uux(1), uucico(1M).
    *.doc in the /usr/doc/uucp directory

AUTHOR
    Fred van Kempen, MicroWalt Corporation

