#include <sys/types.h>
#include <stdio.h>
#include <sgtty.h>
#include <dial.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include "modemcap.h"

static char lockfile[64];
static int modemfd = -1;
extern int merrno;


static int findline(callp, brand)
CALL *callp;
char *brand;
{
  int exists = 0;			/* device exists at some baud rate */
  int tried = 0;			/* found a device but it was locked */
  static char l_line[DVC_LEN+1];	/* tty device name */
  char l_type[DVC_LEN+1];		/* ACU, DIR, etc. */
  int l_baud;				/* tty baud rate */
  char buf[128];			/* L-devices line buffer */
  FILE *fp;				/* L-devices file pointer */
  int fd;				/* device lock file descriptor */

  if ((fp = fopen(LDEVS, "r")) == NULL) return(merrno = NO_Ldv);

  while (fgets(buf, sizeof(buf), fp) != NULL) {
	if (buf[0] == '#') continue;		/* ignore comment lines */

	if (sscanf(buf, "%s%s%*s%d%s", l_type, l_line, &l_baud,
			brand) != 4) continue;	/* mangled line */

	if (callp->telno != NULL) {		/* we're going to dial */
		if (strcmp(l_type, "ACU") != 0)
			continue; /* not a dialer line */

		if (callp->line != NULL)	/* device specified? */
			if (strcmp(l_line, callp->line) != 0)
				continue;	/* wrong device */

		exists++;	/* say device exists at some baud rate */

		if (l_baud != callp->speed)
			continue;	/* does it use the right speed?	*/
	} else if (callp->line != NULL) {
			if (strcmp(l_type, "DIR") != 0)
				continue;	/* not a direct-line */

#ifdef __LALA
			if (strcmp(l_line, callp->line) != 0)
				continue;	/* wrong device	*/
#endif
			callp->baud = l_baud;	/* use line's baud rate */
	}

	++tried;		/* found device at desired baud rate */
	strcat(strcpy(lockfile, LOCK), l_line);

	if (access(lockfile, 0) == 0 || (fd = creat (lockfile, 0640)) == -1)
		continue;			/* couldn't create lock */

	close(fd);		/* created lock, now close descriptor */
	fclose(fp);
	callp->line = l_line;
	return(1);
  }

 if (tried) return(merrno = DV_NT_A);
   else if (exists) return(merrno = ILL_BD);
          else return(merrno = DV_NT_K);
}


static struct speedlist {
  int value;
  int name;
} speeds[] = {
  {    0,      0 },
  {  110,   B110 },
  {  300,   B300 },
  { 1200,  B1200 },
  { 2400,  B2400 },
  { 4800,  B4800 },
  { 9600,  B9600 },
#if defined(B19200)
  {19200, B19200 },
#endif B19200
  {   -1,     -1 }
};


static int findspeed(speed)
int speed;
{
  register struct speedlist *ps;

  for (ps = speeds; ps->value >= 0; ps++)
	if (ps->value == speed) return(ps->name);

  return(0);
}


#ifdef CATCH
int alarmcatch(void)
{
  long timebuf[2];

  time(&timebuf[0]);
  timebuf[1] = timebuf[0];

  utime(lockfile, timebuf);
  signal(SIGALRM, alarmcatch);
  alarm(3600);
}


int hupcatch(void)
{
  close(modemfd);
  unlink(lockfile);
  signal(SIGHUP, SIG_DFL);
}
#endif CATCH


int dial(call)
CALL *call;
{
  char modemline[64];		/* device name */
  char modemname[16];		/* modemcap name of modem */
  char *strcpy(), *strcat();
#ifdef	UNIX_S5
  struct termio termio;
#endif
#ifdef	UNIX_V7
  struct sgttyb termio;
#endif
  int fd;
  int err;

  modemname[0] = '\0';

  fd = -1;		/* channel illegal until line is opened	*/

  if ((err = findline(call, modemname)) <= 0) goto error;

  if (modemname[0] == '\0') { /* can't determine the type of modem */
	printf("can't determine modem type\n");
	err = DV_NT_K;
	goto error;
  }

  strcat(strcpy(modemline, DEVDIR), call->line);
  if ((fd = open(modemline, O_RDWR)) < 0) { /* can't open modem line */
	err = L_PROB;
	goto error;
  }
#ifdef	UNIX_S5
  if (call->attr != (struct termio *) 0) { /* set attributes */
	if (ioctl(fd, TCSETA, call->attr) == -1) { /* some ioctl() problem */
		err = L_PROB;
		goto error;
	}
  } else {
	  ioctl(fd, TCGETA, &termio);
	  if ((termio.c_cflag = findspeed(call->baud)) == 0) {
		err = ILL_BD;
		goto error;
	  }
	  termio.c_cflag |= (CS8 | CREAD | HUPCL);
	  termio.c_iflag = 0;
	  termio.c_oflag = 0;
	  termio.c_lflag = 0;
	  termio.c_cc[VMIN] = 1;
	  termio.c_cc[VTIME] = 1;
	  if (ioctl(fd, TCSETA, &termio) == -1) {
		err = L_PROB;
		goto error;
	  }
  }
#endif
#ifdef	UNIX_V7
  if (call->attr != (struct sgttyb *) 0) { /* set attributes */
	if (ioctl(fd, TIOCGETP, call->attr) == -1) { /* some gtty() problem */
		err = L_PROB;
		goto error;
	}
  } else {
	  ioctl(fd, TIOCGETP, &termio);
	  if ((termio.sg_ispeed = findspeed(call->baud)) == 0) {
		err = ILL_BD;
		goto error;
	  }
	  termio.sg_ospeed = termio.sg_ispeed;
	  termio.sg_flags |= RAW;
	  termio.sg_flags &= ~ECHO;
	  termio.sg_erase = -1;
	  termio.sg_kill = -1;
	  if (ioctl(fd, TIOCSETP, &termio) == -1) {
			err = L_PROB;
			goto error;
	  }
  }
#endif
  initmodem(modemname, fd);	/* setup modemcap variables */
  if (call->telno == NULL)	/* no phone number, connection complete */
			goto okay;

  if (! DI) {			/* modem has no ACU!!! */
	err = A_PROB;		/* no ACU to attach to */
	goto error;
  }
  if (BD != call->baud) {	/* is connection desired at high speed? */
	if (BL != call->baud){	/* is connection desired at low speed? */
		err = ILL_BD;	/* modem can't handle this speed */
		goto error;
	}
	BD = BL;		/* set baud to low baud rate */
	CO = CL;		/* set connect reply to low baud reply */
  }
  if (err = mdial(call->telno, fd)) 	/* some error trying to dial */
				goto error;
#ifdef CATCH
  signal(SIGALRM, alarmcatch);	/* set catcher for ALARM clock */
  signal(SIGHUP, hupcatch);	/* set catcher for HANG UP */
  alarm(3600);			/* set clock to touch lock in 1 hour */
#endif CATCH

okay:
  return(modemfd = fd);

error:
  if (lockfile[0])		/* don't unlink '.'! */
	unlink(lockfile);
  if (fd > 2) close(fd);
  return(merrno = err);
}


void undial(fd)
int fd;
{
  if (fd > 2) close (fd);

  if (lockfile[0]) unlink(lockfile);
#ifdef CATCH
  alarm(0);
#endif CATCH
}
