/* Interface control structure */
struct interface {
	struct interface *next;	/* Linked list pointer */
	char *name;		/* Ascii string with interface name */
	int16 mtu;		/* Maximum transmission unit size */
	int (*send)();		/* Routine to call to send IP datagram */
	int (*output)();	/* Routine to call to send raw packet */
	int (*recv)();		/* Routine to kick to process input */
	int (*stop)();		/* Routine to call before detaching */
	int16 dev;		/* Subdevice number to pass to send */
	int16 flags;		/* State of interface */
#define	IF_ACTIVE	0x01
#define	IF_TAKENF	0x02	/* Accept packets marked "no forwarding"*/
#define	IF_BROADCAST	0x04	/* Interface is capable of broadcasting */
};
#define	NULLIF	(struct interface *)NULL
extern struct interface *ifaces;	/* Head of interface list */
