/* Control field templates */
#define	I	0x00	/* Information frames */
#define	S	0x01	/* Supervisory frames */
#define	RR	0x01	/* Receiver ready */
#define	RNR	0x05	/* Receiver not ready */
#define	REJ	0x09	/* Reject */
#define	U	0x03	/* Unnumbered frames */
#define	SABM	0x2f	/* Set Asynchronous Balanced Mode */
#define	DISC	0x43	/* Disconnect */
#define	DM	0x0f	/* Disconnected mode */
#define	UA	0x63	/* Unnumbered acknowledge */
#define	FRMR	0x87	/* Frame reject */
#define	UI	0x03	/* Unnumbered information */
#define	PF	0x10	/* Poll/final bit */

/* FRMR reason bits */
#define	W	1	/* Invalid control field */
#define	X	2	/* Unallowed I-field */
#define	Y	4	/* Too-long I-field */
#define	Z	8	/* Invalid sequence number */

/* Format of an AX.25 address - left-shifted callsign plus sub station ID */
#define	ALEN	6	/* Number of chars in callsign field */
struct addr {
	char call[ALEN];	
	char ssid;
};

/* SSID address byte definitions */
#define	SSID		0x1e	/* Sub station ID */
#define	REPEATED	0x80	/* Has-been-repeated bit in repeater field */
#define	E		0x01	/* Address extension bit */
#define	C		0x80	/* Command/response designation */

#define	UNKNOWN		0
#define	COMMAND		1
#define	RESPONSE	2

#define	PID_ARP		0xcd	/* AX.25 Level 3 PID for ARP */
#define	PID_IP		0xcc	/* AX.25 Level 3 PID for IP */
#define	AXALEN		7	/* AX.25 address length (7 bytes) */

/* AX.25 broadcast address: "QST   -0" in shifted ASCII */
extern struct addr ax25_bdcst;
