/* fonted.c:
 *	Tiny font editor for minix-V by takamiti@mix
 */

#include <stdio.h>
#include <sgtty.h>
#include <minix/font.h>

#define EDITOR		"elle"
#define VIEW_XTOP	10
#define VIEW_YTOP	6
#define EDIT_XTOP	55
#define EDIT_YTOP	6
#define MEMO_YTOP	24
#define PROMPTLINE	29

#define clrscr()	printf("\033[2J")
#define clreos()	printf("\033[J")
#define gotoxy(x, y)	printf("\033[%d;%dH", y, x)
#define promptat(x,y,s) printf("\033[%d;%dH%s\033[K", y, x, s);
#define txDotOn()	printf("")
#define txDotOff()	printf("")
#define between(c, l, u) (unsigned short)((c)-(l) <= ((u)-(l)))

char plotcom[] =	"1234";
#define High_Y		plotcom[0]
#define Low_Y		plotcom[1]
#define High_X		plotcom[2]
#define Low_X		plotcom[3]
#define GrPlotModeOn()	putchar('\034')
#define GrPlotModeOff() putchar('\030')
#define GrPlot()	puts(plotcom)

struct sgttyb old;
struct sgttyb new;
int con;
struct sbc_font fontbuf;
char bitmap[SBC_FONT_HIGH][SBC_FONT_WIDTH];
int top_ch = 0;
int end_ch = 255;
int ch_offset = 0;


main(ac, av)
int ac;
char *av[];
{
    int fd, code, i, s_flag, h_flag;
    char *infile, *outfile;

    if ((ac-1) % 2) {
	puts("Illegal arguments");
	exit(1);
    }
    infile = "/dev/sbcfont";
    outfile = "/dev/null";
    s_flag = 0;
    for(i=1; i<ac; i++) {
	if      (strcmp("-e", av[i]) == 0) infile = av[++i];
	else if (strcmp("-s", av[i]) == 0) { infile = av[++i]; s_flag=1; }
	else if (strcmp("-o", av[i]) == 0) outfile = av[++i];
    }

    if (load(infile, 0) == 0) {
	printf("read error %s\n", infile);
	exit(1);
    }
    con = open("/dev/tty", 0);
    ioctl(con, TIOCGETP, &old);
    ioctl(con, TIOCGETP, &new);
    new.sg_flags &= ~(ECHO | EVENP);
    new.sg_flags |= (CBREAK | ODDP);
    ioctl(con, TIOCSETP, &new);
    /* signal(SIGINT, intr_proc); */

    showall();
    if (!s_flag) {
	do {
	    code = select();
	    if (code < 0) break;
	    expansion(code);
	    i = edit(code);
	    if (i) reduction(code);
	} while (i >= 0);
    }
    ioctl(con, TIOCSETP, &old);
    if (!s_flag && code != -2) save(outfile);
    gotoxy(0,29);
}

draw_ch(code)
unsigned char code;
{
    int x, y, gx, gy, i, mask;
    char *p;

    x = code & 0x0f;
    y = (code >> 4) & 0x0f;
    gotoxy(VIEW_XTOP+x*2+1, VIEW_YTOP+y);
    putchar(' ');
    fflush(stdout);
    gy = 479 - (VIEW_YTOP+y - 1) * SBC_FONT_HIGH;
    p = &fontbuf.patern[code * SBC_FONT_SIZE];
    GrPlotModeOn();
    for(i=0; i<16; i++, p++, gy--) {
	High_Y = ((gy >> 5) & 0x1f) | 0x20;
	Low_Y  = (gy & 0x1f) | 0x60;
	gx = (VIEW_XTOP+x*2) * SBC_FONT_WIDTH;
	for(mask=0x80; mask; mask >>= 1, gx++) {
	    if (*p & mask) {
		High_X = ((gx >> 5) & 0x1f) | 0x20;
		Low_X  = (gx & 0x1f) | 0x40;
		GrPlot();
	    }
	}
    }
    GrPlotModeOff();
    fflush(stdout);
}

showall()
{
    int x, y;
    char *p;
    unsigned char c;

    clrscr();
    gotoxy(VIEW_XTOP-3, VIEW_YTOP-2);
    printf("  | 0 1 2 3 4 5 6 7 8 9 A B C D E F");
    gotoxy(VIEW_XTOP-3, VIEW_YTOP-1);
    printf("--+--------------------------------");
    for(y = 0; y < 16; y++) {
	c = (y & 0xff) << 4;
	gotoxy(VIEW_XTOP-3, VIEW_YTOP+y);
	printf("%02x|", c);
	for(x = 0; x < 16; x++, c++)
	    draw_ch(c);
    }
    gotoxy(0, MEMO_YTOP-1);
    puts("[MEMO]");
    y=0;
    p = fontbuf.head.memo;
    while(y < 5 && *p) {
	putchar(*p);
	if (*p == '\n') y++;
        p++;
    }
}

int select()
{
    static int x=0;
    static int y=0;
    int mark_blk=0;
    int i;
    char c, kbuf[100];

    while(1) {
	gotoxy(x + VIEW_XTOP+1, y + VIEW_YTOP);
	c = getchar();
	switch (c) {
	case '\n':
	    if (!mark_blk)
		return(((y & 0xff) << 4) + (x / 2) & 0xff);
	    if (top_ch > y) {
		end_ch = top_ch;
		top_ch = y;
	    } else
		end_ch = y;
	    for(i=top_ch; i<=end_ch; i++) {
		gotoxy(VIEW_XTOP-5, i + VIEW_YTOP);
		printf(">>");
	    }
	    top_ch <<= 4;
	    end_ch <<= 4;
	    end_ch += 15;
	    mark_blk = 0;
	    break;
	case '/':	/* command */
	    c = command();
	    switch(c) {
	    case 'b':	/* block marking command */
		for(i=0; i<16; i++) {
		    gotoxy(VIEW_XTOP-5, i + VIEW_YTOP);
		    printf("  ");
		}
		gotoxy(VIEW_XTOP-5, y + VIEW_YTOP);
		printf(">>");
		mark_blk = 1;
		top_ch = y;
		break;
	    case 'l':	/* load font file */
		if (readln("load font: ", kbuf) > 0)
		    if (load(kbuf, 0)) showall();
		break;
	    case 'i':
	    case 'c':	/* combine command */
		if (readln("combine with: ", kbuf) > 0) {
		    if (load(kbuf, (y<<4)+((c=='i') ? 1: 2))) goto SELALL;
		}
		break;
	    case 'd':
		i = end_ch - top_ch;
		/* if (i == 255)  break; */
		memset(&fontbuf.patern[top_ch * SBC_FONT_SIZE], 0,
						(i+1) * SBC_FONT_SIZE);
SELALL:
	    case 'a':
		top_ch = 0;
		end_ch = 255;
		showall();
		break;
	    case 'n':
		note();
		break;
	    case 's':
		if (readln("save as: ", kbuf) > 0)
		    save(kbuf);
		break; /*
	    case 'O':
		if (readln("char offset: 0x", kbuf) > 0) {
		    sscanf(kbuf, "%x", &ch_offset);
		    if (end_ch + ch_offset > 255) ch_offset = 0;
		}
		break; */
	    case 'q':	/* quit */
		return(-1);
	    }
	    break;
	case '\033':
	    c = getchar();
	    switch(c) {
	    case '\033':
		return(-2);
	    case '[':
		c = getchar();
		switch(c) {
		case 'D': /* left */
			if (x > 0) x-=2;
			break;
	    	case 'A': /* up */
			if (y > 0) y--;
			break;
		case 'B': /* down */
			if (y < 15) y++;
			break;
		case 'C': /* right */
			if (x < 30) x+=2;
			break;
		case 'Y':
			return(-1);
		}
	    }
	}
    }
}

dotchar()
{
    int x, y;

    for(y=0; y < SBC_FONT_HIGH; y++)
	for(x=0; x < SBC_FONT_WIDTH; x++) {
	    gotoxy(x*2 + EDIT_XTOP, y+EDIT_YTOP);
	    if (bitmap[y][x]) txDotOn();
	    else txDotOff();
	}
}

int edit(code)
int code;
{
    int x, y, i;
    char c, *p;
    char kbuf;

    dotchar();
    gotoxy(EDIT_XTOP, EDIT_YTOP-2);
    printf("char code = 0x%02x", code);
    gotoxy(EDIT_XTOP, EDIT_YTOP-1);
    printf("----------------");

    y = 0;
    x = 0;
    while(1) {
	gotoxy(x*2 + EDIT_XTOP, y+EDIT_YTOP);
	c = getchar();
	switch (c) {
	case ' ':
	    bitmap[y][x] ^= 1;
	    if (bitmap[y][x]) txDotOn();
	    else txDotOff();
	    break;
	case '\n':
	    return(1);
	case '/':
	    c = command();
	    switch(c) {
	    case 'c':
		memset(bitmap, 0, SBC_FONT_HIGH*SBC_FONT_WIDTH);
		dotchar();
		break;
	    case 'p':
		if (readln("paste from: 0x", kbuf) > 0) {
		    sscanf(kbuf, "%x", &i);
		    i &= 0x7f;
		    if (i > 0xff) break;
		    expansion(i);
		    dotchar();
		}
		break;
	    case 'r':
	        for(i=0,p=bitmap; i<SBC_FONT_HIGH*SBC_FONT_WIDTH; i++,p++)
		    *p ^= 1;
		dotchar();
		break;
	    }
	    break;
	case '\033':
	    c = getchar();
	    switch(c) {
	    case '[':
		c = getchar();
		switch(c) {
	    	case 'A': /* up */
			if (y > 0) y--;
			break;
		case 'B': /* down */
			if (y < SBC_FONT_HIGH-1) y++;
			break;
		case 'C': /* right */
			if (x < SBC_FONT_WIDTH-1) x++;
			break;
		case 'D': /* left */
			if (x > 0) x--;
			break;
/*		case 'Y':
			return(-1);
*/		}
		break;
	    case '\033': /* esc */
		return(0);
		break;
	    }
	}
    }
}

expansion(code)
int code;
{
    int i,j, mask;
    char *p;

    p = (char *)&fontbuf.patern[code * SBC_FONT_SIZE];
    for(i = 0; i < SBC_FONT_HIGH; i++, p++)
	for(mask = 0x80, j = 0; j < SBC_FONT_WIDTH; j++, mask >>= 1)
	    bitmap[i][j] = (*p & mask) ? 1: 0;
} 

reduction(code)
int code;
{
    int i, j, mask;
    char chbit, p[SBC_FONT_SIZE];

    for(i = 0; i < SBC_FONT_HIGH; i++) {
	for(chbit = 0, mask = 0x80, j = 0; j < SBC_FONT_WIDTH; j++, mask >>= 1)
	    if (bitmap[i][j]) chbit |= mask;
	p[i] = chbit;
    }
    memcpy(&fontbuf.patern[code * SBC_FONT_SIZE], p, SBC_FONT_SIZE);
    draw_ch(code);
}

save(file)
char *file;
{
    int fd, size, i;
    long sum;
    short *ip;

    fontbuf.head.fnt_size = SBC_FONT_SIZE;
    fontbuf.head.fnt_high = SBC_FONT_HIGH;
    fontbuf.head.fnt_width = SBC_FONT_WIDTH;
    fontbuf.head.top_code = top_ch + ch_offset;
    fontbuf.head.end_code = end_ch + ch_offset;
    sum = 0L;
    ip = (short *)&fontbuf;
    for(i=0; i < ((FONT_HEAD_SIZE - 4) /2); i++, ip++) sum += (long)*ip;
    fontbuf.head.sum = sum;
    size = (end_ch - top_ch + 1) * SBC_FONT_SIZE;
    if (top_ch != 0)
	memcpy(&fontbuf.patern[0],&fontbuf.patern[top_ch*SBC_FONT_SIZE],size);
    size += FONT_HEAD_SIZE;
    fd = creat(file, 0644);
    if ((fd < 0) ||
	(write(fd, &fontbuf, size) != size)) {
	perror(file);
	return(-1);
    }
    close(fd);
    sync();
}

int load(file, flag)
char *file;
int flag;
{
    int fd, hsize, size, i, ofs;
    short *ip;
    long sum;
    char tmp[512];

    ofs = flag & 0xf0;
    flag &= 0x0f;
    switch(flag) {
	case 0: memset(&fontbuf, 0, SBC_STRUCT_SIZE); break;
	case 1: 
	case 2: memcpy(tmp, fontbuf.head.memo, FH_MEMO_SIZE); break;
    }
    fd = open(file, 0);
    if ((fd < 0) || ((hsize = read(fd, &fontbuf, FONT_HEAD_SIZE)) < 0))
	return(0);
    sum = 0L;
    ip = (short *)&fontbuf;
    for(i=0; i < ((FONT_HEAD_SIZE - 4) /2); i++, ip++) sum += (long)*ip;
    if (fontbuf.head.sum == sum) {
	switch(flag) {
	case 1:	top_ch = ofs;
		size = (256 - ofs) * SBC_FONT_SIZE;
		break;
	case 0:
	case 2: top_ch = fontbuf.head.top_code;
		end_ch = fontbuf.head.end_code;
		size = (end_ch - top_ch + 1) * SBC_FONT_SIZE;
	}
	if (read(fd, &fontbuf.patern[top_ch*SBC_FONT_SIZE], size) < 0)
	    return(0);
    } else {
	if (flag == 0) {
	memcpy(&fontbuf.patern[top_ch*SBC_FONT_SIZE], &fontbuf, hsize);
	memset(&fontbuf, 0, FONT_HEAD_SIZE);
	if ((size = read(fd, &fontbuf.patern[top_ch*SBC_FONT_SIZE]+hsize,
				 SBC_STRUCT_SIZE-FONT_HEAD_SIZE-hsize)) < 0)
	    return(0);
	end_ch = (size+hsize) / SBC_FONT_SIZE - 1;
	}
    }
    if (flag) memcpy(fontbuf.head.memo, tmp, FH_MEMO_SIZE);
    return(1);
}

sw_echo()
{
    gotoxy(0, PROMPTLINE);
    clreos();
    new.sg_flags ^= (ECHO | CBREAK);
    ioctl(con, TIOCSETP, &new);
}

int readln(prompt, kbuf)
char *prompt, *kbuf;
{
    sw_echo();
    printf("%s", prompt);
    gets(kbuf);
    sw_echo();
    return(strlen(kbuf));
}

int command()
{
    char c;

    gotoxy(0, PROMPTLINE);
    printf("Command>");
    clreos();
    c = getchar();
    /* putchar(c); */
    gotoxy(0, PROMPTLINE);
    clreos();
    return(c&0x7f);
}

/* local commands */
note()
{
    char *tempfile = "/tmp/fed.XXXXXX";
    char *p;
    int fd, len;
    char cmdbuf[80];

    for(len = 0, p = fontbuf.head.memo; *p && len < FH_MEMO_SIZE; p++, len++);
    mktemp(tempfile);
    fd = creat(tempfile, 0644);
    if ((fd < 0) || (write(fd, fontbuf.head.memo, len) < 0)) {
	/* unlink(tempfile); */
	return;
    }
    close(fd);
    sprintf(cmdbuf, "%s %s", EDITOR, tempfile);
    clrscr();
    ioctl(con, &old);
    system(cmdbuf);
    ioctl(con,&new);
    memset(fontbuf.head.memo, 0, FH_MEMO_SIZE);
    fd = open(tempfile);
    read(fd, fontbuf.head.memo, FH_MEMO_SIZE - 1);
    close(fd);
    unlink(tempfile);
    sprintf(cmdbuf, "%s.bak", tempfile);
    unlink(cmdbuf);
    showall();
}
