|  mini boot loader Ver2.01:
|  MINIX Hard Disk BootUp utility for the IBM PC/AT & compatibles
|						Auther: takamiti@mix

#define		retf	.byte 0xCB

BYTE_		= 1
WORD_		= 2
LONG_		= 4

NULL		= 0x00
CR		= 0x0D
LF		= 0x0A

LOADSEG		= 0x0060

DISKBIOS	= 0x13
KEYBIOS		= 0x16
VIDEOBIOS	= 0x10
BLOCKSIZE	= 1024
READBLOCK	= 0x0202
IPLMAGIC	= 0xAA55

V1_SUPERMAGIC	= 0x137F		| magic number for V1 file system
V2_SUPERMAGIC	= 0x2468		| magic number for V2 file system
	
KEYBUFF		= 0
STACK		= 1024
DISKBUF		= STACK   + BLOCKSIZE
INODETBL	= DISKBUF + BLOCKSIZE
WORKAREA	= STACK   + BLOCKSIZE - 64
STACKTOP	= WORKAREA - 2

FINAL		= 502
MENU_DS		= FINAL + WORD_
MENU_IP		= MENU_DS + WORD_
MENU_CS		= MENU_IP + WORD_
MENU_MAGIC	= MENU_CS + WORD_
Menu_Final	= DISKBUF + FINAL
Menu_Ds		= Menu_Final + WORD_

OPENMSGENTRY	= 2
open_msg	= DISKBUF + OPENMSGENTRY
DS_open_msg	= DISKBUF / 16

|	struct SuperBlock
S_NR_INODE	= 0
S_NR_ZONE	= 2
S_INODE_MAP	= 4
S_ZONE_MAP	= 6
S_FIRSTDATA	= 8
S_LOG2		= 10
S_MAXFILE	= 12
S_MAGIC		= 16
SuperMagic	= DISKBUF + S_MAGIC

|	struct V1_InodeEntry
V1_MODE		= 0
V1_UID		= 2
V1_FSIZE	= 4
V1_TIME		= 8
V1_LINKS	= 10
V1_GID		= 12
V1_ZONE0	= 14
V1_ZONE1	= 16
V1_ZONE2	= 18
V1_ZONE3	= 20
V1_ZONE4	= 22
V1_ZONE5	= 24
V1_ZONE6	= 26
V1_ZONE7	= 28
V1_ZONE8	= 30
V1_INODESIZE	= 32

|	struct V2_InodeEntry
V2_MODE		= 0
V2_LINKS	= 2
V2_UID		= 4
V2_GID		= 6
V2_FSIZE	= 8
V2_ATIME	= 12
V2_MTIME	= 16
V2_CTIME	= 20
V2_ZONE0	= 24
V2_ZONE1	= 28
V2_ZONE2	= 32
V2_ZONE3	= 36
V2_ZONE4	= 40
V2_ZONE5	= 44
V2_ZONE6	= 48
V2_ZONE7	= 52
V2_ZONE8	= 56
V2_ZONE9	= 60
V2_INODESIZE	= 64

|	struct DirEntry
INODE		= 0
NAME		= 2

|	variables
offset_L	= WORKAREA
offset_H	= offset_L + WORD_
trk_size	= offset_H + WORD_
cyl_size	= trk_size + WORD_
drive		= cyl_size + WORD_
partition	= drive + BYTE_
sect_L		= partition + BYTE_
sect_H		= sect_L + WORD_
retrys		= sect_H + WORD_
inode_start	= retrys + WORD_
last_block	= inode_start + WORD_
menu_ds		= last_block + WORD_
menu_pc		= menu_ds + WORD_
tracksize	= menu_pc + LONG_
ENDWORK		= tracksize + WORD_

#ifdef ASLD
.globl begtext, begdata, begbss, endtext, enddata, endbss
#endif

.text
begtext:

.data
begdata:

.bss
begbss:

.text

#ifndef ASLD
entry	crtso
#endif

|	HD preBoot loader
crtso:		mov	dx,(si)
		orb	dl,*0x80
		mov	cx,2(si)
		int	0x12
		shr	ax,*1
		shr	ax,*1
		dec	ax
		xchgb	al,ah
		mov	es,ax
		mov	ax,#READBLOCK
		xor	bx,bx
		int	DISKBIOS
		jc	booterr
		push	es
		mov	ax,#start
		push	ax
		retf

booterr:	push	ax
		call	error

hex2:		push	ax
		movb	cl,*4
		shrb	al,cl
		call	hex1
		pop	ax
hex1:		and	ax,#0x000F
		addb	al,*0x30	| '0'
		cmpb	al,*0x3A	| '9'+1
		jc	hex0
		addb	al,*7
hex0:		call	putch
		ret

putstr:		lodb
		orb	al,al
		jz	ext_putc
		call	putch
		j	putstr
putBS:		call	putch
		movb	al,*0x20
		call	putch
		movb	al,*8
putch:		push	bx
		movb	ah,*14
		mov	bx,#1
		push	bp
		int	VIDEOBIOS
		pop	bp
		pop	bx
ext_putc:	ret

#ifdef DEBUG
error:
dump:		mov	si,#DISKBUF
dump1:		mov	cx,#20
_dmp0:		push	cx
		mov	cx,#16
_dmp1:		push	cx
		lodb
		call	hex2
		lodb
		call	hex2
		pop	cx
		movb	al,*0x20
		call	putch
		loop	_dmp1
		pop	cx
		loop	_dmp0
		hlt
Halt:		j	Halt
#else
error:		mov	si,#Fatal
		call	putstr
		xor	bp,bp
dump:		pop	ax
		push	ax
		movb	al,ah
		call	hex2
		pop	ax
		call	hex2
		movb	al,*0x20
		call	putch
		inc	bp
		cmp	bp,*4
		jc	dump
		mov	si,#ReBootMsg
rebootmsg:	call	putstr
		hlt
Halt:		j	Halt
|
Fatal:		.byte	CR, LF
		.ascii	"Fatal "
		.byte	NULL
Nofile:		.byte	CR, LF
		.ascii	"No file."
ReBootMsg:	.ascii	" Please reboot"
		.byte	NULL
#endif

|****************************************************************************
|			Start HD-boot procedure
|****************************************************************************
start:		cli
		mov	ax,cs
		mov	es,ax
		mov	ss,ax			| cs = es = ss
		mov     sp,#STACKTOP		| initialize sp
		sti
		cld

		mov	di,si
		mov	cx,#4
_loop1:		add	di,*16
		cmp	(di),#IPLMAGIC
		jz	getparam
		loop	_loop1
fs_err:		call	error

getparam:	mov	dx,(si)			| dirve number
		mov	ax,8(si)
		mov	bx,10(si)
		push	cs
		pop	ds			| ds = cs
		movb	partition,cl
		orb	dl,*0x80
		movb	drive,dl
		mov	offset_L,ax
		mov	offset_H,bx
		movb	ah,*8			| get drive parameter
		int	DISKBIOS
		incb	dh			| heads
		andb	cl,*0x3F
		movb	trk_size,cl		| sectors / track
		xchg	cx,ax
		mulb	dh
		mov	cyl_size,ax		| sectors / cylinder

|	read SuperBlock from "root" partition
		mov	bp,#DISKBUF
		mov	ax,#1
		call	HDread
		mov	ax,SuperMagic
		cmp	ax,#V2_SUPERMAGIC
		jz	v2_fs
		cmp	ax,#V1_SUPERMAGIC
		jz	v1_fs
		call	error

v1_fs:		mov	ax,#0xD231
		mov	hook_v1,ax
		mov	di,#get_zone_num
		mov	si,#v1_param
		mov	cx,#5
		rep
		movw		
v2_fs:		mov	ax,S_INODE_MAP(bp)
		add	ax,S_ZONE_MAP(bp)
		add	ax,*2				| i-node start address
		mov	inode_start,ax

|	check shift key
		movb	ah,*2
		int	KEYBIOS
		andb	al,*3
		jnz	prompt

|	search "/system/minix.sys"
		call	se_img1
		or	ax,ax
		jz	prompt
		j	read_img

|	read image file name from KBD
prompt:		mov	ax,#2
		int 	VIDEOBIOS			| set screen mode
		mov	ax,#0x0200
		xor	dx,dx
		xor	bx,bx
		int	VIDEOBIOS			| HOME position
		mov	si,#Prompt
		call	putstr

		xor	bx,bx
		mov	si,#KEYBUFF
keyin:		xorb	ah,ah
		int	KEYBIOS
|		xorb	ah,ah
		cmpb	al,*0x21
		jc	ctrl_code
		cmpb	al,*0x7f
		jnc	keyin
		cmp	bx,#13
		jnc	keyin
#ifdef ASLD
		movb	(bx_si),al
#else
		movb	(bx+si),al
#endif
		inc	bx
		call	putch
		j	keyin

ctrl_code:	cmpb	al,*0x0D
		jz	decide
		cmpb	al,*0x08
		jnz	keyin
		or	bx,bx
		jz	keyin
		dec	bx
		call	putBS
		j	keyin

decide:		or	bx,bx
		jz	def_name
		mov	di,#Minix_sys
		mov	cx,bx
		rep
		movb
		movb	(di),*0
		call	init_ind_tbl		| search /xxxxx
		call	se_img2
		or	ax,ax
		jnz	read_img		| if not exist
def_name:	call	se_img1			| 	search /system/xxxxxx
		or	ax,ax
		jnz	read_img
#ifdef DEBUG
		call	error
#else
		mov	si,#Nofile		| file not found
		jmp	rebootmsg
#endif

|	load boot image to memory
read_img:	add	ax,zone0ofs
		mov	si,ax
		call	@get_zone_num
		push	si			| pointed &zone[1]
		mov	bp,#DISKBUF
		call	HD_read
		cmp	(bp),#0x02EB
		jz	prn_open
		mov	si,#MyOpenMsg
		call	putstr
		movb	tracksize,*15
		j	move_blok

|	display opening messege
prn_open:	add	open_msg,bp
		push	ds
		mov	ax,ds
		add	ax,#DS_open_msg
		mov	ds,ax
		seg	cs
		call	@open_msg
		pop	ds

|	get menu entry and move block
move_blok:	mov	si,#Menu_Final
		cmp	MENU_MAGIC(bp),#IPLMAGIC
		jz	set_final
		lodw				| si += 2
set_final:	lodw
		shr	ax,*1
		adc	ax,*0
		mov	last_block,ax
		mov	di,#menu_ds
		mov	cx,#3
		rep
		movw				| save menu entry

		push	es
		mov	ax,#LOADSEG
		mov	es,ax
		xor	di,di
		mov	si,#DISKBUF + 512
		mov	cx,#256
		rep
		movw
		pop	es

		pop	si			| &zone[1]
		mov	di,#DISKBUF
		mov	cx,z6_size
		sub	di,cx
		push	di
		rep
		movb

		call	@get_zone_num		| zone[7]
		push	dx
		push	ax			| save it

		call	@get_zone_num		| zone[8]
		or	ax,dx
		jz	rd_zone7
		mov	bp,#INODETBL
		call	HD_read
rd_zone7:	pop	ax
		pop	dx
		mov	bp,#DISKBUF
		call	HD_read

		mov	ax,#LOADSEG + 0x0020	| LOADSEG + 512
		mov	es,ax
		xor	bp,bp
		xor	di,di
		pop	si

|	Load the operating system from HD
loading:	call	@get_zone_num
		or	ax,dx
		jz	finish
		call	HD_read
		mov	ax,es
		add	ax,*0x40		| 1024 byte/block
		mov	es,ax
		cmp	si,#INODETBL
		jnz	chk_end
		mov	si,zone8rp
		call	@get_zone_num
		mov	zone8rp,si
		or	ax,dx
		jz	finish
		push	es
		push	bp
		mov	bp,#DISKBUF
		push	ds
		pop	es
		call	HD_read
		mov	si,bp
		pop	bp
		pop	es
chk_end:	inc	di
		cmp	di,last_block
		jc	loading

| Loading done.  Finish up.
finish:		cli
		mov	bx,tracksize
		or	bx,bx
		jnz	j_menu
		mov	bx,drive	| bh = boot partition number
					| bl = boot drive number
j_menu:		mov	ax,menu_ds
		mov	ds,ax
		mov	es,ax
		mov	ss,ax
		seg	cs
		jmpi	@menu_pc


|	dx:ax = long zone_number	-->	Return:
|	di    = char *filename			ax = i-node number
search:		mov	bp,#DISKBUF
		call	HD_read
		mov	bx,bp
		mov	cx,#64
se_file:	cmp	(bx),#0			| INODE(bx),#0
		jz	next2
		push	di
		mov	si,bx
		lodw				| add	si,*2
		movb	dl,*14
cmpstr:		cmpb
		jnz	next1
		decb	dl	
		cmpb	(di),*0
		jne	cmpstr
		orb	dl,dl
		jz	chk_fmode
		cmpb	(si),*0
		jz	chk_fmode
next1:		pop	di
next2:		add	bx,*16
		loop	se_file
no_file:	xor	ax,ax
		ret

chk_fmode:	pop	si			| check filemode
		dec	si			| sub	si,*2
		mov	ax,(bx)
		call	inode_ofs
		mov	ax,(bx)
		testb	(si),ah
		jz	no_file
		xchg	bx,ax			| return(q->inode)
		ret

dir_search:	mov	cx,#7
		add	si,zone0ofs
dir_se1:	call	@get_zone_num
		or	ax,dx
		jz	no_file
		push	cx
		push	si
		push	di
		call	search
		pop	di
		pop	si
		pop	cx
		or	ax,ax
		jnz	find
		loop	dir_se1
find:		ret

se_img1:	call	init_ind_tbl
		mov	si,ax
		mov	di,#System
		call	dir_search
		or	ax,ax
		jz	not_exist
se_img2:	mov	si,ax
		mov	di,#Minix_sys
		call	dir_search
not_exist:	ret

init_ind_tbl:	mov	ax,#1
inode_ofs:	dec	ax
inodeofs:	push	dx
		xor	dx,dx
		div	inodePblock
		cmp	ax,inode_block
		jz	calc_iofs
		push	dx
		push	cx
		push	bp
		mov	inode_block,ax
		add	ax,inode_start
		mov	bp,#INODETBL
		call	HDread
		pop	bp
		pop	cx
		pop	dx
calc_iofs:	xchg	dx,ax
		mul	inodesize
		add	ax,#INODETBL
		mov	bx,ax
		pop	dx
		ret
		

|	dx:ax = long  block_number
|	bp = char *buffer_address
HDread:		xor	dx,dx
HD_read:	shl	ax,*1
		rcl	dx,*1
		mov	sect_L,ax
		mov	sect_H,dx
		movb	retrys,*0x80
hd_read1:	add	ax,offset_L
		adc	dx,offset_H
		div	cyl_size
		movb	ch,al		| cylinder number
		shr	ax,*1
		shr	ax,*1
		andb	al,*0xC0
		movb	cl,al		| cylinder-H
		mov	ax,dx
		xor	dx,dx
		div	trk_size
		movb	dh,al		| head address
		incb	dl		| sector start from 1
		orb	cl,dl		| cylinder + sector
		movb	dl,drive
		mov	bx,bp		| buffer address
		mov	ax,#READBLOCK	| read 1 block
		int	DISKBIOS
		jc	hd_retry
		ret

hd_retry:	shrb	retrys,*1
		jc	hd_err
		movb	dl,drive
		xor	ax,ax		| reset HDC
		int	DISKBIOS
		mov	ax,sect_L
		mov	dx,sect_H
		j	hd_read1

hd_err:		push	ax		| DISK status code
		call	error

v2_zone:	lodw
		xchg	dx,ax
v1_zone:	lodw
hook_v1:	xchg	dx,ax
		nop
		ret

| datas
get_zone_num:	.word	v2_zone
inodesize:	.word	V2_INODESIZE
inodePblock:	.word	BLOCKSIZE / V2_INODESIZE
z6_size:	.word	V2_ZONE6 - V2_ZONE0
zone0ofs:	.word	V2_ZONE0

v1_param:	.word	v1_zone
		.word	V1_INODESIZE
		.word	BLOCKSIZE / V1_INODESIZE
		.word	V1_ZONE6 - V1_ZONE0
		.word	V1_ZONE0

inode_block:	.word	0xFFFF
zone8rp:	.word	INODETBL

MyOpenMsg:	.byte	CR
		.ascii	"MXboot V2.01"
CRLF:		.byte	CR, LF, NULL

Prompt:		.ascii	"MX.201>"
		.byte	NULL

		.byte	0x40			| .word	0x4000
System:		.ascii	"system"
		.byte	NULL

		.byte	0x80			| .word	0x8000
Minix_sys:	.ascii	"minix.sys"
		.byte	NULL

.text
endtext:

.data
enddata:

.bss
endbss:
