/* menu - print initial menu		Author: Bruce Evans */

#include <sys/types.h>
#include <limits.h>

#include <minix/config.h>
#include <minix/const.h>
#include <minix/type.h>
#include <minix/boot.h>

#include "../fs/const.h"
#include "../fs/type.h"

#define MAXWIDTH	 32	/* max. width of an ``integer string'' */
#define SECT_SHIFT        9	/* sectors are 512 bytes */
#define SECTOR_SIZE (1<<SECT_SHIFT)	/* bytes in a sector */
#define PARB		6
#define ERROR		-1

#if AHA_SCSI
#  if (WINI_DRIVES == 2)
#    define	ROOTDEV_MAJOR	DEV_HD0
#  else
#    if (WINI_DRIVES == 0)
#	define	ROOTDEV_MAJOR	DEV_SD0
#    endif
#  endif
#else
#  define	ROOTDEV_MAJOR	DEV_HD0
#endif

#if ( (LANGUAGE == JAPANESE) && OADG_KEY )
#undef DSCANCODE
#define DSCANCODE	0x8C	/* for JAPANESE-OADG keyboard */
#endif

struct bparam_s boot_parameters =
	{DROOTDEV, DRAMIMAGEDEV, DRAMSIZE, DSCANCODE, DPROCESSOR};

#define between(c,l,u)	((unsigned short) ((c) - (l)) <= ((u) - (l)))
#define isprint(c)	between(c, ' ', '~')
#define isdigit(c)	between(c, '0', '9')
#define islower(c)	between(c, 'a', 'z')
#define isupper(c)	between(c, 'A', 'Z')
#define toupper(c)	( (c) + 'A' - 'a' )
#define nextarg(t)	(*argp.t++)
#define prn(t,b,s)	{ printnum((long)nextarg(t),b,s,width,pad); width= 0; }
#define prc(c)		{ width -= printchar(c, mode); }

int *brk;			/* the ``break'' (end of data space) */
extern end;			/* last variable */

extern long low_sect;
extern int errors;
extern int fnt_drv;
extern hdparam();
extern HD_read();
extern dmaoverrun();
extern cpu();
extern p_memsize();
extern keybd_id();

char buf1[BLOCK_SIZE];
char buf2[BLOCK_SIZE];
char *diskbuf;
int extm_siz;

union types {
  int *u_char;			/* %c */
  int *u_int;			/* %d */
  unsigned *u_unsigned;		/* %u */
  long *u_long;			/* %ld */
  char **u_charp;		/* %s */
};


/* Print the given character. */
putchar(c)
{
  if (c == '\n') putc('\r');
  putc(c);
}

/* Get a character from the user and echo it. */
getchar()
{
  register c;

  if ((c = getc() & 0xFF) == '\r') c = '\n';
  putchar(c);
  return(c);
}

/* Print the number n. */
printnum(n, base, sign, width, pad)
long n;
int base, sign;
int width, pad;
{
  register short i, mod;
  char a[MAXWIDTH];
  register char *p = a;

  if (sign)
	if (n < 0) {
		n = -n;
		width--;
	} else
		sign = 0;
  do {				/* mod = n % base; n /= base */
	mod = 0;
	for (i = 0; i < 32; i++) {
		mod <<= 1;
		if (n < 0) mod++;
		n <<= 1;
		if (mod >= base) {
			mod -= base;
			n++;
		}
	}
	*p++ = "0123456789ABCDEF"[mod];
	width--;
  } while (n);
  while (width-- > 0) putchar(pad);
  if (sign) *p++ = '-';
  while (p > a) putchar(*--p);
}

/* Print the character c. */
printchar(c, mode)
{
  if (mode == 0 || (isprint(c) && c != '\\')) {
	putchar(c);
	return(1);
  } else {
	putchar('\\');
	switch (c) {
	    case '\0':	putchar('0');	break;
	    case '\b':	putchar('b');	break;
	    case '\n':	putchar('n');	break;
	    case '\r':	putchar('r');	break;
	    case '\t':	putchar('t');	break;
	    case '\f':	putchar('f');	break;
	    case '\\':	putchar('\\');	break;
	    default:
		printnum((long) (c & 0xFF), 8, 0, 3, '0');
		return(4);
	}
	return(2);
  }
}

/* Print the arguments pointer to by `arg' according to format. */
doprnt(format, argp)
char *format;
union types argp;
{
  register char *fmt, *s;
  register short width, pad, mode;

  for (fmt = format; *fmt != 0; fmt++) switch (*fmt) {
	    case '\n':
		putchar('\r');
	    default:	putchar(*fmt);	break;
	    case '%':
		if (*++fmt == '-') fmt++;
		pad = *fmt == '0' ? '0' : ' ';
		width = 0;
		while (isdigit(*fmt)) {
			width *= 10;
			width += *fmt++ - '0';
		}
		if (*fmt == 'l' && islower(*++fmt)) *fmt = toupper(*fmt);
		mode = isupper(*fmt);
		switch (*fmt) {
		    case 'c':
		    case 'C':
			prc(nextarg(u_char));
			break;
		    case 'b':
			prn(u_unsigned, 2, 0);
			break;
		    case 'B':	prn(u_long, 2, 0);	break;
		    case 'o':
			prn(u_unsigned, 8, 0);
			break;
		    case 'O':	prn(u_long, 8, 0);	break;
		    case 'd':	prn(u_int, 10, 1);	break;
		    case 'D':	prn(u_long, 10, 1);	break;
		    case 'u':
			prn(u_unsigned, 10, 0);
			break;
		    case 'U':	prn(u_long, 10, 0);	break;
		    case 'x':
			prn(u_unsigned, 16, 0);
			break;
		    case 'X':	prn(u_long, 16, 0);	break;
		    case 's':
		    case 'S':
			s = nextarg(u_charp);
			while (*s) prc(*s++);
			break;
		    case '\0':
			break;
		    default:	putchar(*fmt);
		}
		while (width-- > 0) putchar(pad);
	}
}


/* Print the arguments according to fmt. */
void printk(fmt, args)
char *fmt;
{
  doprnt(fmt, &args);
}


/* Initialize the variables used by this program. */
initvars()
{
  brk = &end;
}



/* Copy n bytes. */
copy(p, q, n)
register char *p, *q;
register int n;
{
  do
	*q++ = *p++;
  while (--n);
}

/* Print a string with either a singular or a plural pronoun. */
pr(fmt, cnt, s, p)
char *fmt, *s, *p;
{
  printk(fmt, cnt, cnt == 1 ? s : p);
}

#if DBCS_CONSOLE
kbtype()
{
    unsigned short k;

    k = keybd_id();
    if ((k & 0xff) == 0xab)
	boot_parameters.bp_scancode = (k & 0xff00) | 0x8C;
}
#endif

setparam(drive, partition)
int drive, partition;
{
    int i, k;
    long val[4];
    extern int errors;

#if DBCS_CONSOLE
    kbtype();
#endif

    boot_parameters.bp_processor = cpu();
    diskbuf = buf1;
    if (dmaoverrun(diskbuf)) diskbuf = buf2;
    extm_siz = p_memsize();

    if (drive & 0x80) {
	hdparam(drive);
	HD_read(drive, diskbuf, 0L);
	for(i = 0, k = 0x1C6; i < 4; k += 16, i++) {
	    val[i] = *(long *)&diskbuf[k];
	    /* printk("Partition %d: %D\n", i, val[i]); */
	}
	--partition;
	low_sect = *(long *)&diskbuf[0x1C6 + 16 * partition];
	partition = sort(val, val[partition]);
		/* for(i=0; i<4; i++)
			printk(">>Partition %d: %D\n", i, val[i]); */
	if (partition == 0) ++errors;
	else {
	    fnt_drv = drive << 8 | partition;
#if (AHA_SCSI && WINI_DRIVES == 1)
	    ROOT_DEV = ((drive & 1) ? DEV_SD0: DEV_HD0) + partition;
#else
	    ROOT_DEV = ROOTDEV_MAJOR + (drive & 1) * 5 + partition;
#endif
	}
	boot_parameters.bp_ramsize = (extm_siz > DRAMSIZE) ? DRAMSIZE: 0;
/*
#if INTEL_32BITS
	boot_parameters.bp_ramsize = (extm_siz > DRAMSIZE) ? DRAMSIZE: 0;
#else

	boot_parameters.bp_ramsize = 1024;
#endif
*/
    } else {
	fnt_drv = 0;
	ROOT_DEV = DEV_RAM;
	boot_parameters.bp_ramsize = 0;
    }
   /* return(boot_parameters.bp_scancode); */
}

main(argc, argv)
char **argv;
{
#if DBCS_CONSOLE
  extern option_menu();
  extern int font_on_mem;
#endif

  int command, k, c;

  printk("\n\n");
  for (;;) {
	printk("\n[Main menu]    Hit key as follows:\n\n");
	printk("    =  start MINIX, standard keyboard\n");
	printk("    u  start MINIX, U.S. extended keyboard\n");
	printk("    d  start MINIX, Dutch keyboard for PS/2\n\n");
	printk("    r  select root device "); pr_devname(ROOT_DEV);
	if (ROOT_DEV == DEV_RAM) {
	    printk("    i  select RAM image device"); pr_devname(BOOT_DEV);
	}
	if (ROOT_DEV != DEV_RAM) {
	    printk("    s  set RAM disk size");
	    if (boot_parameters.bp_ramsize != 0)
		printk("(now %uK)\n", boot_parameters.bp_ramsize);
	    else
		printk(".\n");
	}
	printk("    p  toggle protected mode enable (now %sabled)\n",
	       boot_parameters.bp_processor >= 286 ? "en" : "dis" );
#if DBCS_CONSOLE
	printk("    o  Optional menu.");
#endif
	printk("\n\n# ");
	c = getc();
	command = c & 0x7f;
	printk("%c\n", command);

	switch (command) {

	    case '=':
	    case 'u':
	    case 'd':
		c >>= 8;
#if DBCS_CONSOLE
		if (font_on_mem == -1) load_font();
		if (c == 0x8c) kbtype();
#else
		boot_parameters.bp_scancode = c;
#endif
		return(boot_parameters.bp_scancode);

	    case 'i':
		if (ROOT_DEV == DEV_RAM) get_device(&BOOT_DEV, "ram image", 0);
		break;

	    case 'p':
		boot_parameters.bp_processor =
			boot_parameters.bp_processor >= 286 ? 88 : 286;
		break;

	    case 'r':
		get_device(&ROOT_DEV, "root", 1);
		break;

	    case 's':
		if (ROOT_DEV != DEV_RAM)
		    get_num(&boot_parameters.bp_ramsize,"Enter RAM-DISK size");
		break;

#if DBCS_CONSOLE
	    case 'o':
		option_menu();
		break;
#endif
	    default:
		printk("Illegal command\n");
		continue;
	}
	printk("\n\n");
  }
}

get_device(dev, description, ram_allowed)
int *dev;
char *description;
int ram_allowed;
{
  char tmp[11];
  int minor;

  printk("\nPlease enter name of \"%s\" device: /dev/", description);
  if (readln(tmp,10) == ERROR) return;
  if      (strncmp(tmp, "hd", 2) == 0) {
	minor = atoi(&tmp[2]);
	if ((minor % 5) && between(minor, 1, 9)) *dev = DEV_HD0 + minor;
  }
  else if (strncmp(tmp, "fd", 2) == 0) {
	minor = atoi(&tmp[2]);
	if (between(minor, 0, 1)) *dev = DEV_FD0 + minor;
  }
  else if (ram_allowed && strcmp(tmp, "ram") == 0) {
	*dev = DEV_RAM;
  }
#if AHA_SCSI
  else if (strncmp(tmp, "sd", 2) == 0) {
	minor = atoi(&tmp[2]);
	if ((minor % 5) && between(minor, 1, 9)) *dev = DEV_SD0 + minor;
  }
#endif
  printk("\nunknown device \"/dev/%s\"\n", tmp);
}

get_num(val, prompt)
int *val;
char *prompt;
{
  char tmp[20];

  printk("\n%s: ", prompt);
  if (readln(tmp, 19) == ERROR) return;
  *val = atoi(tmp);
}

int sort(val, org)
register long *val;
long org;
{
  register int i, j;

  for (i = 0; i < 4; i++) for (j = 0; j < 3; j++)
		if ((val[j] == 0) && (val[j + 1] != 0))
			swap(&val[j], &val[j + 1]);
		else if (val[j] > val[j + 1] && val[j + 1] != 0)
			swap(&val[j], &val[j + 1]);

  for(i = 0; i < 4; i++) {
	if (org == val[i]) return(i+1);
  }
  return(0);
}

swap(first, second)
register long *first, *second;
{
  register long tmp;

  tmp = *first;
  *first = *second;
  *second = tmp;
}

pr_devname(dev)
int dev;
{
  static char *devname[] =
	{ "?", "ram", "fd", "hd"
#if AHA_SCSI
	, "?", "?", "?", "?", "?", "?", "sd"
#endif
	};
  int major;

  major = dev >> 8;
  printk("(now /dev/%s", devname[major]);
  if (between(major, 2, 3) || major == 10) printk("%d", dev & 0xff);
  printk(")\n");
}
