|	assistIPL:
|		multi OS boot utility for IBM PC/AT and compatibles
|						Auther: takamiti@mix
|

NULL		= 0x00
CR		= 0x0D
LF		= 0x0A
EXEC_KEY	= 0x4F00		| END key

CRTBIOS		= 0x10
DISKBIOS	= 0x13
KEYBIOS		= 0x16
CHATTR		= 0x01

BIOS_LOC	= 0x7C00
BOOT_LOC	= 0x0600
IPLMAGIC	= 0xAA55

PART_TAB	= BOOT_LOC + 0x1BE
magic		= BOOT_LOC + 0x1FE

#ifdef ASLD
.globl begtext, begdata, begbss, endtext, enddata, endbss  | asld needs these
#endif

.text
begtext:

.data
begdata:

.bss
begbss:

.text

#ifndef ASLD
entry	crtso
#endif

| copy bootblock to bootseg
crtso:		cli
		xor	ax,ax
		mov	ss,ax
		mov	es,ax
		mov	ds,ax
		mov	sp,#BIOS_LOC
		mov	si,sp
		sti
		cld
		mov	di,#BOOT_LOC
		mov	cx,#256
		rep
		movw
		xchg	ax,bp
		mov	ax,#start + BOOT_LOC
		push	ax
		ret

start:
#ifdef FDTEST
		mov	dx,#0x80
		jmp	get_table
#endif
chk_pause:	testb	0x0417,*0x03
		jnz	chk_table
		testb	0x043F,*0x0F
		jnz	chk_pause
		mov	cx,#4
		mov	di,#PART_TAB
		movb	dh,*0x30
auto1:		incb	dh
		testb	(di),*0x80
		jnz	boot_1
		add	di,*16
		loop	auto1

chk_table:	call	initCRT
		mov	cx,#4
		mov	di,#PART_TAB
		mov	dx,#0x3130
		mov	si,#guid_msg + BOOT_LOC
		call	putstr
chtabloop:	inc	dx
		testb	(di),*0x80
		jz	prntab
		mov	bp,di
		movb	dh,dl
		andb	(di),*0x7F
prntab:		movb	ah,*6
		movb	al,dl
		call	putSPC
		movb	bl,4(di)
		orb	bl,bl
		jz	nosys
		mov	ax,#0x0753
		call	putSPC
		xchg	ax,bx
		call	hex2
nosys:		call	putCRLF
		add	di,*16
		loop	chtabloop
		call	putCRLF
retry:		mov	si,#sel_msg + BOOT_LOC
		call	putstr
keyin:		movb	al,dh
		call	putch
keyin1:		xorb	ah,ah
		int	KEYBIOS
		cmpb	al,*0x30
		jc	sel_ok
		cmpb	al,*0x34
		ja	keyin1
		movb	dh,al		| save
		j	retry

sel_ok:		cmp	ax,#EXEC_KEY
		jz	boot_1
		cmpb	al,*0x0D
		jnz	keyin1
		xor	bp,bp
boot_1:		mov	di,dx
		subb	dh,*0x30
|		orb	dh,dh
		jz	switch_HD

boot_proc:	cmp	magic,#IPLMAGIC
		jnz	error
		decb	dh
		movb	al,*16
		mulb	dh
		add	ax,#PART_TAB
		xchg	ax,si			| partition table address
		cmpb	4(si),*0
		jz	wrong_sys
		mov	dx,(si)			| dl = drive, dh = head
		movb	dl,drive+BOOT_LOC
		addb	dl,*0x50
		mov	cx,2(si)		| cl = sector, ch = cylinder
rd_ipl:		call	HDread
		cmp	(bx),#0
		jnz	exec_loader
wrong_sys:	movb	al,*7
		call	putch
		mov	dx,di
		j	retry
		
exec_loader:	movb	(si),dl
#ifndef FDTEST
		or	bp,bp
		jz	skip
		cmp	si,bp
		jz	skip
		xorb	dh,dh
		mov	cx,#1
		movb	ah,*0x03
		mov	bx,#BOOT_LOC
		call	HDio
skip:
#endif
		call	initCRT
		jmpi	BIOS_LOC,0

HDread:		mov	bx,#BIOS_LOC		| load address(0000:7C00)
		movb	ah,*0x02		| read a sector in BIOS_LOC
HDio:		movb	al,*0x01
		int	DISKBIOS
		jc	iplerr
		ret

iplerr:		xchg	ax,bx
error:		mov	si,#err_msg + BOOT_LOC
		call	putstr
		movb	al,bh
		call	hex2
		hlt
halt:		j	halt

| read IPL sector from another HD 
switch_HD:	cmpb	0x475,*2
		jnz	wrong_sys
		xorb	drive+BOOT_LOC,*1
		movb	dl,drive+BOOT_LOC
		addb	dl,*0x50
		xorb	dh,dh
get_table:	mov	cx,#1
		call	HDread
		mov	si,#BIOS_LOC + 0x1BE
		mov	di,#PART_TAB
		mov	cx,#33
		rep
		movw
#ifdef FDTEST
		cmpb	is1st+BOOT_LOC,*0
		movb	is1st+BOOT_LOC,*1
		jnz	dsptbl
		jmp	chk_pause
is1st:		.byte	0
#endif
dsptbl:		jmp	chk_table

hex2:		push	ax
		push	cx
		movb	cl,*4
		shrb	al,cl
		pop	cx
		call	hex1
		pop	ax
hex1:		andb	al,*0x0F		
		addb	al,*0x30
		cmpb	al,*0x3A
		jc	pr_hex
		addb	al,*7
pr_hex:		j	putch

putSPC:		push	ax
		push	cx
		movb	cl,ah
p_spc_loop:	call	putspace
		loop	p_spc_loop
		pop	cx
		pop	ax
		j	putch

putspace:	movb	al,*0x20
putch:		push	bx
		movb	ah,*14
		mov	bx,#1
		int	CRTBIOS
		pop	bx
__exit_:	ret

putCRLF:	mov	si,#crlf_msg + BOOT_LOC
putstr:		lodb
		orb	al,al
		jz	__exit_
		call	putch
		j	putstr

initCRT:	mov	ax,#2
		int	CRTBIOS
		mov	ax,#0x0200	| cursor Home
		xor	bx,bx
		xor	dx,dx
		int	CRTBIOS
		ret

guid_msg:	.ascii	"HD#"
drive:		.byte	0x30, LF
		.ascii	"Part.   System"
crlf_msg:	.byte	CR, LF, NULL
sel_msg:	.byte	CR
		.ascii	"Which? "
		.byte	NULL
err_msg:	.byte	CR, LF
		.ascii	"ERR "
		.byte	NULL

.text
endtext:

.data
enddata:

.bss
endbss:

| end of assist IPL
