/* font.h */

#define FH_MEMO_SIZE		508
struct font_header {
	short fnt_size;		/* bytes per one character bit patern */
	short fnt_high;		/* font height */
	short fnt_width;	/* font width */
	unsigned short top_code;
	unsigned short end_code;
	char _unused[502];	/* empty */
	char memo[FH_MEMO_SIZE];
	long sum;
};
#define FONT_HEAD_SIZE		sizeof(struct font_header)

/* single byte character constants */
#define SBC_FONT_SIZE	16	/* single byte font size in bytes */
#define SBC_FONT_HIGH	16	/* single byte font height in dots */
#define SBC_FONT_WIDTH	8	/* single byte font width in dots */
#define SBC_PATERN_SIZE	4096

struct sbc_font {
	struct font_header head;
	char patern[SBC_PATERN_SIZE];
};
#define SBC_STRUCT_SIZE		sizeof(struct sbc_font)


#define NR_FONT_TBL	4
#define FONT_TBLSIZE	(sizeof(struct font_table) * NR_FONT_TBL)
#define FONT_DISABLE	0x0000
#define FONT_ENABLE	0x0001
#define FONT_ACTIVE	0x0002
#define USABLE_FONT	(FONT_ACTIVE | FONT_ENABLE)

/* sturcture to hold font table parameters */
struct font_table {
	long  ft_base;
	short ft_limit;
	short fn_size;
	short fn_high;
	short fn_width;
	short top_ofs;
	short flag;
};

extern struct font_table sys_font[NR_FONT_TBL];

