/*
 * This file contains a placeholder task for wini that does nothing.  It
 * can be dropped in place of wini.c and simply returns all messages with
 * an EIO error.
 */
#include "kernel.h"
#include <minix/callnr.h>
#include <minix/com.h>

PUBLIC int using_bios = FALSE;	/* this disk driver does not use the BIOS */
PRIVATE message w_mess;		/* message buffer for in and out */

/*===========================================================================*
 *				winchester_task				     * 
 *===========================================================================*/
PUBLIC void winchester_task()
{
  int caller;

  while (TRUE) {
	receive(ANY, &w_mess);	/* get a request to do some work */
	if (w_mess.m_source < 0) {
		printf("winchester task got message from %d ", w_mess.m_source);
		/* ignore it */
		continue;
	}
	caller = w_mess.m_source;
	w_mess.m_type = TASK_REPLY;	
	w_mess.REP_PROC_NR = w_mess.PROC_NR;
	w_mess.REP_STATUS = EIO;
	send(caller, &w_mess);	/* send reply to caller */
  }
}
