
OPTION	= -DGRAPHICS		# -DNUM_LOCK

#include <minix/config.h>
#if ENABLE_SCSI
#define SCSI_OBJ	scsi.O
#else
#define SCSI_OBJ
#endif

 # Makefile for kernel using standard Minix directory layout and compiler.
 # CPP may need changing to /usr/lib/cpp.
 # The following nonstandard flags are used:
 # -F:	run cpp and cem sequentially (used when memory is tight)
 # -T.:	put temporaries in working directory (when RAM disk is small)

#if ACK
CFLAGS		=-O $(OPTION)
CPPFLAGS	=-DASLD $(OPTION) -P
#define		O	s
LD		=asld
LDFLAGS		=-i -s
LIBS		=/usr/lib/libc.a
END		=/usr/lib/end.O

#else

#define		O	o

#if SELF386
#undef i386
TRAD		=-traditional
#endif

#if USE_NPX
NPX		=-DUSE_NPX
#else
NPX		=
#endif
COMMFLAG	=-DINTEL_32BITS $(NPX) $(OPTION)

AS		=as -3
AS86		=as -0 -a
CPPFLAGS	=$(COMMFLAG) -P $(TRAD)
CFLAGS		=-3 $(COMMFLAG)
LD		=ld
LDFLAGS		=-3 -i
LIBS		=/usr/local/lib/i386/libc.a longlib.a
END		=

#endif

START		=start.O
CPP		=/usr/lib/cpp
i		=/usr/include
s		=/usr/include/sys
h		=/usr/include/minix
m		=makefile
a		=kernel.h $h/config.h $h/const.h $h/type.h \
		 $s/types.h $i/limits.h $i/errno.h \
		 const.h type.h proto.h glo.h $m

KEROBJS		=cstart.O protect.O protect1.O klib.O mpx.O wini.O \
		 table.O main.O tty.O floppy.O system.O proc.O clock.O \
		 memory.O console.O rs232.O rs2.O printer.O dmp.O \
		 exception.O i8259.O misc.O keyboard.O scg.O SCSI_OBJ

SOBJS		=start.s klib.s mpx.s rs2.s scg.s

 # Rules
.SUFFIXES: .x		# .x files are .s files which need C-preprocessing
.x.s:
	$(CPP) $(CPPFLAGS) $< >$@
#if !ACK
.s.O:
	$(AS) $< -o $@
.x.O:
	$(CPP) $(CPPFLAGS) $< >$@
	$(AS) $< -o $@
#endif

 #What to make.
dummy: kernel	# this line fixes a bug in RALs latest make

kernel: $(START) $(KEROBJS) $(LIBS) $(END)
#if ACK
	$(LD) $(LDFLAGS) -o kernel \
	$(START) \
	$(KEROBJS) \
	$(LIBS) $(END) > symbol.out
	ast -X kernel
	@rm symbol.out

#else
	$(LD) $(LDFLAGS) -o kernel \
	$(START) \
	$(KEROBJS) \
	$(LIBS)
#endif

Z:
	tar cvfz /tmp/kernel.Z makefile.cpp *.[hc] start.x rs2.x *88.x *386.x

lzh:
	lharc a /tmp/kernel makefile.cpp *.[hc] start.x rs2.x *88.x *386.x

clean:
	rm -f $(KEROBJS) $(SOBJS) *.bak *~ kernel symbol.out


klib.s:	 $h/config.h $h/const.h const.h protect.h sconst.h klib.x $m
mpx.s:	 $h/config.h $h/const.h $h/com.h const.h protect.h sconst.h mpx.x $m
start.s: $h/config.h $h/const.h $h/com.h const.h protect.h sconst.h start.x $m
rs2.s:	 $h/config.h $h/const.h const.h sconst.h rs2.x $m
scg.s :	 $h/config.h vga.h scg.x $m

#if !ACK
start.O: start.s
	$(AS86) start.s -o start.O
#endif

cstart.O:	$a
cstart.O:	$h/boot.h $h/font.h
cstart.O:	cstart.c
#if INTEL_32BITS
	cc -0 -c $(COMMFLAG) cstart.c
#endif

protect.O:	$a
protect.O:	protect.h
protect.O:	protect1.c
protect.O:	protect.c
#if INTEL_32BITS
	cc -0 -c $(COMMFLAG) protect.c
#endif

clock.O:	$a
clock.O:	$i/signal.h
clock.O:	$h/callnr.h
clock.O:	$h/com.h
clock.O:	proc.h

console.O:	$a
console.O:	$i/sgtty.h
console.O:	$h/callnr.h
console.O:	$h/com.h
console.O:	protect.h
console.O:	$h/font.h tty.h vga.h
#if CROSS386
	/usr/lib/cpp -P $(COMMFLAG) console.c > __console.c
	cc -c -3 -o console.o __console.c
	rm __console.c
#endif

dmp.O:		$a
dmp.O:		$h/callnr.h
dmp.O:		$h/com.h
dmp.O:		proc.h

exception.O:	$a
exception.O:	$i/signal.h
exception.O:	proc.h

floppy.O:	$a
floppy.O:	$h/callnr.h
floppy.O:	$h/com.h

i8259.O:	$a

keyboard.O:	$a
keyboard.O:	$i/sgtty.h
keyboard.O:	$i/signal.h
keyboard.O:	$h/callnr.h
keyboard.O:	$h/com.h
keyboard.O:	tty.h vga.h

main.O:		$a
main.O:		$i/signal.h
main.O:		$h/callnr.h
main.O:		$h/com.h
main.O:		proc.h

memory.O:	$a
memory.O:	$h/callnr.h
memory.O:	$h/com.h
memory.O:	$h/font.h

misc.O:		$a
misc.O:		$h/com.h

printer.O:	$a
printer.O:	$h/callnr.h
printer.O:	$h/com.h

proc.O:		$a
proc.O:		$h/callnr.h
proc.O:		$h/com.h
proc.O:		proc.h

protect1.O:	$a
protect1.O:	proc.h
protect1.O:	protect.h

rs232.O:	$a
rs232.O:	$i/sgtty.h
rs232.O:	tty.h

system.O:	$a
system.O:	$i/signal.h
system.O:	$h/boot.h
system.O:	$h/callnr.h
system.O:	$h/com.h
system.O:	proc.h
system.O:	protect.h

table.O:	$a
table.O:	$h/com.h
table.O:	proc.h
table.O:	tty.h

tty.O:		$a
tty.O:		$i/sgtty.h
tty.O:		$i/signal.h
tty.O:		$h/callnr.h
tty.O:		$h/com.h
tty.O:		tty.h vga.h

wini.O:	$a
wini.O:	$h/callnr.h
wini.O:	$h/com.h
wini.O:	$h/partition.h

#if ENABLE_SCSI
scsi.O:	$a
scsi.O:	$h/callnr.h
scsi.O:	$h/com.h
scsi.O:	$h/partition.h
scsi.O:	$s/mtio.h
#endif

#if ACK /* two gratuitous blank lines :-( */


#endif
