/*
** users - list logged in users
**
** Usage: users
**
** Version:	2 - 95/03/20 -	Recoded for getut(3c) functions
**				to permit use on both native Minix,
**				and with inittab extensions.
** Release;	0 - 95/03/20 -	Initial release
**		1 - 95/03/21 -	Updated to sort id's in ascending sequence
**
** Author:	Lew Pitcher
** Language:	C (ACK for Minix)
*/

#include <sys/types.h>
#include <string.h>
#include <utmp.h>
#include <stdio.h>

#define MAX_USERS 256	/* maximum # users processed by the command */
#define ID_SIZE	  8	/* NB: Must be same as size of ut_user	    */

char user[MAX_USERS][ID_SIZE],	/* names of all logged on users	*/
     *fmt = " %.8s";		/* format string for printf	*/
int  online = 0;		/* count of logged on users	*/

main()
{
	struct utmp *ut;

	/* gather all the names */
	utmpname(UTMP);
	while ((ut = getutent()) != NULL)
		if ((ut->ut_type == USER_PROCESS) && (online < MAX_USERS))
			memcpy(user[online++],ut->ut_user,ID_SIZE);
	endutent();

	if (online > 0)	/* show the names of all online users */
	{
		int count, idcmp();

		if (online > 1)		/* sort the names alphabetically */
			qsort(user,online,ID_SIZE,idcmp);
		printf(fmt+1,user[0]);			/* 1st name */
		for (count = 1; count < online; ++count)
			printf(fmt,user[count]);	/* the rest */
		putchar('\n');				/* end line */
	}
}

/*
** idcmp() returns the result of a comparison of two names
**	   for use by qsort()
*/
int idcmp(p1,p2)
char *p1, *p2;
{
	return strncmp(p1,p2,ID_SIZE);
}
