#ifndef lint
static char *RCS_defs_h = "$Id: defs.h,v 1.8 90/09/19 13:55:10 rogers Exp $";
#endif

/* --------------------
	vmail -- defs.h

	Interactive screen-based mail handler that sits on top of MH.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#ifdef MINIX
#define POSIX_1
#define ANSI_C
#endif

#include <errno.h>
#include <stdio.h>
#include <string.h>
#ifdef sun
#include <malloc.h>
extern char *memalign();
#else
extern char *malloc();
extern char *realloc();
#endif
#include <pwd.h>
#include <setjmp.h>
#ifndef POSIX_1
#include <sgtty.h>
#endif
#include <sys/types.h>
#include <sys/wait.h>
#ifndef POSIX_1
#include <sys/dir.h>
#endif
#ifndef MINIX
#include <sys/file.h>
#endif
#include <sys/stat.h>
#include <curses.h>

#ifdef POSIX_1
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

#ifndef S_IREAD
#define S_IREAD S_IRUSR
#endif
#ifndef S_IWRITE
#define S_IWRITE S_IWUSR
#endif
#ifndef S_IEXEC
#define S_IEXEC S_IXUSR
#endif

#define vfork() fork()
#endif

#ifdef MINIX
#include <sys/ioctl.h>
#include <regexp.h>
#endif

/*
 * MH utilities needed by vmail
 */
#define BURST		"burst"
#define COMP		"comp"
#define DIST		"dist"
#define FORW		"forw"
#define INC		"inc"
#define REPL		"repl"
#define SORTM		"sortm"

#ifdef MINIX
/* Under Minix the MH utilities may be found here: */
#define MHPATH		"/opt/mh/bin"
#endif

/*
 * Other things
 */

#if defined(sun) || defined(ultrix) || defined(ANSI_C)
#define	sig_type	void		/* Suns and Ultrix 3.x			*/
#else
typedef	int		sig_type;	/* the rest of the world		*/
#endif

#define PAGER		"more"			/* default pager */
#define EDITOR		"vi"			/* default editor */
#define SHELL		"/bin/csh"		/* default shell */
#define CAT			"/bin/cat"		/* used as `show' for pipes */

#define LEN			255						/* standard string length */
#define MAXITEMS	4097					/* number of items in folder */
#define FPROT		0755					/* standard file protection */
#define TITLE		0						/* title line */
#define STATUS		1						/* status line */
#define FIRST		2						/* first line of info */
#define PROFILE		".mh_profile"			/* default profile */
#define CURFOL		"inbox"					/* default current folder */
#define CONTEXT		"context"				/* default context file */
#define SEQU		".mh_sequences"			/* default .mh_sequences file */
#define MAILDIR		"Mail"					/* default mail directory */

#define	true		1
#define false		0
#define EMPTY		2						/* used to mark empty folders */
#define CTRL_L		'\014'
#define CTRL_R		'\022'
#define ESC			'\033'
#define DEL			'\177'

/* --------------------
	Data structures.

	Each folder is divided into pages of (_lines_-2) mail items, _lines_
	being the number of lines for the tty type.  Pages of folders are
	stored in a doubly-linked list of pages (struct mail_folder), mail
	items (struct mail_item) in doubly liked lists of mail.  Folders are
	sorted alphabetically, and pages of mail items are sorted numerically.
-------------------- */
struct mail_item {
	int		number;						/* number of item */
	char	*title;						/* header */
	struct mail_item *next, *prev;		/* links to other headers */
};
typedef struct mail_item *item;

struct mail_folder {
	char	*name;						/* folder name */
	int		pages, pagenum;				/* no. of pages, no. of page */
	bool	valid;						/* true if folder active */
	item	mail, last;					/* first and last mail items for page
										   - NULL if folder not active */
	struct mail_folder *next, *prev;	/* linked list of folders */
};
typedef struct mail_folder *folder;


extern folder	folders,				/* list of all folders */
				curflr,					/* current folder */
				alternate;				/* alternate folder */
extern item		curmail;				/* current mail */
extern char		**environ,
				*user,					/* user name */
				*pager,					/* desired pager */
				*editor,				/* desired editor */
				*shell,					/* desired shell */
				*mail_dir,				/* mail directory */
				*context;				/* context file */
extern int		y,						/* current Y co-ordinate (for curses) */
				folder_protect,			/* protection for folders */
				lines,					/* lines per screen */
				cols;					/* cols per screen */
extern bool		top_level,				/* flag used to see if process stopped
										   from within subprocess */
				do_flush,				/* true if input is to be flushed */
				comp_args,				/* true if calls to comp needs args */
				repl_args,				/* true if calls to repl needs args */
				forw_args,				/* true if calls to forw needs args */
				burst_args,				/* true if calls to burst needs args */
				dist_args,				/* true if calls to dist needs args */
				sort_args;				/* true if calls to sortm needs args */
extern jmp_buf	env;

#include "macro.h"

folder find_mail();
#ifndef ANSI_C
extern char *sprintf();
#endif
void	add_page_header(), addstatus(), choose(), comp(), create_mail_record(),
		cursor_down(), cursor_up(),
		display_page(), delete_item(), deleteline(), edit(),
		find_folders(), flatten(), forw(), get_env(),
		get_home(), read_profile(), get_string(), get_title(),
		goto_folder(), call_shell(), goto_incorp_folder(),
		goto_next_folder(), goto_prev_folder(), hold_end(),
		inactive(), inc(), init(), list_folders(),
		mark_valid_folders(), move_item(), next_page(),
		no_control(), pack_folder(), prev_page(), repl(),
		refresh_folder(), save_item(), search(), show_folder(),
		show_mail(), show_title(), to_control(), to_normal(),
		undo(), pack(), cursor_first(), cursor_middle(),
		cursor_last(), goto_first_page(), goto_last_page(),
		squash(), get_date(), process_args(), do_pipe(),
		sort_folder(), burst_item(), dist_item();
bool change_item();
