#ifndef lint
static char *RCS_cmds_c = "$Id: cmds.c,v 1.3 90/04/23 14:40:56 rogers Exp $";
#endif

/* --------------------
	vmail -- cmds.c

	Commands not included in page.c or move.c.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"
#include <signal.h>

/* --------------------
	Print the name of the alternate folder.
-------------------- */
void
show_folder()
{
	char	str[LEN];

	if(alternate == (folder) NULL)
		addstatus("No alternate folder", false);
	else {
		(void)sprintf(str, "alternate folder is %s\n", alternate->name);
		addstatus(str, false);
	}
}


/* --------------------
	Make current folder inactive - remove list of mail headers, set valid
	to false.
-------------------- */
void
inactive()
{
	folder	f, p;

		/* find first page of folder */
	p = curflr; FRST_OF_NAME(p);
		/* find last page of folder */
	f = curflr; LAST_OF_NAME(f);
	p->next = f->next;
	p->valid = false;
/* should free records */
	p->mail = p->last = (item) NULL;
	p->pagenum = p->pages = 1;
	if(p->next != (folder) NULL)
		p->next->prev = p;
	curflr = p;
	NEXT_VALID(curflr);
	if(curflr == (folder) NULL) {
		curflr = p;
		PREV_VALID(curflr);
	}
	if(curflr == (folder) NULL) {
		addstatus("Making last active folder inactive", true);
		to_normal();
		exit(0);
	} else {
		curmail = curflr->mail;
		y = FIRST;
		display_page();
	}
}


/* --------------------
	Show current mail item with fork to pager.
-------------------- */
void
show_mail()
{
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();
	char	str[LEN];
#ifdef POSIX_1
	int status;
#else
	union wait status;
#endif

	clear();
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		no_control();
		(void)sprintf(str, "%s/%s/%d", mail_dir, curflr->name, curmail->number);
		execlp(pager, pager, str, 0);
		(void)printf("Warning: can't execute %s\n", pager);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}


/* --------------------
	Save current mail item to named file.  If first non-space character
	is ~, expand it.
-------------------- */
void
save_item()
{
	struct passwd *pwent, *getpwnam();
	char	*tmp, buf[LEN], *str = buf, save[LEN];
	FILE	*fi, *fo, *fopen();

	(void)sprintf(save, "%s.%d", curflr->name, curmail->number);
	(void)sprintf(str, "file (%s)? ", save);
	get_string(str, str);
	for(; *str == ' ' ; str++)
		;
	for(tmp=str ; *tmp != '\0' && *tmp != ' ' ; tmp++)
		;
	*tmp = '\0';
	if(*str != '\0')		/* don't take default */
		if(*str == '~')	{	/* expand home directory name */
			tmp = str + 2;
			if(*(str+1) == '/')
				pwent = getpwnam(user);
			else {	
				for( ; *tmp != '\0' && *tmp != '/' ; tmp++)
					;
				*(tmp++) = '\0';
				if((pwent = getpwnam(str+1)) == (struct passwd *) NULL) {
					(void)sprintf(save, "%s: no such user", str+1);
					addstatus(save, true);
					return;
				}
			}
			(void)sprintf(save, "%s/%s", pwent->pw_dir, tmp);
		} else				/* take str as given */
			(void)strcpy(save, str);
	if((fo = fopen(save, "w")) == (FILE *) NULL) {
		(void)sprintf(str, "%s: no write permission", save);
		addstatus(str, true);
		return;
	}
	addstatus("saving ...", false);
	(void)sprintf(str, "%s/%s/%d", mail_dir, curflr->name, curmail->number);
	fi = fopen(str, "r");
	while(fgets(str, LEN, fi) != (char *) NULL)
		(void)fprintf(fo, "%s", str);
	(void)fclose(fi); (void)fclose(fo);
	addstatus("saved", false);
}
