#ifndef lint
static char *RCS_call_c = "$Id: call.c,v 1.5 90/09/19 13:53:33 rogers Exp $";
#endif

/* --------------------
	vmail -- call.c

	Routines that call MH equivalents, editor, shell.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include "defs.h"
#include <signal.h>

#define WARNING	"Warning -- mail headers may be out of date"

#ifdef POSIX_1
int status;
#else
union wait status;
#endif

/* --------------------
	Fork a call to `comp'.
	Terminal type must be reset before call.
-------------------- */
void
comp()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	*s1 = '\0';
	if(comp_args) {
		(void)sprintf(str, "(give options to)   comp ");
		get_string(str, s1);
	}
	clear();
	addstatus("composing mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		argv[0] = COMP;
		for(i=1, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(COMP, argv);
		(void)printf("Warning: can't execute %s\n", COMP);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to `forw'.
	Terminal type must be reset before call.
-------------------- */
void
forw()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	(void)sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(forw_args) {
		(void)sprintf(str, "(give options to)   forw +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("forwarding mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		(void)sprintf(str, "+%s", curflr->name);
		argv[0] = FORW; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(FORW, argv);
		(void)printf("Warning: can't execute %s\n", FORW);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to `repl'.
	Terminal type must be reset before call.
-------------------- */
void
repl()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	(void)sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(repl_args) {
		(void)sprintf(str, "(give options to)   repl +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("answering mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		(void)sprintf(str, "+%s", curflr->name);
		argv[0] = REPL; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(REPL, argv);
		(void)printf("Warning: can't execute %s\n", REPL);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to editor.
	Terminal type must be reset before call.
-------------------- */
void
edit()
{
	char	str[LEN];
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	clear();
	mvaddstr(TITLE, 0, "editing mail ...");
	move(STATUS, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		no_control();
		(void)sprintf(str, "%s/%s/%d", mail_dir, curflr->name, curmail->number);
		execlp(editor, editor, str, 0);
		(void)printf("Warning: can't execute %s\n", editor);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}


/* --------------------
	Fork a call to shell.
	Terminal type must be reset before call.

	This should perhaps be modified so that only a single command can be
	issued, as in vi ... but this was simpler to do.
-------------------- */
void
call_shell()
{
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	clear();
	mvaddstr(TITLE, 0, "calling shell ...");
	move(STATUS, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		no_control();
		fix_mh();
		execlp(shell, shell, "-i", 0);
		(void)printf("Warning: can't execute %s\n", shell);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}


/* --------------------
	Pipe current mail item into given command.
-------------------- */
void
do_pipe()
{
	char	str[LEN], s1[LEN];
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	*s1 = '\0';
	(void)sprintf(str, "(give command to)   show +%s %d | ", curflr->name,
														curmail->number);
	get_string(str, s1);
	clear();
	addstatus("piping mail ...", false);
	move(STATUS+1, 0);
	refresh();
	(void)sprintf(str, "%s %s/%s/%d | %s", CAT, mail_dir, curflr->name,
														curmail->number, s1);
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	no_control();
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)system(str);			/* exec needs full path of command => use system */
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
}

/* --------------------
	Fork a call to `burst'.
	Terminal type must be reset before call.
-------------------- */
void
burst_item()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	(void)sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(burst_args) {
		(void)sprintf(str, "(give options to)  burst +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("bursting mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		(void)sprintf(str, "+%s", curflr->name);
		argv[0] = BURST; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(BURST, argv);
		(void)printf("Warning: can't execute %s\n", BURST);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	clear();
	move(STATUS, 0);
	refresh_folder();
}

/* --------------------
	Fork a call to `dist'.
	Terminal type must be reset before call.
-------------------- */
void
dist_item()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], s2[10], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	(void)sprintf(s2, "%d", curmail->number);
	*s1 = '\0';
	if(dist_args) {
		(void)sprintf(str, "(give options to)   dist +%s %s ", curflr->name, s2);
		get_string(str, s1);
	}
	clear();
	addstatus("disting mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		(void)sprintf(str, "+%s", curflr->name);
		argv[0] = DIST; argv[1] = str; argv[2] = s2;
		for(i=3, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(DIST, argv);
		(void)printf("Warning: can't execute %s\n", DIST);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	display_page();
	addstatus(WARNING, true);	/* vmail's data structures not updated */
}

/* --------------------
	Fork a call to `sortm'.
	Terminal type must be reset before call.
-------------------- */
void
sort_folder()
{
	char	*tmp, *argv[20], str[LEN], s1[LEN], *next_token();
	int		i;
	sig_type	(*oldint)(), (*oldquit)(), (*signal())();

	*s1 = '\0';
	if(sort_args) {
		(void)sprintf(str, "(give options to)  sortm +%s ", curflr->name);
		get_string(str, s1);
	}
	clear();
	addstatus("sorting mail ...", false);
	move(STATUS+1, 0);
	refresh();
	top_level = false;			/* used by tstp() so that right thing is done
								   when process is restarted */
	if(! vfork()) {
		(void)sprintf(str, "+%s", curflr->name);
		argv[0] = SORTM; argv[1] = str;
		for(i=2, tmp=s1 ; *tmp != '\0' ; i++) {
			argv[i] = tmp;
			tmp = next_token(tmp);
		}
		argv[i] = 0;
		no_control();
		execvp(SORTM, argv);
		(void)printf("Warning: can't execute %s\n", SORTM);
		exit(0);
	}
	oldint = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
	(void)wait(&status);
	(void)signal(SIGINT, oldint);
	(void)signal(SIGQUIT, oldquit);
	top_level = true;
	to_control();
	hold_end();					/* wait for user to want to continue - may wish
								   to read error messages */
	clear();
	move(STATUS, 0);
	refresh_folder();
}
