#define nil	0
#include <stdio.h>
#include <sys/types.h>
#include <string.h>

typedef struct {
	u32_t	low;
	u32_t	high;
} u64_t;

u64_t mul64(u32_t x, u32_t y);
/* Multiply two 32 bit numbers to form a 64 bit number.  (There are no doubt
 * very efficient ways to do this, but efficiency is not called for.)
 */
{
	u32_t x1 = x >> 16;
	u32_t x0 = x & 0xFFFF;		/* x == x1<<16 + x0 */
	u32_t y1 = y >> 16;
	u32_t y0 = y & 0xFFFF;		/* y == y1<<16 + y0 */
	u32_t x1y0, x0y1, middle;
	u64_t m;

	/* To compute: m = x1*y1<<32 + x1*y0<<16 + x0*y1<<16 + x0*y0 */
	m.low = x0 * y0;
	m.high = x1 * y1;
	x1y0 = x1 * y0;
	x0y1 = x0 * y1;

	m.high += (x1y0 >> 16) + (x0y1 >> 16);
	x1y0 &= 0xFFFF;
	x0y1 &= 0xFFFF;

	middle = x1y0 + x0y1 + (m.low >> 16);
	m.high += middle >> 16;
	m.low = (m.low & 0xFFFF) + (middle << 16);

	return m;
}

u32_t div64(u64_t m, u32_t x)
/* Divide a 64 bit number by a 32 bit number, no overflow expected.  (Like
 * above, no efficiency to be seen.)
 */
{
	u32_t q, b;
	u64_t t;

	/* Set each of the 32 bits in q and check if it's a good idea. */
	q = 0;
	for (b = 0x80000000; b != 0; b >>= 1) {
		q |= b;
		t = mul64(x, q);

		/* If t > m then bit b should not be set in q. */
		if (t.high > m.high || (t.high == m.high && t.low > m.low))
			q &= ~b;
	}
	return q;
}

int main(argc, argv) int argc; char **argv;
{
	u32_t x, y;
	u64_t m;

	x = strtoul(argv[1], (char **) nil, 0x10);
	y = strtoul(argv[2], (char **) nil, 0x10);
	m = mul64(x, y);
	printf("%08lx * %08lx = %08lx%08lx\n", x, y, m.high, m.low);
	printf("%08lx%08lx / %08lx = %08lx\n", m.high, m.low, x, div64(m, x));
	printf("%08lx%08lx / %08lx = %08lx\n", m.high, m.low, y, div64(m, y));
	exit(0);
}
