/*	void path_init(pathname_t *);
 *	void path_add(pathname_t *, const char *name);
 *	void path_trunc(pathname_t *, size_t didx);
 *	const char *path_name(const pathname_t *);
 *	size_t path_length(const pathname_t *);
 *	void path_drop(pathname_t *);
 *
 *	Needs stddef.h, string.h, and an enomem() function.
 *	(And a C++ compiler for an approach with more class.)
 */

typedef struct pathname {
	char		*path;	/* The actual pathname. */
	size_t		idx;	/* Index for the terminating null byte. */
	size_t		lim;	/* Actual length of the path array. */
} pathname_t;

void path_init(pathname_t *pp)
/* Initialize a pathname to the null string. */
{
	if ((pp->path= malloc(pp->lim= 16)) == NULL) enomem();
	pp->path[pp->idx= 0]= 0;
}

void path_add(pathname_t *pp, const char *name)
/* Add a component to a pathname. */
{
	size_t lim;
	char *p;
	int slash;

	lim= pp->idx + strlen(name) + 2;

	if (lim > pp->lim) {
		pp->lim= lim + lim/2;	/* add an extra 50% growing space. */

		if ((pp->path= realloc(pp->path, pp->lim)) == NULL) enomem();
	}

	p= pp->path + pp->idx;
	slash= (pp->idx > 0);
	if (pp->idx == 1 && p[-1] == '/') p--;

	while (*name != 0) {
		if (*name == '/') {
			slash= 1;
		} else {
			if (slash) { *p++ = '/'; slash= 0; }
			*p++= *name;
		}
		name++;
	}
	if (slash && p == pp->path) *p++= '/';
	*p = 0;
	pp->idx= p - pp->path;
}

void path_trunc(pathname_t *pp, size_t didx)
/* Delete part of a pathname to a remembered length. */
{
	pp->path[pp->idx= didx]= 0;
}

const char *path_name(const pathname_t *pp)
/* Return the actual name as a char array. */
{
	return pp->path;
}

size_t path_length(const pathname_t *pp)
/* The length of the pathname. */
{
	return pp->idx;
}

void path_drop(pathname_t *pp)
/* Release the storage occupied by the pathname. */
{
	free(pp->path);
}

#define path_name(pp)		((const char *) (pp)->path)
#define path_length(pp)		((pp)->idx)
#define path_drop(pp)		free((void *) (pp)->path)
