/*	vmstat 1.0 - virtual memory and swap status	Author: Kees J. Bot
 *								4 May 1996
 */
#define nil 0
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/svrctl.h>
#include <minix/queryparam.h>

#if __i386
#define PAGE_SIZE	4096
#endif

typedef u32_t vmdata_t[14];

static void get_vmdata(vmdata_t v)
/* Obtain the parameters used for VM administration. */
{
	struct svrqueryparam qpar;
	static char param[]=
		"locked_pages,floating_pages,free_dmacore_mem,"
		"free_coremem,free_swapmem,vm_not_alloc,"
		"pagein_cnt,pageout_cnt,bounce_pagein_cnt,bounce_pageout_cnt,"
		"total_dmacore_mem,total_coremem,total_swapmem";
	char value[13 * (2 * sizeof(u32_t) + 1)];
	char *pv;
	int i;

	/* Get the kernel parameters on virtual memory. */
	qpar.param= param;
	qpar.psize= sizeof(param);
	qpar.value= value;
	qpar.vsize= sizeof(value);

	if (svrctl(SYSQUERYPARAM, &qpar) < 0) {
		fprintf(stderr,
			"vmstat: can't query virtual memory parameters: %s\n",
			strerror(errno));
		exit(1);
	}

	pv= value;
	for (i= 0; i < 13; i++) paramvalue(&pv, &v[i], sizeof(v[i]));
	v[13]= v[10] + v[11] + v[12];
}

static void tell_pages(char *label, u32_t n)
{
	char K[3 * sizeof(n)];
	int len;

	sprintf(K, "%u", n * (PAGE_SIZE / 1024));
	len= strlen(K);

	if (len <= 6) {
		printf("%s%6u%*s(%sK)", label, n, 7 - len, "", K);
	} else {
		printf("%s%*s(%sK)", label, 13 - len, "", K);
	}
}

static void usage(void)
{
	fprintf(stderr, "Usage: vmstat [-t] [interval [count]]\n");
	exit(1);
}

int main(int argc, char **argv)
{
	int i, banner;
	unsigned long interval= 0;
	unsigned long count= 0;
	int total;
	vmdata_t v0, v1;
	long d[10];

	total= 0;
	i= 1;
	while (i < argc && argv[i][0] == '-') {
		char *opt= argv[i++] + 1;

		if (opt[0] == '-' && opt[1] == 0) break;

		while (*opt) switch (*opt++) {
		case 't':
			total= 1;
			break;
		default:
			usage();
		}
	}

	if (i < argc) {
		char *end;

		interval= strtoul(argv[i], &end, 10);
		if (end == argv[i] || *end != 0) usage();
		if (interval == 0 || (unsigned) interval != interval) usage();
		i++;
	}

	if (i < argc) {
		char *end;

		count= strtoul(argv[i], &end, 10);
		if (end == argv[i] || *end != 0) usage();
		if (count == 0) usage();
		i++;
	}

	if (i != argc) usage();

	if (interval == 0) {
		/* Show all. */
		get_vmdata(v0);
		tell_pages("locked pages:        ",   v0[0]);
		tell_pages("   floating pages:    ",  v0[1]);
		tell_pages("\nfree dma pages:      ", v0[2]);
		tell_pages("   total dma pages:   ", v0[10]);
		tell_pages("\nfree core pages:     ", v0[3]);
		tell_pages("   total core pages:  ", v0[11]);
		tell_pages("\nfree swap pages:     ", v0[4]);
		tell_pages("   total swap pages:  ", v0[12]);
		tell_pages("\nnot reserved pages:  ", v0[5]);
		tell_pages("   total virt pages:  ", v0[13]);
		tell_pages("\n# page in:           ", v0[6]);
		tell_pages("   # bounced page in: ",  v0[8]);
		tell_pages("\n# page out:          ", v0[7]);
		tell_pages("   # bounced page out:",  v0[9]);
		printf("\n");
		return 0;
	}

	if (total) {
		get_vmdata(v0);
	} else {
		for (i= 0; i < 10; i++) v0[i]= 0;
	}
	banner= 0;
	do {
		if (banner == 0) {
			printf("   lock   float     dma    core    swap    free      in     out     bin    bout\n");
			banner= 15;
		}
		banner--;

		get_vmdata(v1);
		for (i= 0; i < 10; i++) {
			d[i]= ((long) v1[i] - (long) v0[i]) * (PAGE_SIZE/1024);
		}

		for (i= 0; i < 10; i++) {
			if (i != 0) putchar(' ');
			printf("%7ld", d[i]);
		}
		putchar('\n');
		fflush(stdout);
		if (!total) {
			for (i= 0; i < 10; i++) v0[i]= v1[i];
		}
		sleep(interval);
	} while (count == 0 || --count > 0);

	return 0;
}
