/*	uptime 1.0 - show uptime, load average, etc.	Author: Kees J. Bot
 *								8 May 1994
 * This should be a link to w(1).
 */
#define nil 0
#define _MINIX_SOURCE	1
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <utmp.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/svrctl.h>
#include <minix/queryparam.h>

char UTMP[]= _U_UTMP;

unsigned nusers(void)
/* Number of logins as told by /etc/utmp. */
{
	unsigned n;
	struct utmp ut;
	FILE *uf;

	if ((uf= fopen(UTMP, "r")) == nil) {
		fprintf(stderr, "uptime: %s: %s\n", UTMP, strerror(errno));
		exit(1);
	}

	n= 0;
	while (fread(&ut, sizeof(ut), 1, uf) == 1) {
#ifdef USER_PROCESS
		if (ut.ut_type == USER_PROCESS) n++;
#else
		if (ut.ut_name[0] != 0 && ut.ut_line[0] != 0) n++;
#endif
	}
	fclose(uf);
	return n;
}

#define LDAV_6	0
#define LDAV_12	1
#define LDAV_16	2

void getloadav(unsigned long (*ldav)[3])
{
	struct svrqueryparam qpar;
	static char param[]= "loadav[1:3]";
	char value[2 * sizeof(*ldav) + 1];
	char *pv;

	qpar.param= param;
	qpar.psize= sizeof(param);
	qpar.value= value;
	qpar.vsize= sizeof(value);
	if (svrctl(SYSQUERYPARAM, &qpar) < 0) {
		fprintf(stderr, "uptime: getting load averages failed: %s\n",
			strerror(errno));
		exit(1);
	}
	pv= value;
	if (paramvalue(&pv, *ldav, sizeof(*ldav)) != sizeof(*ldav)) {
		fprintf(stderr, "uptime: no load averages available\n");
		exit(1);
	}
}

int main(int argc, char **argv)
{
	time_t now;
	struct tm *tm;
	struct timeval tv;
	unsigned long up;
	unsigned n;
	unsigned long ldav[3];

	/* Current time. */
	now= time((time_t *) nil);
	tm= localtime(&now);

	/* Uptime. */
	sysutime(UTIME_UPTIME, &tv);
	up= tv.tv_sec;

	/* Number of users. */
	n= nusers();

	/* Load average. */
	getloadav(&ldav);

	printf(" %d:%02d  up", tm->tm_hour, tm->tm_min);
	if (up >= 24 * 3600L) {
		unsigned long days= up / (24 * 3600L);
		printf(" %lu day%s,", days, days == 1 ? "" : "s");
	}
	printf(" %lu:%02lu,", (up % (24 * 3600L)) / 3600, (up % 3600) / 60);
	printf("  %u user%s,", n, n == 1 ? "" : "s");
	printf("  load average: %lu.%02lu, %lu.%02lu, %lu.%02lu\n",
		ldav[LDAV_6] >> 6,
		((ldav[LDAV_6] & ((1 << 6)-1))*100) >> 6,
		ldav[LDAV_12] >> 12,
		((ldav[LDAV_12] & ((1 << 12)-1))*100) >> 12,
		ldav[LDAV_16] >> 16,
		((ldav[LDAV_16] & ((1 << 16)-1))*100) >> 16);
	exit(0);
}
