/*
sysenv.c

Ask the MINIX kernel for a boot parameter.

Created:	May 20, 1992 by Philip Homburg
*/

#include <sys/types.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

char *prog_name;
char b[256];

void main _ARGS(( int argc, char *argv[] ));
void usage _ARGS(( void ));

void main(argc, argv)
int argc;
char *argv[];
{
	int r;
	char *key;

	prog_name= argv[0];

	if (argc != 2)
		usage();

	key= argv[1];

	r= sysenv(key, b, sizeof(b));
	if (r == -1)
	{
		if (errno == ESRCH)
			exit(2);

		fprintf(stderr, "%s: sysenv(%s) failed: %s\n", prog_name,
			key, strerror(errno));
		exit(1);
	}
	printf("%s\n", b);
	exit(0);
}

void usage()
{
	fprintf(stderr, "Usage: %s <boot-variable>\n", prog_name);
	exit(1);
}
