/* stat.c Feb 1987 - main, sizecheck, printit, statit
 *
 * stat - a program to perform what the stat(2) call does.  
 *
 * usage: stat [-] [-all] -<field> [-<field> ...] [file1 file2 file3 ...]
 *
 * where   <field> is one of the struct stat fields without the leading "st_".
 *	   The three times can be printed out as human times by requesting
 *	   -Ctime instead of -ctime (upper case 1st letter).
 *	   - means take the file names from stdin.
 *	   -0.. means fd0..
 *	   no files means all fds.
 *
 * output: if only one field is specified, that fields' contents are printed.
 *         if more than one field is specified, the output is
 *	   file	filed1: f1val, field2: f2val, etc
 *
 * written: Larry McVoy, (mcvoy@rsch.wisc.edu)  
 */

# define	ALLDEF		/* Make -all default. (kjb) */

# include	<errno.h>
# include	<limits.h>
# include	<stdio.h>
# include	<stdlib.h>
# include 	<string.h>
# include	<time.h>
# include	<sys/types.h>
# include	<sys/stat.h>
# define	addr(x)		(u_char*)(&sbuf.x)
# define	size(x)		sizeof(sbuf.x)
# define	equal(s, t)	(!strcmp(s, t))
# define	careful()	sizecheck()	/**/
# define	MAXPATH		500
# undef		LS_ADDS_SPACE	/* AT&T Unix PC, ls prints "file[* /]" */
				/* This makes stat fail. */

# ifndef S_IFSOCK		/* sys v doesn't do this, I guess */
#  ifndef BSD41
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;
#  endif
# else
#   define BSD
# endif

#ifndef S_IREAD
#define S_IREAD		S_IRUSR
#define S_IWRITE	S_IWUSR
#define S_IEXEC		S_IXUSR
#endif

struct stat sbuf;
extern int  errno;
#ifndef _MINIX
char* 	    ctime();
#endif
int	    first_file= 1;
#ifndef S_IFLNK
#define lstat	stat
#endif

struct field {
    char* f_name;	/* field name in stat */
    u_char* f_addr;	/* address of the field in sbuf */
    u_short f_size;	/* size of the object, needed for pointer arith */
    u_short f_print;	/* show this field? */
    u_short f_len;	/* max. length of the field when printed. (kjb) */
} fields[] = {
    { "dev",		addr(st_dev),		size(st_dev),		0, 10 },
    { "ino",		addr(st_ino),		size(st_ino),		0, 10 },
    { "mode",		addr(st_mode),		size(st_mode),		0, 27 },
    { "nlink",		addr(st_nlink),		size(st_nlink),		0, 12 },
    { "uid",		addr(st_uid),		size(st_uid),		0, 10 },
    { "gid",		addr(st_gid),		size(st_gid),		0, 10 },
    { "rdev",		addr(st_rdev),		size(st_rdev),		0, 11 },
    { "size",		addr(st_size),		size(st_size),		0, 15 },
    { "Atime",		addr(st_atime),		size(st_atime),		0, 31 },
    { "atime",		addr(st_atime),		size(st_atime),		0, 16 },
    { "Mtime",		addr(st_mtime),		size(st_mtime),		0, 31 },
    { "mtime",		addr(st_mtime),		size(st_mtime),		0, 16 },
    { "Ctime",		addr(st_ctime),		size(st_ctime),		0, 31 },
    { "ctime",		addr(st_ctime),		size(st_ctime),		0, 16 },
# ifdef BSD
    { "blksize", 	addr(st_blksize),	size(st_blksize),	0, 18 },
    { "blocks",		addr(st_blocks),	size(st_blocks),	0, 17 },
# endif
    { NULL,		  0,			0, },
};
    
#ifdef _ARGS
int main _ARGS(( int ac, char **av ));
int sizecheck _ARGS(( void ));
int printstat _ARGS(( struct stat *sbuf, int nprint ));
int printit _ARGS(( struct stat* sb, struct field* f, int n ));
int rwx _ARGS(( int mode, char *bit ));
#endif

main(ac, av)
    int ac;
    char** av;
{
    register i, j, nprint = 0, files = 0;
    char     buf[MAXPATH], *check, *arg0;
    int      sym=0, ret=0, from_stdin = 0;
    int      err, saverror, fd;

    careful();

    if ((arg0 = strrchr(av[0], '/')) == NULL) arg0 = av[0]; else arg0++;
#ifdef S_IFLNK
    if (equal(arg0, "lstat")) sym = 1;
#endif

    if (ac > 1 && equal(av[i = 1], "-"))
	i++, from_stdin++;

    for (i= 1; i<ac; i++)  {
	if (av[i][0] == '-')  {
	    if (equal(av[i], "-")) {
		from_stdin= 1;
		files++;
		continue;
	    }
	    if (equal("-all", av[i])) {
		for (j=0; fields[j].f_name; j++)
		    nprint++, fields[j].f_print++;
		continue;
	    }
	    if (equal("-s", av[i])) {
#ifdef S_IFLNK
		sym=1;
#endif
		continue;
	    }
	    strtol(av[i]+1, &check, 0);
	    if (check[0] == '\0')
	    {
		files++;
		continue;
	    }
	    for (j=0; fields[j].f_name; j++) 
		if (equal(fields[j].f_name, &av[i][1])) {
		    nprint++, fields[j].f_print++;
		    break;
		}
	    if (!fields[j].f_name) {
		fprintf(stderr, "stat: %s: bad field\n", av[i]);
		exit(1);
	    }
	}
	else 
	    files++;
    }
    if (!nprint) {
# ifndef ALLDEF
	fprintf(stderr, "usage: %s [-] [-fd] [-all] -field[s] file1[s]\n", 
		av[0]);
	exit(0);
# else
	for (j=0; fields[j].f_name; j++)
	    nprint++, fields[j].f_print++;
# endif
    }

    if (from_stdin)
	files++;	/* We don't know how many files come from stdin. */

    if (files == 0) {	/* Stat all file descriptors. */
	for (i= 0; i<OPEN_MAX; i++) {
	    err= fstat(i, &sbuf);
	    if (err == -1 && errno == EBADF)
		continue;
	    saverror= errno;
	    if (!first_file)    puts("");
	    printf("fd %d:", i);
	    if (err == 0) {
		puts("");
		printstat(&sbuf, nprint);
	    }
	    else {
		printf(": %s\n", i, strerror(errno));
		ret= 1;
	    }
	}
	exit(ret);
    }
		
    for (i=1; i<ac; i++) {
	if (equal(av[i], "-")) {
	    while (fgets(buf, sizeof(buf), stdin)) {
	    	char *p= strchr(buf, '\n');
	    	if (p) *p= 0;
		if (!sym) err= stat(av[i], &sbuf);
		if (sym || (err != 0 && errno == ENOENT)) err= lstat(av[i], &sbuf);
		saverror= errno;
		if (!first_file)    puts("");
		printf("%s:", buf);
		if (err == -1) {
		    printf(" %s\n", strerror(errno));
		    ret= 1;
		}
		else {
		    puts("");
		    printstat(&sbuf, nprint);
		}
	    }
	    continue;
	}
	if (av[i][0] == '-') {
	    fd= strtol(av[i]+1, &check, 0);
	    if (check[0] != '\0')
		continue;
	    err= fstat(fd, &sbuf);
	    saverror= errno;
	    if (!first_file)    puts("");
	    if (err == 0) {
		if (files != 1) printf("fd %d:\n", fd);
		printstat(&sbuf, nprint);
	    }
	    else {
		printf("fd %d: %s\n", fd, strerror(errno));
		ret= 1;
	    }
	    continue;
	}
	if (!sym) err= stat(av[i], &sbuf);
	if (sym || (err != 0 && errno == ENOENT)) err= lstat(av[i], &sbuf);
	saverror= errno;
	if (!first_file)    puts("");
	if (err == 0) {
	    if (files != 1) printf("%s:\n", av[i]);
	    printstat(&sbuf, nprint);
	}
	else {
	    printf("%s: %s\n", av[i], strerror(errno));
	    ret= 1;
	}
    }
    exit(ret);
}

/*------------------------------------------------------------------30/Jan/87-*
 * printstat(file, nprint) - do the work
 *----------------------------------------------------------------larry mcvoy-*/
printstat(sbuf, nprint)
    struct stat *sbuf;
    int nprint;
{
    register j;
    register first_field= 1;

    for (j=0; fields[j].f_name; j++) {
	if (fields[j].f_print) {
	    if (!first_field) puts("");
	    printit(sbuf, &fields[j], nprint);
	    first_field= 0;
	}
    }
    puts("");
    first_file= 0;
}

/*------------------------------------------------------------------30/Jan/87-*
 * printit(sb, f, n) - print the field
 *
 * Inputs    -> (struct stat*), (struct field*), (int)
 *
 * Results   -> Displays the field, with special handling of weird fields like
 *		mode and spare4.  The mode field is dumped in octal, followed
 *		by one or more of the S_IF<X> and/or S_I<X> values.  The spare4
 *		field is dumped as two u_longs.  All other fields are dumped
 *		as u_char, u_short, or u_long, as apporpriate.
 *----------------------------------------------------------------larry mcvoy-*/
printit(sb, f, n)
    register struct stat* sb;
    register struct field* f;
    int n;
{
    if (n > 1)
	printf("%s: ", f->f_name);
    if (equal(f->f_name, "mode")) {
		/* This lot changed to my personal liking. (kjb) */
	char bit[11];

	printf("%07o, ", sb->st_mode);

	strcpy(bit, "----------");

	switch (sb->st_mode&S_IFMT) {
	case S_IFDIR:	bit[0]='d';	break;
# ifdef S_IFFIFO
	case S_IFFIFO:	bit[0]='p';	break;
# endif
	case S_IFCHR:	bit[0]='c';	break;
	case S_IFBLK:	bit[0]='b';	break;
# ifdef S_IFSOCK
	case S_IFSOCK:	bit[0]='S';	break;
# endif
# ifdef S_IFMPC
	case S_IFMPC:	bit[0]='C';	break;
# endif
# ifdef S_IFMPB
	case S_IFMPB:	bit[0]='B';	break;
# endif
# ifdef S_IFLNK
	case S_IFLNK:	bit[0]='l';	break;
# endif
	}
	rwx(sb->st_mode, bit+1);
	rwx(sb->st_mode<<3, bit+4);
	rwx(sb->st_mode<<6, bit+7);
	if (sb->st_mode&S_ISUID)	bit[3]='s';
	if (sb->st_mode&S_ISGID)	bit[6]='s';
	if (sb->st_mode&S_ISVTX)	bit[9]='t';
	printf("\"%s\"", bit);
    }
    /* times in human form, uppercase first letter */
    else if (equal("Ctime", f->f_name)) {
	printf("%.24s (%u)", ctime(&sb->st_ctime), sb->st_ctime);
	f[1].f_print= 0;
    }
    else if (equal("Mtime", f->f_name)) {
	printf("%.24s (%u)", ctime(&sb->st_mtime), sb->st_mtime);
	f[1].f_print= 0;
    }
    else if (equal("Atime", f->f_name)) {
	printf("%.24s (%u)", ctime(&sb->st_atime), sb->st_atime);
	f[1].f_print= 0;
    }
    else if (equal("ctime", f->f_name)) 
	printf("%u", sb->st_ctime);
    else if (equal("mtime", f->f_name))
	printf("%u", sb->st_mtime);
    else if (equal("atime", f->f_name))
	printf("%u", sb->st_atime);
#if 0
# ifdef S_IFSOCK
    else if (equal("spare4", f->f_name))
	printf("%u %u", sb->st_spare4[0], sb->st_spare4[1]);
# endif
#endif
    else
	switch (f->f_size) {
	    case 1: printf("%u", *(u_char*)f->f_addr);
		    break;
	    case 2: printf("%u", *((u_short*)f->f_addr));
		    break;
	    case 4: printf("%u", *((u_long*)f->f_addr));
		    break;
	    default:fprintf(stderr, "\nError: bad field size %d (%s)\n", 
			    f->f_size, f->f_name);
		    break;
	}
}

rwx(mode, bit) register mode; register char *bit;
{
	if (mode&S_IREAD)	bit[0]='r';
	if (mode&S_IWRITE)	bit[1]='w';
	if (mode&S_IEXEC)	bit[2]='x';
}

sizecheck()
{
    if (sizeof(char) != 1)
	fprintf(stderr, "warning: char != 1\n");
    if (sizeof(short) != 2)
	fprintf(stderr, "warning: short != 2\n");
    if (sizeof(long) != 4)
	fprintf(stderr, "warning: long != 4\n");
}
