#!/bin/sh
#
# set_net_default 1.0 - Select the default TCP/IP network.
#							Author: Kees J. Bot

case $#:$1 in
1:eth0|1:ip0|1:tcp0|1:udp0)
	sel=0
	;;
1:eth1|1:ip1|1:tcp1|1:udp1)
	sel=1
	;;
1:psip0|1:ip2|1:tcp2|1:udp2)
	sel=2
	;;
1:psip1|1:ip3|1:tcp3|1:udp3)
	sel=3
	;;
*)	echo "Usage: set_net_default <sample-device>" >&2
	exit 1
esac

cd /dev || exit

case $sel in
0|1)	# Ethernet.
	chosen=eth$sel
	this=eth
	other=psip
	;;
2|3)	# Pseudo IP.
	chosen=psip`expr $sel - 2`
	this=psip
	other=eth
esac

set -e		# Bail out at the first error.

# Get rid of the "other" device.
if [ -c $other ]
then
	echo rm $other
	rm $other
fi

# Make links from the chosen devices to the default names.
echo ln $chosen $this
ln -f $chosen $this
echo ln ip$sel ip
ln -f ip$sel ip
echo ln tcp$sel tcp
ln -f tcp$sel tcp
echo ln udp$sel udp
ln -f udp$sel udp
