/*	rget 2.3 - remote pipe				Author: Kees J. Bot
 *								20 Mar 1989
 *
 * here$ ... | rput keyword		there$ rget -h here keyword | ...
 * here$ rput keyword command ...	there$ rget -h here keyword command ...
 *
 * (Once my first try at network programming.  Dumb as a doormat, but useful.)
 */
#define nil 0
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#if __minix
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/netdb.h>
#include <net/gen/socket.h>
#include <net/gen/tcp.h>
#include <net/gen/tcp_hdr.h>
#include <net/gen/tcp_io.h>
#include <net/hton.h>
#include <net/netlib.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

static char *name;

static void fatal(const char *label)
{
	int err= errno;

#if __minix
	fprintf(stderr, "%s: %s: %s\n", name, label, strerror(err));
#else
	fprintf(stderr, "%s: ", name);
	errno= err;
	perror(label);
#endif
	exit(1);
}

static int name2port(char *n)
{
	unsigned port= 1;

	while (*n != 0) port *= (*n++ & 0xFF);

	return (unsigned short) (port | 0x8000);
}

void execute(int input, int output, char **argv)
/* Run a command with I/O redirection to the TCP channel. */
{
	if (input != 0) {
		dup2(input, 0);
		close(input);
	}
	if (output != 1) {
		dup2(output, 1);
		close(output);
	}
	execvp(argv[0], argv);
	fatal(argv[0]);
}

void rget(int argc, char **argv)
{
	int s, n;
	struct hostent *h;
	char buf[8192];
#if __minix
	char *tcp_device;
	nwio_tcpconf_t tcpconf;
	nwio_tcpcl_t tcpconnopt;
#else
	static struct sockaddr_in channel;
#endif

	if (argc > 1) {
		if (strcmp(argv[1], "-h") == 0) {
			argv++;
			argc--;
		} else {
			fprintf(stderr,
"[The 'rget host key' form will soon be obsolete, use 'rget -h host key']\n");
		}
	}
	if (argc < 3) {
		fprintf(stderr,
		"Usage: %s -h remote-host keyword [command [arg ...]]\n",
			name);
		exit(1);
	}
	if ((h= gethostbyname(argv[1])) == nil) {
		fprintf(stderr, "%s: %s: Name lookup failed\n", name, argv[1]);
		exit(1);
	}

#if __minix
	if ((tcp_device= getenv("TCP_DEVICE")) == nil) tcp_device= "/dev/tcp";

	n=60;
	for (;;) {
		if ((s= open(tcp_device, O_RDWR)) < 0) fatal(tcp_device);

		tcpconf.nwtc_flags= NWTC_LP_SEL | NWTC_SET_RA | NWTC_SET_RP;
		tcpconf.nwtc_remaddr= * (ipaddr_t *) h->h_addr;
		tcpconf.nwtc_remport= htons(name2port(argv[2]));
		if (ioctl(s, NWIOSTCPCONF, &tcpconf) < 0) fatal("NWIOSTCPCONF");

		tcpconnopt.nwtcl_flags= 0;
		if (ioctl(s, NWIOTCPCONN, &tcpconnopt) == 0) break;

		if (--n>0) sleep(2); else fatal("NWIOTCPCONN");
		close(s);
	}
#else
	n=60;
	for (;;) {
		if ((s= socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
			fatal("socket()");

		channel.sin_family= AF_INET;
		channel.sin_addr.s_addr= * (u_long *) h->h_addr;
		channel.sin_port= htons(name2port(argv[2]));
		if (connect(s, (struct sockaddr *) &channel,
						sizeof(channel)) >= 0) break;

		if (--n > 0) sleep(2); else fatal("connect()");
		close(s);
	}
#endif

	if (argc > 3) execute(s, 1, argv + 3);

	while ((n= read(s, buf, sizeof(buf))) > 0) {
		if (write(1, buf, n) != n) fatal("write()");
	}
	if (n < 0) fatal("read()");

	exit(0);
}

void rput(int argc, char **argv)
{
	int s, get, n;
	char buf[8192];
#if __minix
	char *tcp_device;
	struct nwio_tcpconf tcpconf;
	struct nwio_tcpcl tcplistenopt;
#else
	static struct sockaddr_in channel, get_chan;
	static int on= 1;
#endif

	if (argc < 2) {
		fprintf(stderr,
			"Usage: %s keyword [command [arg ...]]\n", name);
		exit(1);
	}

#if __minix
	if ((tcp_device= getenv("TCP_DEVICE")) == nil) tcp_device= "/dev/tcp";
	if ((s= open(tcp_device, O_RDWR)) < 0) fatal(tcp_device);

	tcpconf.nwtc_flags= NWTC_EXCL | NWTC_LP_SET | NWTC_UNSET_RA |
							NWTC_UNSET_RP;
	tcpconf.nwtc_locport= htons(name2port(argv[1]));
	if (ioctl(s, NWIOSTCPCONF, &tcpconf) < 0) fatal("NWIOSTCPCONF");

	tcplistenopt.nwtcl_flags= 0;
	if (ioctl(s, NWIOTCPLISTEN, &tcplistenopt) < 0) fatal("NWIOTCPLISTEN");
	get= s;
#else
	if ((s= socket(AF_INET, SOCK_STREAM, IPPROTO_TCP))<0) fatal("socket()");

	(void) setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *) &on,
								sizeof(on));
	channel.sin_family= AF_INET;
	channel.sin_addr.s_addr= htonl(INADDR_ANY);
	channel.sin_port= htons(name2port(argv[1]));
	if (bind(s, (struct sockaddr *) &channel, sizeof(channel)) < 0)
		fatal("bind()");

	if (listen(s, 1) < 0) fatal("listen()");

	n= sizeof(get_chan);

	if ((get= accept(s, (struct sockaddr *) &get_chan, &n)) < 0)
		fatal("accept()");
#endif

	if (argc > 2) execute(0, get, argv + 2);

	while ((n= read(0, buf, sizeof(buf))) > 0) {
		char *bp= buf;

		while (n > 0) {
			int r, persist= 30;

			while ((r= write(get, bp, n)) < 0) {
				if (--persist == 0) fatal("write()");
				sleep(2);
			}
			bp+= r;
			n-= r;
		}
	}
	if (n<0) fatal("read()");

	exit(0);
}

int main(int argc, char **argv)
{
	if ((name= strrchr(argv[0], '/')) == nil) name= argv[0]; else name++;

	if (strcmp(name, "rget") == 0) rget(argc, argv);
	if (strcmp(name, "rput") == 0) rput(argc, argv);
	fprintf(stderr, "Don't know what to do if you call me '%s'\n", name);
	exit(1);
}
