#!/bin/sh
#
#	mkdep 1.1 - Generate Makefile dependencies.	Author: Kees J. Bot
#
# Does what 'cc -M' should do, but no compiler gets it right, they all
# strip the leading path of the '.o' file.)

case $# in
0)	echo "Usage: mkdep 'cpp command' file ..." >&2
	exit
esac

cpp="$1"; shift

for f
do
	: < "$f" || exit

	o=`expr "$f" : '\(.*\)\..*'`.o

	echo

	$cpp "$f" | \
		sed -e '/^#/!d
			s/.*"\(.*\)".*/\1/
			s:^\./::' \
		    -e "s:^:$o\:	:" | \
		sort -u
done

exit 0
