/*
staticr.c

Implementation of functions related to static routes.

Created:	Aug 16, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/syslog.h>
#include <sys/types.h>
#include <net/hton.h>
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/rip.h>
#include <net/gen/route.h>

#include "ansi.h"
#include "interface.h"
#include "itab.h"
#include "rip.h"
#include "staticr.h"
#include "update.h"

static int staticr_no;
static update_t *staticr_table;

DEFUN_VOID( void staticr_init)
{
	syslog(LOG_DEBUG, "staticr_init()");

	staticr_no= 0;
	staticr_table= NULL;
}

DEFUN_VOID( void staticr_load)
{
	char *cp1, *cp2, *cp3, *cp4;
	int i, j, ipfd, ent_no;
	nwio_route_t route;
	update_t update;
	update_t *tmp_table;

	syslog(LOG_DEBUG, "staticr_load()");
	if (interface_no == 0)
	{
		syslog(LOG_ERR, "staticr_load: no interfaces");
		return;
	}

	ipfd= interface_table->if_ipfd;

	/* Get the maximum number of routing entries */
	route.nwr_ent_no= 0;
	if (ioctl(ipfd, NWIOGIPIROUTE, &route) == -1)
	{
		syslog(LOG_ERR,
			"staticr_load: NWIOGIPIROUTE failed on fd %d: %m",
				ipfd);
		return;
	}
	ent_no= route.nwr_ent_count;

	staticr_no= ent_no + interface_no;
	staticr_table= malloc(staticr_no * sizeof(update_t));
	if (staticr_table == NULL)
	{
		syslog(LOG_ERR, "staticr_load: out of memory");
		return;
	}
	i= 0;
	for (j= 0; j<ent_no; j++)
	{
		route.nwr_ent_no= j;
		if (ioctl(ipfd, NWIOGIPIROUTE, &route) == -1)
		{
			syslog(LOG_ERR,
			"staticr_load: NWIOGIPIROUTE %d failed on fd %d: %m",
					j, ipfd);
			break;
		}
		if ((route.nwr_flags & (NWRF_INUSE|NWRF_STATIC)) != 
			(NWRF_INUSE|NWRF_STATIC))
		{
			continue;
		}
		if (route2update(&route, &staticr_table[i]) == -1)
			continue;
		i++;
	}

	/* Add entries for the interfaces */
	for (j= 0; j<interface_no; j++)
	{
		update.u_dest= interface_table[j].if_addr &
					interface_table[j].if_subnetmask;
		update.u_subnetmask= interface_table[j].if_subnetmask;
		update.u_ifno= j;
		update.u_gateway= (ipaddr_t)0;
		update.u_dist= rip_ifdist;
		staticr_table[i++]= update;
	}

	staticr_no= i;
	tmp_table= realloc(staticr_table, i*sizeof(update_t));
	if (tmp_table == NULL)
	{
		free(staticr_table);
		staticr_table= NULL;
		staticr_no= 0;
		syslog(LOG_ERR, "staticr_load: out of memory");
		return;
	}
	staticr_table= tmp_table;

	/* Sort the table */
	qsort(staticr_table, staticr_no, sizeof(update_t), update_compare);

	for (i= 0; i<staticr_no; i++)
	{
		cp1= strdup(inet_ntoa(htonl(staticr_table[i].u_dest)));
		cp2= strdup(inet_ntoa(htonl(staticr_table[i].u_subnetmask)));
		cp3= strdup(inet_ntoa(htonl(staticr_table[i].u_gateway)));
			syslog(LOG_DEBUG,
		"staticr_load: static route %d to %s[%s] via %d(%s) dist %d",
					i, cp1, cp2, staticr_table[i].u_ifno, 
					cp3, staticr_table[i].u_dist);
		free(cp1);
		free(cp2);
		free(cp3);
	}
}

DEFUN_VOID( void staticr_arrived)
{
	itab_update(staticr_table, staticr_no);
}
