/*
otab.h

Table for routing informating to be sent or stored in the kernel.

Created:	Aug 18, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef OTAB_H
#define OTAB_H

typedef struct otab
{
	ipaddr_t ot_dest;
	ipaddr_t ot_subnetmask;
	int ot_dist;
	int ot_type;
	struct
	{
		int oti_flags;
		int oti_poison_cnt;
		ipaddr_t oti_ifno;
		ipaddr_t oti_gateway;
	} ot_if[INTERFACE_MAX];
	struct otab *ot_next;
} otab_t;

#define OTT_NORMAL 0
#define OTT_DELETED 1

#define OTIF_TRIGGER	1
#define OTIF_INVALID	2

#define OTI_MAX_POISON	5

struct itab;
void otab_init ARGS(( void ));
int otab_add_normal ARGS(( struct itab *itab_p ));
int otab_add_subnet ARGS(( struct itab *itab_p ));
int otab_add_agregate ARGS(( struct itab *itab_p ));
int otab_update_normal ARGS(( otab_t *otab_p, struct itab *itab_p ));
int otab_update_subnet ARGS(( otab_t *otab_p, struct itab *itab_p ));
int otab_update_agregate ARGS(( otab_t *otab_p, struct itab *itab_p ));
int otab_remove_normal ARGS(( struct itab *itab_p ));
int otab_remove_subnet ARGS(( struct itab *itab_p ));
int otab_remove_agregate ARGS(( struct itab *itab_p ));
void otab_send ARGS(( int trigger ));
void otab_sendto ARGS(( ipaddr_t dest_addr, udpport_t dest_port,
	int trigger, int request ));
int otab_lookup ARGS(( int ifno, ipaddr_t addr ));
void otab_print ARGS(( int logtype, otab_t *ent ));
void otab_print_all ARGS(( int logtype ));

#endif /* OTAB_H */
