/*
ip_misc.h

Miscellaneous IP related definitions

Created:	Aug 13, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef IP_MISC_H
#define IP_MISC_H

typedef enum nettype
{
	IPNT_ZERO,		/*   0.xx.xx.xx */
	IPNT_CLASS_A,		/*   1.xx.xx.xx .. 126.xx.xx.xx */
	IPNT_LOCAL,		/* 127.xx.xx.xx */
	IPNT_CLASS_B,		/* 128.xx.xx.xx .. 191.xx.xx.xx */
	IPNT_CLASS_C,		/* 192.xx.xx.xx .. 223.xx.xx.xx */
	IPNT_CLASS_D,		/* 224.xx.xx.xx .. 239.xx.xx.xx */
	IPNT_CLASS_E,		/* 240.xx.xx.xx .. 247.xx.xx.xx */
	IPNT_MARSIAN,		/* 248.xx.xx.xx .. 254.xx.xx.xx + others */
	IPNT_BROADCAST		/* 255.255.255.255 */
} nettype_t;

nettype_t ip_nettype ARGS(( ipaddr_t ipaddr ));
ipaddr_t ip_netmask ARGS(( nettype_t nettype ));
char *ip_nettoa ARGS(( nettype_t nettype ));
int ip_add_route ARGS(( ipaddr_t dest, ipaddr_t subnetmask, 
				int ifno, ipaddr_t gateway, int dist ));
int ip_del_route ARGS(( ipaddr_t dest, ipaddr_t subnetmask, 
				int ifno, ipaddr_t gateway ));

#endif /* IP_MISC_H */
