/*
  log - log the shutdown's and the halt's

  Author: Edvard Tuinder  <v892231@si.hhs.NL>

  shutdown is logged in /usr/adm/wtmp and by syslog(3)
  reboot is logged only in /usr/adm/wtmp as `shutdown' to prevent last from
       reporting reboot's as crashes.

 */

#define _POSIX_SOURCE	1
#include <sys/types.h>
#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <sys/syslog.h>
#include <sys/utsname.h>
#undef WTMP

static char WTMP[] = "/usr/adm/wtmp";	/* Record of logins and logouts. */

extern char *prog;

void write_log _ARGS(( void ));

void write_log()
{
  int fd;
  static struct utmp wtmp;
  static struct passwd *pwd;
  char mes[90];
  time_t now;
  struct utsname utsname;
  char *host = "localhost";

  time(&now);

  if (uname(&utsname) >= 0) host = utsname.nodename;

  fd = open(WTMP,O_APPEND|O_WRONLY,1);
  if (fd != -1) {
    if (strcmp(prog,"reboot"))
      strcpy (wtmp.ut_user, prog);
    else
      strcpy (wtmp.ut_user, "shutdown"); /* last ... */
    strcpy (wtmp.ut_id, "~~");
    strcpy (wtmp.ut_line, "~");
    wtmp.ut_pid = 0;
    wtmp.ut_type = BOOT_TIME;
    wtmp.ut_time = now;
    wtmp.ut_host[0]= '\0';
    write (fd, (char *) &wtmp,sizeof(struct utmp));
    close(fd);
  }
  openlog(prog, 0, LOG_AUTH);
  syslog(LOG_NOTICE, "system %s by %s", prog,
	(pwd = getpwuid(getuid())) == 0 ? "root" : pwd->pw_name);
  closelog();
  sleep(1);	/* give syslogd a chance before we pull the plug */
}
