/*
ppp.h

Created:	May 25, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef PPP_H
#define PPP_H

struct ppp_snd_callback;

typedef  void (*psc_cbf_ut) ARGS(( struct ppp_snd_callback *cb, int arg ));

typedef struct ppp_snd_callback
{
	int psc_set;
	struct ppp_snd_callback *psc_next;
	psc_cbf_ut psc_cb_f;
	int psc_cb_arg;
} ppp_snd_callback_ut;

void ppp_rcv_init ARGS(( void ));
void ppp_rcv_completed ARGS(( int result, int error ));
void ppp_rcv_restart ARGS(( void ));

extern int ppp_rcv_inprogress;

extern int ppp_rcv_maxsize;
extern int ppp_rcv_hc_proto;
extern int ppp_rcv_hc_address;

void ppp_snd_init ARGS(( void ));
void ppp_snd_init_callback ARGS(( ppp_snd_callback_ut *callback, 
	psc_cbf_ut cb_f, int cb_arg ));
void ppp_snd_sethdr ARGS(( struct pkt *pkt, u16_t proto ));
int ppp_snd ARGS(( struct pkt *pkt, ppp_snd_callback_ut *callback ));
void ppp_snd_completed ARGS(( int result, int error ));
void ppp_snd_restart ARGS(( void ));

extern int ppp_snd_inprogress;
extern int ppp_snd_more2send;

extern int ppp_snd_maxsize;
extern int ppp_snd_hc_proto;
extern int ppp_snd_hc_address;

#define PPP_TYPE_IP		0x0021
#define PPP_TYPE_VJHC_COMPR	0x002D
#define PPP_TYPE_VJHC_UNCOMPR	0x002F
#define PPP_TYPE_IPCP		0x8021
#define PPP_TYPE_LCP		0xc021

#define PPP_BYTE_FLAG		0x7E
#define PPP_BYTE_ESCAPE		0x7D
#define PPP_BYTE_BIT6		0x20	/* warning bits are counted 87654321 */

#define PPP_HDR_ALLSTATIONS	0xFF
#define PPP_HDR_UI		0x03

#define PPP_DFLT_MAXSIZE	1500

#define PPP_MAX_HDR_SIZE	4

#define PPP_OPT_FORCED_OFF	-2
#define PPP_OPT_OFF		-1
#define PPP_OPT_NOCHANGE	 0
#define PPP_OPT_ON		 1
#define PPP_OPT_FORCED_ON	 2

#define MOD_IP			"ip"
#define MOD_LCP			"lcp"

#endif /* PPP_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/ppp.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
