/*
pkt.c

Created:	May 25, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "ansi.h"
#include "pkt.h"

DEFUN
(pkt_ut *pkt_alloc, (size),
	size_t size
)
{
	pkt_ut *pkt;

	pkt= malloc(sizeof(*pkt));
	assert(pkt != NULL);

	pkt->p_data= malloc(size);
	assert(pkt->p_data != NULL);

	pkt->p_offset= 0;
	pkt->p_size= 0;
	pkt->p_maxsize= size;

	return pkt;
}


DEFUN
(void pkt_free, (pkt),
	pkt_ut *pkt
)
{
	free(pkt->p_data);
	pkt->p_data= NULL;
	free(pkt);
}


DEFUN
(void pkt_realloc, (pkt, size),
	pkt_ut *pkt AND
	size_t size
)
{
	char *data;

	assert(pkt->p_offset + pkt->p_size <= size);

	data= realloc(pkt->p_data, size);
	assert(data != NULL);

	pkt->p_data= data;

	pkt->p_maxsize= size;
}

DEFUN
(void pkt_add, (pkt, data, size, chunk_size),
	pkt_ut *pkt AND
	void *data AND
	size_t size AND
	size_t chunk_size
)
{
	if (pkt->p_offset + pkt->p_size + size > pkt->p_maxsize)
		pkt_realloc(pkt, pkt->p_maxsize + size + chunk_size);
	memcpy(pkt->p_data + pkt->p_offset + pkt->p_size, data, size);
	pkt->p_size += size;
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/pkt.c,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
