/*
ncp.c

Created:	May 28, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <sys/types.h>

#include "ansi.h"
#include "clock.h"
#include "debug.h"
#include "ipcp.h"
#include "lcp.h"
#include "ncp.h"
#include "ppp.h"
#include "sm.h"

static int ncp_open_cnt;

DEFUN_VOID (void ncp_init)
{
	DPRINTF(1, ("ncp_init()\n"));
	ipcp_init();
	ncp_open_cnt= 0;
}


DEFUN_VOID (void ncp_up)
{
	DPRINTF(1, ("ncp_up()\n"));
	sm_up(&ipcp_state);
}


DEFUN_VOID (void ncp_down)
{
	DPRINTF(1, ("ncp_down()\n"));
	sm_down(&ipcp_state);
}


DEFUN_VOID (void ncp_tls)
{
	DPRINTF(1, ("ncp_tls()\n"));
	ncp_open_cnt++;
	if (ncp_open_cnt == 1)
		sm_open(&lcp_state);
}


DEFUN_VOID (void ncp_tlf)
{
	DPRINTF(1, ("ncp_tlf()\n"));
	ncp_open_cnt--;
	if (ncp_open_cnt == 0)
		sm_close(&lcp_state);
}


DEFUN
(void ncp_protocol_reject, (protocol),
	u16_t protocol
)
{
	DPRINTF(1, ("ncp_protocol_reject(protocol= 0x%04x)\n", protocol));
	switch(protocol)
	{
	case PPP_TYPE_IPCP:
		sm_down(&ipcp_state);
		break;
	default:
		DPRINTF(1, (
		"ncp_protocol_reject: unknown protocol got rejected\n"));
		break;
	}
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/ncp.c,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
