/*
ipcp.h

Created:	May 28, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#ifndef IPCP_H
#define IPCP_H

struct pkt;

/* ipcp.c */
void ipcp_init ARGS(( void ));
void ipcp_arrived ARGS(( struct pkt *pkt ));

/* ipcp_option.c */
void ipcpo_init ARGS(( void ));
void ipcpo_parse_arg ARGS(( int action, char *option ));
struct pkt *ipcpo_mk_request ARGS(( void ));
int ipcpo_got_request ARGS(( size_t length, u8_t *data, 
	struct pkt **ack_p, struct pkt **nak_p, struct pkt **rej_p ));
void ipcpo_got_ack ARGS(( void ));
int ipcpo_got_nak ARGS(( size_t length, u8_t *data, struct pkt *req_pkt ));
int ipcpo_got_reject ARGS(( size_t length, u8_t *data, struct pkt *req_pkt ));
void ipcpo_sending_ack ARGS(( void ));

extern struct sm_state ipcp_state;

#define IPCP_DFLT_MAX_CONFIGURE	10
#define IPCP_DFLT_MAX_TERMINATE	2
#define IPCP_DFLT_RESTART_TIMER	(3*CLOCKS_PER_SEC)
#define IPCP_DFLT_MAX_REJ	3		/* accept 3 rejects before
						 * deciding that there is an
						 * on/off conflict
						 */
#define IPCP_DFLT_MAX_NAK	10		/* accept 10 naks before
						 * deciding that there is an
						 * value conflict
						 */

#define IPCP_TYPE_CONFIGURE_REQ		1
#define IPCP_TYPE_CONFIGURE_ACK		2
#define IPCP_TYPE_CONFIGURE_NAK		3
#define IPCP_TYPE_CONFIGURE_REJECT	4
#define IPCP_TYPE_TERMINATE_REQ		5
#define IPCP_TYPE_TERMINATE_ACK		6
#define IPCP_TYPE_CODE_REJECT		7

#define IPCP_OPTION_ADDRESSES		 1
#define IPCP_OPTION_COMPRESSION		 2

#define OPT_VJHC			"ip.vjhc"
#define OPT_VJHC_SND			"ip.vjhc.snd"
#define OPT_VJHC_RCV			"ip.vjhc.rcv"
#define OPT_VJHC_MIN_SLOT_NR		1
#define OPT_VJHC_MAX_SLOT_NR		255

typedef struct opt_vjhc
{
	int action;
	int min_slot_nr;		/* Minimum # of slots */
	int max_slot_nr;		/* Maximum # of slots */
	int min_cid;			/* Allow or force id compression */
	int max_cid;			/* Allow or disallow id compression */

	int curr_action;
	int curr_slot_nr;
	int curr_cid;
	u8_t *curr_opt;
	int rej_retry;
	int nak_retry;
} opt_vjhc_ut;

extern opt_vjhc_ut opt_vjhc_snd;
extern opt_vjhc_ut opt_vjhc_rcv;

#endif /* IPCP_H */

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/ipcp.h,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
