/*
clock.c

Created:	May 24, 1993 by Philip Homburg <philip@cs.vu.nl>

Simple clock and timer module.
*/

#include <sys/types.h>
#include <assert.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include "ansi.h"
#include "clock.h"

int clck_timer_expired;

static clock_t clck_next_to;
static clck_timer_ut *clck_timer_q_head;
static time_t clck_base;

static void clck_alarm ARGS(( int sig ));


DEFUN_VOID (void clck_init)
{
	clck_timer_expired= 0;
	clck_next_to= 0;
	clck_timer_q_head= NULL;
	clck_base= time(NULL);
	signal(SIGALRM, clck_alarm);
}


DEFUN
(void clck_init_timer, (timer, func, ref),
	clck_timer_ut *timer AND
	void (*func) ARGS(( clck_timer_ut *timer, void *ref )) AND
	void *ref
)
{
	timer->ct_set= 0;
	timer->ct_func= func;
	timer->ct_ref= ref;
}


DEFUN
(void clck_set_timer, (timer, when),
	clck_timer_ut *timer AND
	clock_t when
)
{
	clock_t now;

	timer->ct_when= when;
	if (!timer->ct_set)
	{
		timer->ct_next= clck_timer_q_head;
		clck_timer_q_head= timer;
		timer->ct_set= 1;
	}
	if (when == 0)
	{
		clck_timer_expired= 1;
		return;
	}
	if (when < clck_next_to || clck_next_to == 0)
	{
		clck_next_to= when;
		now= clck_get_time();
		if (when <= now)
		{
			clck_timer_expired= 1;
			return;
		}
		if (!clck_timer_expired)
			alarm((when - now - 1)/CLOCKS_PER_SEC+1);
	}
}


DEFUN
(void clck_cancel_timer, (timer),
	clck_timer_ut *timer
)
{
	clck_set_timer(timer, 0);
}


DEFUN_VOID (clock_t clck_get_time)
{
	time_t tim;

	tim= time(NULL);

	assert(tim >= clck_base);
	tim -= clck_base;

	return tim*CLOCKS_PER_SEC+1;
}


DEFUN_VOID (void clck_chk_timers)
{
	clck_timer_ut *tmp_q, *timer;
	clock_t now;

	alarm(0);
	clck_timer_expired= 0;
	clck_next_to= 0;

	tmp_q= clck_timer_q_head;
	clck_timer_q_head= NULL;
	now= clck_get_time();
	while (tmp_q != NULL)
	{
		timer= tmp_q;
		tmp_q= timer->ct_next;

		assert(timer->ct_set);
		timer->ct_set= 0;
		if (timer->ct_when == 0)
			continue;
		if (timer->ct_when <= now)
		{
			(*timer->ct_func)(timer, timer->ct_ref);;
			continue;
		}
		clck_set_timer(timer, timer->ct_when);

	}
}


DEFUN
(static void clck_alarm, (sig),
	int sig
)
{
	clck_timer_expired= 1;
	signal(SIGALRM, clck_alarm);
	alarm(1);
}

/*
 * $PchHeader: /mount/hd2/minix/local/cmd/ppp/RCS/clock.c,v 1.1 1995/02/14 07:52:41 philip Exp $
 */
