/*	patchtree.h - generally useful definitions	Author: Kees J. Bot
 *								23 Jan 1994
 */

/* A patch generated starts with this magic string (printf format.) */
#define PTREE_MAGIC	"#*+-#*+- %u %lu %u %lu "

/* Support routines. */
void report(const char *label);
void fatal(const char *label);
void *allocate(void *mem, size_t len);
#define deallocate(mem)	free(mem)

/* 0 (other), 1 ("."), or 2 (".."). */
int isdots(const char *name);

/* Make a temporary directory in /usr/tmp, a filename in this dir, wipe dir. */
void maketmpdir(void);
char *tmpdirfile(char *name);
void wipetmpdir(void);

/* Put out the trash and exit. */
void quit(int excode);

/* Copy a file fast. */
void copyfile(const char *src, const char *dst);

/* Return the last component of a path name. */
char *basename(const char *path);

/* What to do (-d, -c, -u). */
typedef enum action { PATCH, DIFF, CDIFF, UDIFF } action_t;

#define DEFCONTEXT	(-1)	/* Default number of context lines. */

extern action_t action;		/* What to do. */
extern unsigned context;	/* How much context in a context diff. */
extern int nflag, zflag;	/* Playact?, Remove unchanged files? */
extern int fflag;		/* Force diffs even if larger. */

/* Try to make a good diff from original to target. */
char *diffone(char *original, char *target,
	unsigned ncrc, off_t nsize, unsigned ocrc, off_t osize, off_t *rsize);

/* Try to patch original with target. */
char *patchone(char *original, char *target,
	unsigned ncrc, off_t nsize, unsigned ocrc, off_t osize, off_t *rsize);

#ifndef S_ISLNK
#define lstat	stat
#endif
