/*	patchdos 1.7 - Patch up a relocated DOS partition
 *							Author: Kees J. Bot
 *								14 May 1992
 */
#define nil 0
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <minix/config.h>
#include <minix/const.h>
#include <minix/partition.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <limits.h>

#if !__minix_vmd
#define div64u(i, j)	((i) / (j))
#endif

#define SECTOR_SIZE	512

char bootblock[SECTOR_SIZE];

#define parm(type, offset)	(* (type *) (bootblock + (offset)))

/* Without thinking twice, the following numbers are patched in: */
#define SECTORS		parm(short, 0x18)	/* Sectors per track */
#define HEADS		parm(short, 0x1A)	/* Number of heads */
#define HIDDEN		parm(long, 0x1C)	/* Hidden sectors */
#define DRIVE		parm(char, 0x24)	/* Drive code (0x80, ...) */

char *arg0;

void report(const char *label)
{
	fprintf(stderr, "%s: %s: %s\n", arg0, label, strerror(errno));
}

void fatal(const char *label)
{
	report(label);
	exit(1);
}

int main(int argc, char **argv)
{
	char *device;
	int cyl, head, sec;
	struct stat st;
	int drive, f;
	struct partition geometry;

	if ((arg0= strrchr(argv[0], '/')) == nil) arg0= argv[0]; else arg0++;

	if (argc != 2) {
		fprintf(stderr, "Usage: %s dos-device\n", arg0);
		exit(1);
	}

	device= argv[1];

	if (stat(device, &st) < 0) fatal(device);

	if (!S_ISBLK(st.st_mode) && !S_ISCHR(st.st_mode)) {
		errno= ENODEV;
		fatal(device);
	}

	if ((f= open(device, O_RDWR)) < 0) fatal(device);

	if (ioctl(f, DIOCGETP, &geometry) < 0) fatal(device);

	switch (read(f, bootblock, SECTOR_SIZE)) {
	case -1:
		fatal(device);
	case SECTOR_SIZE:
		break;
	default:
		fprintf(stderr, "%s: Short read on %s\n", arg0, device);
		exit(1);
	}

	SECTORS= geometry.sectors;
	HEADS=   geometry.heads;
	HIDDEN=  div64u(geometry.base, SECTOR_SIZE);
	DRIVE=   st.st_rdev < 0x300 ? 0x00 : 0x80 + drive;

	if (lseek(f, (off_t) 0, SEEK_SET) == -1
		|| write(f, bootblock, SECTOR_SIZE) < 0) fatal(device);

	exit(0);
}
