/*
dis386int.h

Created:	Aug 27, 1992 by Philip Homburg
*/

#ifndef DIS386INT_H
#define DIS386INT_H

n386_t *i386_make_segment ARGS(( r386_t segment ));
n386_t *i386_make_register ARGS(( r386_t reg ));
n386_t *i386_make_const_i8 ARGS(( i8_t i8 ));
n386_t *i386_reg8_node ARGS(( int reg_no ));
n386_t *i386_reg16_node ARGS(( int reg_no ));
n386_t *i386_reg32_node ARGS(( int reg_no ));
n386_t *i386_data_reg_node ARGS(( int reg_no, int word ));
n386_t *i386_const_i8 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
n386_t *i386_const_u8 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
n386_t *i386_const16 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
n386_t *i386_const32 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
n386_t *i386_data_const ARGS(( char *block, unsigned size, unsigned *actsize_p, 
								int word ));
n386_t *i386_addr_const ARGS(( char *block, unsigned size, unsigned *actsize_p, 
								int word ));

extern int i386_data_32;
extern int i386_addr_32;
extern int i386_opsize_prefix;
extern int i386_addrsize_prefix;

#endif /* DIS386INT_H */
