/*
dis386.h

Created:	Aug 21, 1992 by Philip Homburg
*/

#ifndef DIS386_H
#define DIS386_H

typedef enum ntype
{
	/* opcodes */
	I386_ADD_0x,
	I386_OR_0x,
	I386_ADC_1x,
	I386_SBB_1x,
	I386_AND_2x,
	I386_SUB_2x,
	I386_DAA_27,
	I386_DAS_2F,
	I386_AAA_37,
	I386_AAS_3F,
	I386_XOR_3x,
	I386_CMP_3x,
	I386_INC_4x,
	I386_DEC_4x,
	I386_PUSHA_60,
	I386_POPA_61,
	I386_BOUND_62,
	I386_ARPL_63,
	I386_OPS16_66,
	I386_OPS32_66,
	I386_ADS16_67,
	I386_ADS32_67,
	I386_IMUL3_6x,
	I386_INS_6x,
	I386_OUTS_6x,
	I386_JO_70,
	I386_JNO_71,
	I386_JB_72,
	I386_JNB_73,
	I386_JZ_74,
	I386_JNZ_75,
	I386_JBE_76,
	I386_JNBE_77,
	I386_JS_78,
	I386_JNS_79,
	I386_JP_7A,
	I386_JNP_7B,
	I386_JL_7C,
	I386_JNL_7D,
	I386_JLE_7E,
	I386_JNLE_7F,
	I386_TEST_8x,
	I386_XCHG_8x,
	I386_MOV_8x,
	I386_LEA_8D,
	I386_NOP_90,
	I386_CBW_98,
	I386_CWD_99,
	I386_CALLF_9A,
	I386_WAIT_9B,
	I386_PUSHF_9C,
	I386_POPF_9D,
	I386_SAHF_9E,
	I386_LAHF_9F,
	I386_XCHG_9x,
	I386_MOV_Ax,
	I386_MOVS_Ax,
	I386_CMPS_Ax,
	I386_TEST_Ax,
	I386_STOS_Ax,
	I386_LODS_Ax,
	I386_SCAS_Ax,
	I386_MOV_Bx,
	I386_LES_C4,
	I386_LDS_C5,
	I386_RET_Cx,
	I386_RETF_Cx,
	I386_MOV_Cx,
	I386_ENTER_C8,
	I386_LEAVE_C9,
	I386_INT3_CC,
	I386_INT_CD,
	I386_INTO_CE,
	I386_IRET_CF,
	I386_AAM_D4,
	I386_AAD_D5,
	I386_XLAT_D7,
	I386_FNOP_D9_D0,
	I386_FCHS_D9_E0,
	I386_FABS_D9_E1,
	I386_FTST_D9_E4,
	I386_FXAM_D9_E5,
	I386_FLD1_D9_E8,
	I386_FLDL2T_D9_E9,
	I386_FLDL2E_D9_EA,
	I386_FLDPI_D9_EB,
	I386_FLDLG2_D9_EC,
	I386_FLDLN2_D9_ED,
	I386_FLDZ_D9_EE,
	I386_F2XM1_D9_F0,
	I386_FYL2X_D9_F1,
	I386_FPTAN_D9_F2,
	I386_FPATAN_D9_F3,
	I386_FXTRACT_D9_F4,
	I386_FPREM1_D9_F5,
	I386_FDECSTP_D9_F6,
	I386_FINCSTP_D9_F7,
	I386_FPREM_D9_F8,
	I386_FYL2XP1_D9_F9,
	I386_FSQRT_D9_FA,
	I386_FSINCOS_D9_FB,
	I386_FRNDINT_D9_FC,
	I386_FSCALE_D9_FD,
	I386_FSIN_D9_FE,
	I386_FCOS_D9_FF,
	I386_LDENV_D9_4,
	I386_FLDCW_D9_5,
	I386_STENV_D9_6,
	I386_FSTCW_D9_7,
	I386_FUCOMPP_DA_E9,
	I386_FCLEX_DB_E2,
	I386_FINIT_DB_E3,
	I386_FRSTOR_DB_4,
	I386_FFREE_DD_0,
	I386_FUCOM_DD_4,
	I386_FUCOMP_DD_5,
	I386_FSAVE_DD_6,
	I386_FCOMPP_DE_D9,
	I386_FBLD_DF_4,
	I386_FBSTP_DF_6,
	I386_FXCH_Dx,
	I386_FCOM_Dx,
	I386_FCOMP_Dx,
	I386_FADD_Dx,
	I386_FMUL_Dx,
	I386_FSUBR_Dx,
	I386_FSUB_Dx,
	I386_FDIVR_Dx,
	I386_FDIV_Dx,
	I386_FSTSW_Dx,
	I386_FLD_Dx,
	I386_FST_Dx,
	I386_FSTP_Dx,
	I386_FILD_Dx,
	I386_FIST_Dx,
	I386_FISTP_Dx,
	I386_FIMUL_Dx,
	I386_FIADD_Dx,
	I386_FICOM_Dx,
	I386_FICOMP_Dx,
	I386_FISUB_Dx,
	I386_FISUBR_Dx,
	I386_FIDIV_Dx,
	I386_FIDIVR_Dx,
	I386_FADDP_Dx,
	I386_FMULP_Dx,
	I386_FSUBRP_Dx,
	I386_FSUBP_Dx,
	I386_FDIVRP_Dx,
	I386_FDIVP_Dx,
	I386_LOOPNE_E0,
	I386_LOOPE_E1,
	I386_LOOP_E2,
	I386_JCXZ_E3,
	I386_IN_Ex,
	I386_OUT_Ex,
	I386_CALL_E8,
	I386_JMPF_EA,
	I386_LOCK_F0,
	I386_REPNE_F2,
	I386_REPE_F3,
	I386_HLT_F4,
	I386_CMC_F5,
	I386_CLC_F8,
	I386_STC_F9,
	I386_CLI_FA,
	I386_STI_FB,
	I386_CLD_FC,
	I386_STD_FD,

	I386_ADD_G1_0	=1000,
	I386_OR_G1_1,
	I386_ADC_G1_2,
	I386_SBB_G1_3,
	I386_AND_G1_4,
	I386_SUB_G1_5,
	I386_XOR_G1_6,
	I386_CMP_G1_7,
	I386_ROL_G2_0,
	I386_ROR_G2_1,
	I386_RCL_G2_2,
	I386_RCR_G2_3,
	I386_SHL_G2_4,
	I386_SHR_G2_5,
	I386_SAR_G2_7,
	I386_TEST_G3_0,
	I386_NOT_G3_2,
	I386_NEG_G3_3,
	I386_MUL_G3_4,
	I386_IMUL_G3_5,
	I386_DIV_G3_6,
	I386_IDIV_G3_7,
	I386_INC_G4_0,
	I386_DEC_G4_1,
	I386_INC_G5_0,
	I386_DEC_G5_1,
	I386_CALL_G5_2,
	I386_CALLF_G5_3,
	I386_JMPF_G5_5,
	I386_SLDT_G6_0,
	I386_STR_G6_1,
	I386_LLDT_G6_2,
	I386_LTR_G6_3,
	I386_VERR_G6_4,
	I386_VERW_G6_5,
	I386_SGDT_G7_0,
	I386_SIDT_G7_1,
	I386_LGDT_G7_2,
	I386_LIDT_G7_3,
	I386_SMSW_G7_4,
	I386_LMSW_G7_6,
	I386_BT_G8_4,
	I386_BTS_G8_5,
	I386_BTR_G8_6,
	I386_BTC_G8_7,

	I386_LAR_F_2	=2000,
	I386_LSL_F_3,
	I386_CLTS_F_6,
	I486_INVD_F_8,
	I486_WBINVD_F_9,
	I386_MOV_F_2x,
	I386_JO_F_80,
	I386_JNO_F_81,
	I386_JB_F_82,
	I386_JNB_F_83,
	I386_JZ_F_84,
	I386_JNZ_F_85,
	I386_JBE_F_86,
	I386_JNBE_F_87,
	I386_JS_F_88,
	I386_JNS_F_89,
	I386_JP_F_8A,
	I386_JNP_F_8B,
	I386_JL_F_8C,
	I386_JNL_F_8D,
	I386_JLE_F_8E,
	I386_JNLE_F_8F,
	I386_IMUL_F_AF,
	I386_SETO_F_90,
	I386_SETNO_F_91,
	I386_SETB_F_92,
	I386_SETNB_F_93,
	I386_SETZ_F_94,
	I386_SETNZ_F_95,
	I386_SETBE_F_96,
	I386_SETNBE_F_97,
	I386_SETS_F_98,
	I386_SETNS_F_99,
	I386_SETP_F_9A,
	I386_SETNP_F_9B,
	I386_SETL_F_9C,
	I386_SETNL_F_9D,
	I386_SETLE_F_9E,
	I386_SETNLE_F_9F,
	I386_BT_F_A3,
	I386_BTS_F_AB,
	I486_CMPXCHG_F_Ax,
	I386_SHLD_F_Ax,
	I386_SHRD_F_Ax,
	I386_LSS_F_B2,
	I386_BTR_F_B3,
	I386_LFS_F_B4,
	I386_LGS_F_B5,
	I386_BTC_F_BB,
	I386_BSF_F_BC,
	I386_BSR_F_BD,
	I386_MOVZX_F_Bx,
	I386_MOVSX_F_Bx,
	I486_XADD_F_Cx,
	I486_BSWAP_F_Cx,

	/* combined */
	I386_JMP	=3000,
	I386_POP,
	I386_PUSH,
	I386_SEG_PREF,

	/* expressions */
	I386_REG8	=4000,
	I386_REG16,
	I386_REG32,
	I386_REG_ST0,
	I386_REG_ST,
	I386_ADDRESS8,
	I386_ADDRESS16,
	I386_ADDRESS32,
	I386_ADDRESS64,
	I386_ADDRESS80,
	I386_ADDRESS14B,
	I386_ADDRESS28B,
	I386_ADDRESS94B,
	I386_ADDRESS108B,
	I386_ADDRESS_FAR16,
	I386_ADDRESS_FAR32,
	I386_ADDRESS16_16,
	I386_ADDRESS16_32,
	I386_ADDRESS32_32,
	I386_CONST_I8,
	I386_CONST_U8,
	I386_CONST16,
	I386_CONST32,
	I386_PCREL8,
	I386_PCREL16,
	I386_PCREL32,
	I386_SEG,
	I386_CREG,
	I386_DREG,
	I386_TREG,
	
	/* misc */
	I386_ILLEGAL	=5000,
	I386_NODE_TERMINATOR
} ntype_t;

typedef enum r386
{
	I386_REG8_FIRST,
	I386_AL,
	I386_CL,
	I386_DL,
	I386_BL,
	I386_AH,
	I386_CH,
	I386_DH,
	I386_BH,
	I386_REG8_LAST,
	
	I386_REG16_FIRST,
	I386_AX,
	I386_CX,
	I386_DX,
	I386_BX,
	I386_SP,
	I386_BP,
	I386_SI,
	I386_DI,
	I386_REG16_LAST,

	I386_REG32_FIRST,
	I386_EAX,
	I386_ECX,
	I386_EDX,
	I386_EBX,
	I386_ESP,
	I386_EBP,
	I386_ESI,
	I386_EDI,
	I386_REG32_LAST,
	
	I386_ES,
	I386_CS,
	I386_SS,
	I386_DS,
	I386_FS,
	I386_GS,

	I386_CR0,
	I386_CR1,
	I386_CR2,
	I386_CR3,
	I386_CR4,
	I386_CR5,
	I386_CR6,
	I386_CR7,

	I386_DR0,
	I386_DR1,
	I386_DR2,
	I386_DR3,
	I386_DR4,
	I386_DR5,
	I386_DR6,
	I386_DR7,

	I386_TR0,
	I386_TR1,
	I386_TR2,
	I486_TR3,
	I486_TR4,
	I486_TR5,
	I386_TR6,
	I386_TR7,

	I386_REG_TERMINATOR
} r386_t;

typedef struct n386 n386_t;

struct n386
{
	ntype_t n_type;
	union
	{
		n386_t *n_1addr;
		struct
		{
			n386_t *n_first;
			n386_t *n_second;
		} n_2addr;
		struct
		{
			n386_t *n_first;
			n386_t *n_second;
			n386_t *n_third;
		} n_3addr;
		struct
		{
			n386_t *n_dst;
			n386_t *n_src;
		} n_mov;
		r386_t n_reg;
		i8_t n_const_i8;
		u8_t n_const_u8;
		i16_t n_const16;
		i32_t n_const32;
		struct 
		{
			n386_t *n_segment;
			n386_t *n_base;
			int n_scale;
			n386_t *n_index;
			n386_t *n_disp;
		} n_address;
		struct
		{
			n386_t *n_offset;
			n386_t *n_segment;
		} n_far;
		int n_freg;
	} n_u;
};

void dis386_wordsize ARGS(( int word_size ));
n386_t *dis386 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
void n386_free ARGS(( n386_t *node ));
void n386_freetree ARGS(( n386_t *node ));
void n386_check ARGS(( void ));
n386_t *n386_alloc ARGS(( void ));

#if DEBUG & 2
#define n386_alloc() (printf("alloc: %s, %d\n", __FILE__, __LINE__), \
	(n386_alloc)())
#define n386_free(x) (printf("free: %s, %d\n", __FILE__, __LINE__), \
	(n386_free)(x))
#define n386_freetree(x) (printf("freetree: %s, %d\n", __FILE__, __LINE__), \
	(n386_freetree)(x))
#endif

#endif /* DIS386_H */
