/*
dis386.c

Created:	Aug 21, 1992 by Philip Homburg
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "ansi.h"

#include "types.h"
#include "dis386.h"
#include "dis386int.h"

static n386_t *dis ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *byte0_row0 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row1 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row2 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row3 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row4 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row5 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row6 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row7 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row8 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_row9 ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowA ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowB ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowC ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowD ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowE ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *byte0_rowF ARGS(( u8_t byte0, char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *modrm ARGS(( char *block, unsigned size, unsigned *actsize_p,
								int word ));
static n386_t *modrm_d16 ARGS(( char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *modrm_d32 ARGS(( char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *modrm_far ARGS(( char *block, unsigned size,
						unsigned *actsize_p ));
static n386_t *Grp1 ARGS(( char *block, unsigned size, unsigned *actsize_p,
								int word ));
static n386_t *Grp2 ARGS(( char *block, unsigned size, unsigned *actsize_p,
								int word ));
static n386_t *Grp3 ARGS(( char *block, unsigned size, unsigned *actsize_p,
								int word ));
static n386_t *Grp4 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *Grp5 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *Grp6 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *Grp7 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *Grp8 ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *modreg ARGS(( char *block, int word ));
static n386_t *modreg_d16 ARGS(( char *block ));
static n386_t *modseg ARGS(( char *block ));
static n386_t *modcreg ARGS(( char *block ));
static n386_t *moddreg ARGS(( char *block ));
static n386_t *modtreg ARGS(( char *block ));
static n386_t *f_modreg ARGS(( char *block ));
static n386_t *addr_reg_node ARGS(( int reg_no, int word ));
static n386_t *creg_node ARGS(( int reg_no ));
static n386_t *dreg_node ARGS(( int reg_no ));
static n386_t *treg_node ARGS(( int reg_no ));
static n386_t *f_reg_node ARGS(( int reg_no ));
static n386_t *seg_node ARGS(( int seg_no ));
static n386_t *sib ARGS(( char *block, unsigned size, unsigned *actsize_p,
							int mod, int word ));
static n386_t *pcrel ARGS(( char *block, unsigned size, unsigned *actsize_p,
								int word ));
static n386_t *two_byte ARGS(( char *block, unsigned size,
							unsigned *actsize_p ));
static n386_t *binop ARGS(( int opcode, char *block, unsigned size,
							unsigned *actsize_p ));
static n386_t *f_reg ARGS(( char *block, unsigned size, unsigned *actsize_p ));
static n386_t *f_modrm ARGS(( char *block, unsigned size, unsigned *actsize_p ));

DEFUN
(void dis386_wordsize, (word_size),
	int word_size
)
{
	if (word_size == 16)
	{
		i386_data_32= 0;
		i386_addr_32= 0;
	}
	else if (word_size == 32)
	{
		i386_data_32= 1;
		i386_addr_32= 1;
	}
	else
	{
		fprintf(stderr, "dis386_wordsize: illegal size %d\n",
			word_size);
		exit(1);
	}
}

DEFUN
(n386_t *dis386, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	i386_opsize_prefix= 0;
	i386_addrsize_prefix= 0;

	return dis(block, size, actsize_p);
}

DEFUN
(static n386_t *dis, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte0;
	int row;

	if (size == 0)
		return 0;

	byte0= block[0];
#if DEBUG & 2
printf("byte0= 0x%x\n", byte0);
#endif
	row= (byte0 >>4);
	switch(row)
	{
	case 0x0:
		return byte0_row0(byte0, block, size, actsize_p);
	case 0x1:
		return byte0_row1(byte0, block, size, actsize_p);
	case 0x2:
		return byte0_row2(byte0, block, size, actsize_p);
	case 0x3:
		return byte0_row3(byte0, block, size, actsize_p);
	case 0x4:
		return byte0_row4(byte0, block, size, actsize_p);
	case 0x5:
		return byte0_row5(byte0, block, size, actsize_p);
	case 0x6:
		return byte0_row6(byte0, block, size, actsize_p);
	case 0x7:
		return byte0_row7(byte0, block, size, actsize_p);
	case 0x8:
		return byte0_row8(byte0, block, size, actsize_p);
	case 0x9:
		return byte0_row9(byte0, block, size, actsize_p);
	case 0xA:
		return byte0_rowA(byte0, block, size, actsize_p);
	case 0xB:
		return byte0_rowB(byte0, block, size, actsize_p);
	case 0xC:
		return byte0_rowC(byte0, block, size, actsize_p);
	case 0xD:
		return byte0_rowD(byte0, block, size, actsize_p);
	case 0xE:
		return byte0_rowE(byte0, block, size, actsize_p);
	case 0xF:
		return byte0_rowF(byte0, block, size, actsize_p);
	default:
		printf("dis: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row0, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *o, *n, *r;
	unsigned actsize;

	switch(byte0)
	{
	case 0x0:
	case 0x1:
	case 0x2:
	case 0x3:
	case 0x4:
	case 0x5:
		n= binop(I386_ADD_0x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x6:
	case 0x7:
	case 0xE:
		if (byte0 & 8)
			o= i386_make_segment(I386_CS);
		else
			o= i386_make_segment(I386_ES);
		n= n386_alloc();
		if (byte0 & 1)
			n->n_type= I386_POP;
		else
			n->n_type= I386_PUSH;
		n->n_u.n_1addr= o;
		*actsize_p= 1;
		return n;
	case 0x8:
	case 0x9:
	case 0xA:
	case 0xB:
	case 0xC:
	case 0xD:
		n= binop(I386_OR_0x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0xF:
		n= two_byte(block+1, size-1, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	default:
		printf("byte0_row0: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row1, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r, *o;
	unsigned actsize;

	switch(byte0)
	{
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
		n= binop(I386_ADC_1x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x16:
	case 0x17:
	case 0x1E:
	case 0x1F:
		if (byte0 & 8)
			o= i386_make_segment(I386_DS);
		else
			o= i386_make_segment(I386_SS);
		n= n386_alloc();
		if (byte0 & 1)
			n->n_type= I386_POP;
		else
			n->n_type= I386_PUSH;
		n->n_u.n_1addr= o;
		*actsize_p= 1;
		return n;
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
	case 0x1C:
	case 0x1D:
		n= binop(I386_SBB_1x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	default:
		printf("byte0_row1: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row2, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r, *o;
	unsigned actsize;
	int word;

	switch(byte0)
	{
	case 0x20:
	case 0x21:
	case 0x22:
	case 0x23:
	case 0x24:
	case 0x25:
		n= binop(I386_AND_2x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x26:
	case 0x2E:
		n= n386_alloc();
		n->n_type= I386_SEG_PREF;
		if (byte0 == 0x26)
			n->n_u.n_1addr= i386_make_segment(I386_ES);
		else
			n->n_u.n_1addr= i386_make_segment(I386_CS);
		*actsize_p= 1;
		return n;
	case 0x27:
		n= n386_alloc();
		n->n_type= I386_DAA_27;
		*actsize_p= 1;
		return n;
	case 0x28:
	case 0x29:
	case 0x2A:
	case 0x2B:
	case 0x2C:
	case 0x2D:
		n= binop(I386_SUB_2x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x2F:
		n= n386_alloc();
		n->n_type= I386_DAS_2F;
		*actsize_p= 1;
		return n;
	default:
		printf("byte0_row2: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row3, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r, *o;
	unsigned actsize;

	switch(byte0)
	{
	case 0x30:
	case 0x31:
	case 0x32:
	case 0x33:
	case 0x34:
	case 0x35:
		n= binop(I386_XOR_3x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x36:
	case 0x3E:
		n= n386_alloc();
		n->n_type= I386_SEG_PREF;
		if (byte0 == 0x36)
			n->n_u.n_1addr= i386_make_segment(I386_SS);
		else
			n->n_u.n_1addr= i386_make_segment(I386_DS);
		*actsize_p= 1;
		return n;
	case 0x37:
		n= n386_alloc();
		n->n_type= I386_AAA_37;
		*actsize_p= 1;
		return n;
	case 0x38:
	case 0x39:
	case 0x3A:
	case 0x3B:
	case 0x3C:
	case 0x3D:
		n= binop(I386_CMP_3x, block, size, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize;
		return n;
	case 0x3F:
		n= n386_alloc();
		n->n_type= I386_AAS_3F;
		*actsize_p= 1;
		return n;
	default:
		printf("byte0_row3: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row4, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o;
	int opc;

	if (byte0 & 0x8)
		opc= I386_DEC_4x;
	else
		opc= I386_INC_4x;
	o= i386_data_reg_node(byte0 & 0x7, 1);
	n= n386_alloc();
	n->n_type= opc;
	n->n_u.n_1addr= o;
	*actsize_p= 1;
	return n;
}

DEFUN
(static n386_t *byte0_row5, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o;
	int opc;

	if (byte0 & 0x8)
		opc= I386_POP;
	else
		opc= I386_PUSH;
	o= i386_data_reg_node(byte0 & 0x7, 1);
	n= n386_alloc();
	n->n_type= opc;
	n->n_u.n_1addr= o;
	*actsize_p= 1;
	return n;
}

DEFUN
(static n386_t *byte0_row6, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o, *m, *r;
	unsigned actsize, actsize1;
	int word, out_instr;

	switch(byte0)
	{
	case 0x60:
		n= n386_alloc();
		n->n_type= I386_PUSHA_60;
		*actsize_p= 1;
		return n;
	case 0x61:
		n= n386_alloc();
		n->n_type= I386_POPA_61;
		*actsize_p= 1;
		return n;
	case 0x62:
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return m;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		if (m->n_type == I386_ADDRESS16)
			m->n_type= I386_ADDRESS16_16;
		else if (m->n_type == I386_ADDRESS32)
			m->n_type= I386_ADDRESS32_32;
		else
		{
			n386_freetree(m);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			*actsize_p= actsize+1;
			return n;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		n->n_type= I386_BOUND_62;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
		*actsize_p= actsize+1;
		return n;
	case 0x63:
		m= modrm_d16(block+1, size-1, &actsize);
		if (m == 0)
			return m;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg_d16(block+1);
		n= n386_alloc();
		n->n_type= I386_ARPL_63;
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
		*actsize_p= actsize+1;
		return n;
	case 0x64:
	case 0x65:
		n= n386_alloc();
		n->n_type= I386_SEG_PREF;
		if (byte0 == 0x64)
			n->n_u.n_1addr= i386_make_segment(I386_FS);
		else
			n->n_u.n_1addr= i386_make_segment(I386_GS);
		*actsize_p= 1;
		return n;
	case 0x66:
		i386_opsize_prefix= 1;
		o= dis(block+1, size-1, &actsize);
		if (o == 0)
			return 0;
		n= n386_alloc();
		if (i386_data_32)
			n->n_type= I386_OPS16_66;
		else
			n->n_type= I386_OPS32_66;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0x68:
	case 0x6A:
		if (byte0 & 2)
			word= 0;
		else
			word= 1;
		o= i386_data_const(block+1, size-1, &actsize, word);
		if (o == 0)
			return 0;
		n= n386_alloc();
		n->n_type= I386_PUSH;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0x69:
	case 0x6B:
		if (byte0 & 2)
			word= 0;
		else
			word= 1;
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		o= i386_data_const(block+1+actsize, size-1-actsize, &actsize1,
									word);
		if (o == 0)
		{
			n386_freetree(m);
			return 0;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		n->n_type= I386_IMUL3_6x;
		n->n_u.n_3addr.n_first= r;
		n->n_u.n_3addr.n_second= m;
		n->n_u.n_3addr.n_third= o;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0x6C:
	case 0x6D:
	case 0x6E:
	case 0x6F:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		if (byte0 & 2)
			out_instr= 1;
		else
			out_instr= 0;
		m= n386_alloc();
		if (word == 0)
			m->n_type= I386_ADDRESS8;
		else if ((i386_data_32 ^ i386_opsize_prefix) == 0)
			m->n_type= I386_ADDRESS16;
		else
			m->n_type= I386_ADDRESS32;
		if (out_instr)
		{
			m->n_u.n_address.n_segment= i386_make_segment(I386_DS);
			m->n_u.n_address.n_base= addr_reg_node(6, 1);
		}
		else
		{
			m->n_u.n_address.n_segment= i386_make_segment(I386_ES);
			m->n_u.n_address.n_base= addr_reg_node(7, 1);
		}
		m->n_u.n_address.n_index= 0;
		m->n_u.n_address.n_disp= 0;
		r= i386_make_register(I386_DX);
		n= n386_alloc();
		if (out_instr)
		{
			n->n_type= I386_OUTS_6x;
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= m;
		}
		else
		{
			n->n_type= I386_INS_6x;
			n->n_u.n_2addr.n_first= m;
			n->n_u.n_2addr.n_second= r;
		}
		*actsize_p= 1;
		return n;
	default:
		printf("byte0_row6: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row7, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o;
	unsigned actsize;
	int opc;

	o= pcrel(block+1, size-1, &actsize, 0);
	if (o == 0)
		return 0;
	switch(byte0)
	{
	case 0x70: opc= I386_JO_70; break;
	case 0x71: opc= I386_JNO_71; break;
	case 0x72: opc= I386_JB_72; break;
	case 0x73: opc= I386_JNB_73; break;
	case 0x74: opc= I386_JZ_74; break;
	case 0x75: opc= I386_JNZ_75; break;
	case 0x76: opc= I386_JBE_76; break;
	case 0x77: opc= I386_JNBE_77; break;
	case 0x78: opc= I386_JS_78; break;
	case 0x79: opc= I386_JNS_79; break;
	case 0x7A: opc= I386_JP_7A; break;
	case 0x7B: opc= I386_JNP_7B; break;
	case 0x7C: opc= I386_JL_7C; break;
	case 0x7D: opc= I386_JNL_7D; break;
	case 0x7E: opc= I386_JLE_7E; break;
	case 0x7F: opc= I386_JNLE_7F; break;
	default:
		printf("byte0_row7: byte0 =0x%x\n", byte0);
		exit(1);
	}
	n= n386_alloc();
	n->n_type= opc;
	n->n_u.n_1addr= o;
	*actsize_p= actsize+1;
	return n;
}

DEFUN
(static n386_t *byte0_row8, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r, *o;
	unsigned actsize, actsize1;
	int reg_first;
	int word;
	u8_t byte1;

	switch(byte0)
	{
	case 0x80:
	case 0x81:
		word= byte0 & 1;
		n= Grp1(block+1, size-1, &actsize, word);
		if (n == 0)
			return 0;
		if (n->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return n;
		}
		o= i386_data_const(block+1+actsize, size-1-actsize, &actsize1,
									word);
		if (o == 0)
		{
			n386_freetree(n);
			return 0;
		}
		n->n_u.n_2addr.n_second= o;
		*actsize_p= 1 + actsize + actsize1;
		return n;
	case 0x82:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	case 0x83:
		n= Grp1(block+1, size-1, &actsize, 1);
		if (n == 0)
			return 0;
		if (n->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return n;
		}
		o= i386_data_const(block+1+actsize, size-1-actsize, &actsize1,
									0);
		if (o == 0)
		{
			n386_freetree(n);
			return 0;
		}
		n->n_u.n_2addr.n_second= o;
		*actsize_p= 1 + actsize + actsize1;
		return n;
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
		if (size < 2)
			return 0;
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, word);
		n= n386_alloc();
		if (byte0 & 2)
			n->n_type= I386_XCHG_8x;
		else
			n->n_type= I386_TEST_8x;
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
		*actsize_p= actsize+1;
		return n;
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
		if (byte0 & 2)
			reg_first= 1;
		else
			reg_first= 0;
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		if (size < 2)
			return 0;
		m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, word);
		n= n386_alloc();
		n->n_type= I386_MOV_8x;
		if (reg_first)
		{
			n->n_u.n_mov.n_dst= r;
			n->n_u.n_mov.n_src= m;
		}
		else
		{
			n->n_u.n_mov.n_dst= m;
			n->n_u.n_mov.n_src= r;
		}
		*actsize_p= actsize+1;
		return n;
	case 0x8C:
	case 0x8E:
		reg_first= !!(byte0 & 2);
		if (size < 2)
			return 0;
		r= modseg(block+1);
		if (r->n_type == I386_ILLEGAL)
		{
			*actsize_p= 2;
			return r;
		}
		m= modrm_d16(block+1, size-1, &actsize);
		if (m == 0)
		{
			n386_freetree(r);
			return 0;
		}
		if (m->n_type == I386_ILLEGAL)
		{
			n386_freetree(r);
			*actsize_p= actsize+1;
			return m;
		}
		n= n386_alloc();
		n->n_type= I386_MOV_8x;
		if (reg_first)
		{
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= m;
		}
		else
		{
			n->n_u.n_2addr.n_first= m;
			n->n_u.n_2addr.n_second= r;
		}
		*actsize_p= actsize+1;
		return n;
	case 0x8D:
		if (size < 2)
			return 0;
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
		{
			return 0;
		}
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (m->n_type == I386_ADDRESS32 || m->n_type == I386_ADDRESS16)
			n->n_type= I386_LEA_8D;
		else
		{
			n->n_type= I386_ILLEGAL;
			n386_freetree(r);
			n386_freetree(m);
			*actsize_p= actsize+1;
			return n;
		}
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
		*actsize_p= actsize+1;
		return n;
	case 0x8F:
		if (size < 2)
			return 0;
		byte1= block[1];
		if ((byte1 & 0x38) != 0)
		{
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			*actsize_p= 2;
			return n;
		}
		o= modrm(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		if (o->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return o;
		}
		n= n386_alloc();
		n->n_type= I386_POP;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	default:
		printf("byte0_row8: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_row9, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *r, *r1, *o;
	unsigned actsize, actsize1;

	switch(byte0)
	{
	case 0x90:
		n= n386_alloc();
		n->n_type= I386_NOP_90;
		*actsize_p= 1;
		return n;
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
		r= i386_data_reg_node(0, 1);
		r1= i386_data_reg_node(byte0 & 0x7, 1);
		n= n386_alloc();
		n->n_type= I386_XCHG_9x;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		*actsize_p= 1;
		return n;
	case 0x98:
		n= n386_alloc();
		n->n_type= I386_CBW_98;
		*actsize_p= 1;
		return n;
	case 0x99:
		n= n386_alloc();
		n->n_type= I386_CWD_99;
		*actsize_p= 1;
		return n;
	case 0x9A:
		o= i386_data_const(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		r= i386_const16(block+1+actsize, size-1-actsize, &actsize1);
		if (r == 0)
		{
			n386_free(o);
			return 0;
		}
		n=n386_alloc();
		n->n_type= I386_CALLF_9A;
		n->n_u.n_far.n_offset= o;
		n->n_u.n_far.n_segment= r;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0x9B:
		n= n386_alloc();
		n->n_type= I386_WAIT_9B;
		*actsize_p= 1;
		return n;
	case 0x9C:
		n= n386_alloc();
		n->n_type= I386_PUSHF_9C;
		*actsize_p= 1;
		return n;
	case 0x9D:
		n= n386_alloc();
		n->n_type= I386_POPF_9D;
		*actsize_p= 1;
		return n;
	case 0x9E:
		n= n386_alloc();
		n->n_type= I386_SAHF_9E;
		*actsize_p= 1;
		return n;
	case 0x9F:
		n= n386_alloc();
		n->n_type= I386_LAHF_9F;
		*actsize_p= 1;
		return n;
	default:
		printf("byte0_row9: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_rowA, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r, *o, *src, *dst;
	unsigned actsize, actsize1;
	int reg_first;
	int word, type;
	u8_t byte1;
	int src_reg, dst_reg;

	switch(byte0)
	{
	case 0xA0:
	case 0xA1:
	case 0xA2:
	case 0xA3:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		if (byte0 & 2)
			reg_first= 0;
		else
			reg_first= 1;
		o= i386_addr_const(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		r= i386_data_reg_node(0, word);
		n= n386_alloc();
		if (word == 0)
			n->n_type= I386_ADDRESS8;
		else if (r->n_type == I386_REG32)
			n->n_type= I386_ADDRESS32;
		else
			n->n_type= I386_ADDRESS16;
		n->n_u.n_address.n_segment= i386_make_segment(I386_DS);
		n->n_u.n_address.n_base= 0;
		n->n_u.n_address.n_index= 0;
		n->n_u.n_address.n_disp= o;
		o= n;
		n= n386_alloc();
		n->n_type= I386_MOV_Ax;
		if (reg_first)
		{
			n->n_u.n_mov.n_dst= r;
			n->n_u.n_mov.n_src= o;
		}
		else
		{
			n->n_u.n_mov.n_dst= o;
			n->n_u.n_mov.n_src= r;
		}
		*actsize_p= actsize+1;
		return n;
	case 0xA4:
	case 0xA5:
	case 0xA6:
	case 0xA7:
	case 0xAA:
	case 0xAB:
	case 0xAC:
	case 0xAD:
	case 0xAE:
	case 0xAF:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		switch(byte0 & ~1)
		{
		case 0xA4: src_reg= 0; dst_reg= 0; type= I386_MOVS_Ax; break;
		case 0xA6: src_reg= 0; dst_reg= 0; type= I386_CMPS_Ax; break;
		case 0xAA: src_reg= 1; dst_reg= 0; type= I386_STOS_Ax; break;
		case 0xAC: src_reg= 0; dst_reg= 1; type= I386_LODS_Ax; break;
		case 0xAE: src_reg= 0; dst_reg= 1; type= I386_SCAS_Ax; break;
		default:
			printf("rowA: illegal opcode 0x%x\n", byte0);
			exit(1);
		}
		if (src_reg)
			src= i386_data_reg_node(0, word);
		else
		{
			src= n386_alloc();
			if (!word)
				src->n_type= I386_ADDRESS8;
			else if (!(i386_data_32 ^ i386_opsize_prefix))
				src->n_type= I386_ADDRESS16;
			else
				src->n_type= I386_ADDRESS32;
			src->n_u.n_address.n_segment= i386_make_segment(I386_DS);
			src->n_u.n_address.n_base= addr_reg_node(6, 1);
			src->n_u.n_address.n_index= 0;
			src->n_u.n_address.n_disp= 0;
		}
		if (dst_reg)
			dst= i386_data_reg_node(0, word);
		else
		{
			dst= n386_alloc();
			if (!word)
				dst->n_type= I386_ADDRESS8;
			else if (!(i386_data_32 ^ i386_opsize_prefix))
				dst->n_type= I386_ADDRESS16;
			else
				dst->n_type= I386_ADDRESS32;
			dst->n_u.n_address.n_segment= i386_make_segment(I386_ES);
			dst->n_u.n_address.n_base= addr_reg_node(7, 1);
			dst->n_u.n_address.n_index= 0;
			dst->n_u.n_address.n_disp= 0;
		}
		n= n386_alloc();
		n->n_type= type;
		n->n_u.n_2addr.n_first= dst;
		n->n_u.n_2addr.n_second= src;
		*actsize_p= 1;
		return n;
	case 0xA8:
	case 0xA9:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		o= i386_data_const(block+1, size-1, &actsize, word);
		if (o == 0)
			return 0;
		r= i386_data_reg_node(0, word);
		n= n386_alloc();
		n->n_type= I386_TEST_Ax;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= o;
		*actsize_p= actsize+1;
		return n;
	default:
		printf("byte0_rowA: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *byte0_rowB, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o, *r;
	unsigned actsize;
	int word, reg;

	word= !!(byte0 & 0x8);
	reg= byte0 & 0x7;
	o= i386_data_const(block+1, size-1, &actsize, word);
	if (o == 0)
		return 0;
	r= i386_data_reg_node(reg, word);
	n= n386_alloc();
	n->n_type= I386_MOV_Bx;
	n->n_u.n_mov.n_dst= r;
	n->n_u.n_mov.n_src= o;
	*actsize_p= actsize+1;
	return n;
}

DEFUN
(static n386_t *byte0_rowC, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o, *r, *c, *c1;
	unsigned actsize, actsize1;
	int word, reg;
	u8_t byte1;

	switch(byte0)
	{
	case 0xC0:
	case 0xC1:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		n= Grp2(block+1, size-1, &actsize, word);
		if (n == 0)
			return 0;
		if (n->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return n;
		}
		o= i386_const_i8(block+1+actsize, size-1-actsize, &actsize1);
		if (o == 0)
		{
			n386_freetree(n);
			return 0;
		}
		n->n_u.n_2addr.n_second= o;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xC2:
		o= i386_const16(block+1, size-1, &actsize);
		if (o == 0)
			return 0;
		n= n386_alloc();
		n->n_type= I386_RET_Cx;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0xC3:
		n= n386_alloc();
		n->n_type= I386_RET_Cx;
		n->n_u.n_1addr= 0;
		*actsize_p= 1;
		return n;
	case 0xC4:
	case 0xC5:
		o= modrm(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		*actsize_p= actsize+1;
		if (o->n_type == I386_ILLEGAL)
			return o;
		if (o->n_type == I386_ADDRESS32)
			o->n_type= I386_ADDRESS_FAR32;
		else if (o->n_type == I386_ADDRESS16)
			o->n_type= I386_ADDRESS_FAR16;
		else
		{
			n386_freetree(o);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			return n;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (byte0 & 1)
			n->n_type= I386_LDS_C5;
		else
			n->n_type= I386_LES_C4;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= o;
		return n;
	case 0xC6:
	case 0xC7:
		if (size < 2)
			return 0;
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		byte1= block[1];
		if (((byte1 >> 3) & 0x7) != 0)
		{
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			*actsize_p= 2;
			return n;
		}
		o= modrm(block+1, size-1, &actsize, word);
		if (o == 0)
			return 0;
		if (o->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return o;
		}

		c= i386_data_const(block+1+actsize, size-1-actsize, &actsize1,
									word);
		if (c == 0)
		{
			n386_freetree(o);
			return 0;
		}
		n= n386_alloc();
		n->n_type= I386_MOV_Cx;
		n->n_u.n_mov.n_dst= o;
		n->n_u.n_mov.n_src= c;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xC8:
		c= i386_const16(block+1, size-1, &actsize);
		if (c == 0)
			return 0;
		c1= i386_const_i8(block+1+actsize, size-1-actsize, &actsize1);
		if (c1 == 0)
		{
			n386_freetree(c);
			return 0;
		}
		n= n386_alloc();
		n->n_type= I386_ENTER_C8;
		n->n_u.n_2addr.n_first= c;
		n->n_u.n_2addr.n_second= c1;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xC9:
		n= n386_alloc();
		n->n_type= I386_LEAVE_C9;
		*actsize_p= 1;
		return n;
	case 0xCA:
		o= i386_const16(block+1, size-1, &actsize);
		if (o == 0)
			return 0;
		n= n386_alloc();
		n->n_type= I386_RETF_Cx;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0xCB:
		n= n386_alloc();
		n->n_type= I386_RETF_Cx;
		n->n_u.n_1addr= 0;
		*actsize_p= 1;
		return n;
	case 0xCC:
		n= n386_alloc();
		n->n_type= I386_INT3_CC;
		*actsize_p= 1;
		return n;
	case 0xCD:
		o= i386_const_u8(block+1, size-1, &actsize);
		if (o == 0)
			return 0;
		n= n386_alloc();
		n->n_type= I386_INT_CD;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0xCE:
		n= n386_alloc();
		n->n_type= I386_INTO_CE;
		*actsize_p= 1;
		return n;
	case 0xCF:
		n= n386_alloc();
		n->n_type= I386_IRET_CF;
		*actsize_p= 1;
		return n;
	default:
		printf("byte0_rowC: byte0 =0x%x\n", byte0);
		exit(1);
	}
}

DEFUN
(static n386_t *byte0_rowD, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o, *r;
	unsigned actsize, actsize1;
	int word, reg;
	u8_t byte1;

	switch(byte0)
	{
	case 0xD0:
	case 0xD1:
	case 0xD2:
	case 0xD3:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		n= Grp2(block+1, size-1, &actsize, word);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		if (n->n_type == I386_ILLEGAL)
			return n;
		if (byte0 & 2)
			o= i386_make_register(I386_CL);
		else
			o= i386_make_const_i8(1);
		n->n_u.n_2addr.n_second= o;
		return n;
	case 0xD4:
	case 0xD5:
		if (size < 2)
			return 0;
		byte1= block[1];
		n= n386_alloc();
		if (byte1 != 0x0A)
			n->n_type= I386_ILLEGAL;
		else
		{
			if (byte0 == 0xD4)
				n->n_type= I386_AAM_D4;
			else
				n->n_type= I386_AAD_D5;
		}
		*actsize_p= 2;
		return n;
	case 0xD6:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	case 0xD7:
		n= n386_alloc();
		n->n_type= I386_XLAT_D7;
		*actsize_p= 1;
		return n;
	case 0xD8:
	case 0xD9:
	case 0xDA:
	case 0xDB:
	case 0xDC:
	case 0xDD:
	case 0xDE:
	case 0xDF:	
		if (size < 2)
			return 0;
		byte1= block[1];
		if ((byte1 & 0xC0) == 0xC0)
			return f_reg(block, size, actsize_p);
		else
			return f_modrm(block, size, actsize_p);	
	default:
		printf("byte0_rowD: byte0 =0x%x\n", byte0);
		exit(1);
	}
}

DEFUN
(static n386_t *byte0_rowE, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *n, *o, *r;
	unsigned actsize, actsize1;
	int word, reg, type;

	switch(byte0)
	{
	case 0xE0:
	case 0xE1:
	case 0xE2:
	case 0xE3:
		o= pcrel(block+1, size-1, &actsize, 0);
		if (o == 0)
			return 0;
		n= n386_alloc();
		switch(byte0)
		{
		case 0xE0: type= I386_LOOPNE_E0; break;
		case 0XE1: type= I386_LOOPE_E1; break;
		case 0xE2: type= I386_LOOP_E2; break;
		case 0xE3: type= I386_JCXZ_E3; break;
		default:
			printf("rowE: illegal loop %d\n", byte0);
			exit(1);
		}
		n->n_type= type;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0xE4:
	case 0xE5:
	case 0xE6:
	case 0xE7:
	case 0xEC:
	case 0xED:
	case 0xEE:
	case 0xEF:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		if (byte0 & 0x8)
		{
			o= i386_make_register(I386_DX);
			actsize= 0;
		}
		else
		{
			o= i386_const_u8(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
		}
		r= i386_data_reg_node(0, word);
		n= n386_alloc();
		if (byte0 & 2)
		{
			n->n_type= I386_OUT_Ex;
			n->n_u.n_2addr.n_first= o;
			n->n_u.n_2addr.n_second= r;
		}
		else
		{
			n->n_type= I386_IN_Ex;
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= o;
		}
		*actsize_p= actsize+1;
		return n;
	case 0xE8:
	case 0xE9:
		o= pcrel(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		n= n386_alloc();
		if (byte0 == 0xE8)
			n->n_type= I386_CALL_E8;
		else
			n->n_type= I386_JMP;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0xEA:
		o= i386_data_const(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		r= i386_const16(block+1+actsize, size-1-actsize, &actsize1);
		if (r == 0)
		{
			n386_free(o);
			return 0;
		}
		n=n386_alloc();
		n->n_type= I386_JMPF_EA;
		n->n_u.n_far.n_offset= o;
		n->n_u.n_far.n_segment= r;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xEB:
		o= pcrel(block+1, size-1, &actsize, 0);
		if (o == 0)
			return 0;
		n= n386_alloc();
		n->n_type= I386_JMP;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	default:
		printf("byte0_rowE: byte0 =0x%x\n", byte0);
		exit(1);
	}
}

DEFUN
(static n386_t *byte0_rowF, (byte0, block, size, actsize_p),
	u8_t byte0 AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *m, *n, *r;
	unsigned actsize;
	int reg_first, word;

	switch(byte0)
	{
	case 0xF0:
		n= n386_alloc();
		n->n_type= I386_LOCK_F0;
		*actsize_p= 1;
		return n;
	case 0xF1:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	case 0xF2:
		n= n386_alloc();
		n->n_type= I386_REPNE_F2;
		*actsize_p= 1;
		return n;
	case 0xF3:
		n= n386_alloc();
		n->n_type= I386_REPE_F3;
		*actsize_p= 1;
		return n;
	case 0xF4:
		n= n386_alloc();
		n->n_type= I386_HLT_F4;
		*actsize_p= 1;
		return n;
	case 0xF5:
		n= n386_alloc();
		n->n_type= I386_CMC_F5;
		*actsize_p= 1;
		return n;
	case 0xF6:
	case 0xF7:
		if (byte0 & 1)
			word= 1;
		else
			word= 0;
		n= Grp3(block+1, size-1, &actsize, word);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	case 0xF8:
		n= n386_alloc();
		n->n_type= I386_CLC_F8;
		*actsize_p= 1;
		return n;
	case 0xF9:
		n= n386_alloc();
		n->n_type= I386_STC_F9;
		*actsize_p= 1;
		return n;
	case 0xFA:
		n= n386_alloc();
		n->n_type= I386_CLI_FA;
		*actsize_p= 1;
		return n;
	case 0xFB:
		n= n386_alloc();
		n->n_type= I386_STI_FB;
		*actsize_p= 1;
		return n;
	case 0xFC:
		n= n386_alloc();
		n->n_type= I386_CLD_FC;
		*actsize_p= 1;
		return n;
	case 0xFD:
		n= n386_alloc();
		n->n_type= I386_STD_FD;
		*actsize_p= 1;
		return n;
	case 0xFE:
		n= Grp4(block+1, size-1, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	case 0xFF:
		n= Grp5(block+1, size-1, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	default:
		printf("byte0_rowF: byte0 =0x%x\n", byte0);
		exit(1);
	}
	return 0;
}

DEFUN
(static n386_t *modrm, (block, size, actsize_p, word),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int word
)
{
	u8_t byte;
	int mod, rm;
	n386_t *n, *o, *i, *b;
	r386_t reg;
	unsigned actsize;
	int type;
	
	if (size == 0)
		return 0;
	byte= block[0];
	mod= (byte >> 6);
	rm= byte & 0x7;

	if (mod == 3)
	{
		n= i386_data_reg_node(rm, word);
		*actsize_p= 1;
		return n;
	}
	if (word == 0)
		type= I386_ADDRESS8;
	else if ((i386_data_32 ^ i386_opsize_prefix) == 0)
		type= I386_ADDRESS16;
	else
		type= I386_ADDRESS32;
	if ((i386_addr_32 ^ i386_addrsize_prefix) == 0)
	{
		if (mod == 0 && rm == 6)
		{
			o= i386_const16(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			n= n386_alloc();
			n->n_type= type;
			n->n_u.n_address.n_segment= 
						i386_make_segment(I386_DS);
			n->n_u.n_address.n_base= 0;
			n->n_u.n_address.n_index= 0;
			n->n_u.n_address.n_disp= o;
			*actsize_p= actsize+1;
			return n;
		}
		switch(mod)
		{
		case 0:
			o= 0;
			actsize= 0;
			break;
		case 1:
			o= i386_const_i8(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			break;
		case 2:
			o= i386_const16(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			break;
		}
		n= n386_alloc();
		n->n_type= type;
		if (rm == 2 || rm == 3 || rm == 6)
			n->n_u.n_address.n_segment= i386_make_segment(I386_SS);
		else
			n->n_u.n_address.n_segment= i386_make_segment(I386_DS);
		switch(rm)
		{
		case 0: 
			b= i386_make_register(I386_BX);
			i= i386_make_register(I386_SI);
			break;
		case 1: 
			b= i386_make_register(I386_BX);
			i= i386_make_register(I386_DI);
			break;
		case 2: 
			b= i386_make_register(I386_BP);
			i= i386_make_register(I386_SI);
			break;
		case 3: 
			b= i386_make_register(I386_BP);
			i= i386_make_register(I386_DI);
			break;
		case 4: 
			b= i386_make_register(I386_SI);
			i= 0;
			break;
		case 5: 
			b= i386_make_register(I386_DI);
			i= 0;
			break;
		case 6: 
			b= i386_make_register(I386_BP);
			i= 0;
			break;
		case 7: 
			b= i386_make_register(I386_BX);
			i= 0;
			break;
		default:
			printf("modrm: illegal rm16 %d\n", rm);
			exit(1);
		}	
		n->n_u.n_address.n_base= b;
		n->n_u.n_address.n_index= i;
		n->n_u.n_address.n_scale= 1;
		n->n_u.n_address.n_disp= o;
		*actsize_p= actsize+1;
		return n;
	}
	else
	{
		if (mod == 0 && rm == 5)
		{
			o= i386_const32(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			n= n386_alloc();
			n->n_type= type;
			n->n_u.n_address.n_segment= 
						i386_make_segment(I386_DS);
			n->n_u.n_address.n_base= 0;
			n->n_u.n_address.n_index= 0;
			n->n_u.n_address.n_disp= o;
			*actsize_p= actsize+1;
			return n;
		}
		if (rm == 4)
		{
			n= sib(block+1, size-1, &actsize, mod, word);
			if (n == 0)
				return 0;
			*actsize_p= actsize+1;
			return n;
		}
		switch(mod)
		{
		case 0:
			o= 0;
			actsize= 0;
			break;
		case 1:
			o= i386_const_i8(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			break;
		case 2:
			o= i386_const32(block+1, size-1, &actsize);
			if (o == 0)
				return 0;
			break;
		}
		n= n386_alloc();
		n->n_type= type;
		if (rm == 5)
			n->n_u.n_address.n_segment= i386_make_segment(I386_SS);
		else
			n->n_u.n_address.n_segment= i386_make_segment(I386_DS);
		n->n_u.n_address.n_base= i386_reg32_node(rm);
		n->n_u.n_address.n_index= 0;
		n->n_u.n_address.n_disp= o;
		*actsize_p= actsize+1;
		return n;
	}
}

DEFUN
(static n386_t *modrm_d16, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *o;

	if (i386_data_32 ^ i386_opsize_prefix)
	{
		i386_opsize_prefix= !i386_opsize_prefix;
		o= modrm(block, size, actsize_p, 1);
		i386_opsize_prefix= !i386_opsize_prefix;
	}
	else
		o= modrm(block, size, actsize_p, 1);
	return o;
}

DEFUN
(static n386_t *modrm_d32, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *o;

	if (i386_data_32 ^ i386_opsize_prefix)
		o= modrm(block, size, actsize_p, 1);
	else
	{
		i386_opsize_prefix= !i386_opsize_prefix;
		o= modrm(block, size, actsize_p, 1);
		i386_opsize_prefix= !i386_opsize_prefix;
	}
	return o;
}

DEFUN
(static n386_t *modrm_far, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	n386_t *o;

	o= modrm(block, size, actsize_p, 1);
	if (o == 0)
		return 0;
	if (o->n_type != I386_ADDRESS32 && o->n_type != I386_ADDRESS16)
		return o;
	if ((i386_addr_32 ^ i386_addrsize_prefix) == 0)
		o->n_type= I386_ADDRESS_FAR16;
	else
		o->n_type= I386_ADDRESS_FAR32;
	return o;
}

DEFUN
(static n386_t *modreg, (block, word),
	char *block AND
	int word
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return i386_data_reg_node(reg, word);
}

DEFUN
(static n386_t *modreg_d16, (block),
	char *block
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return i386_reg16_node(reg);
}

DEFUN
(static n386_t *modseg, (block),
	char *block
)
{
	u8_t byte;
	int seg;
	n386_t *n;

	byte= block[0];
	seg= (byte >> 3) & 0x7;
	
	return seg_node(seg);
}

DEFUN
(static n386_t *modcreg, (block),
	char *block
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return creg_node(reg);
}

DEFUN
(static n386_t *moddreg, (block),
	char *block
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return dreg_node(reg);
}

DEFUN
(static n386_t *modtreg, (block),
	char *block
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return treg_node(reg);
}

DEFUN
(static n386_t *f_modreg, (block),
	char *block
)
{
	u8_t byte;
	int reg;
	n386_t *n;

	byte= block[0];
	reg= (byte >> 3) & 0x7;
	
	return f_reg_node(reg);
}

DEFUN
(static n386_t *addr_reg_node, (reg_no, word),
	int reg_no AND
	int word
)
{
	n386_t *n;
	int reg;

	if (word == 0)
		n= i386_reg8_node(reg_no);
	else if ((i386_addr_32 ^ i386_addrsize_prefix) == 0)
		n= i386_reg16_node(reg_no);
	else
		n= i386_reg32_node(reg_no);
	return n;
}

DEFUN
(static n386_t *seg_node, (seg_no),
	int seg_no
)
{
	n386_t *n;
	
	switch(seg_no)
	{
	case 0: return i386_make_segment(I386_ES);
	case 1: return i386_make_segment(I386_CS);
	case 2: return i386_make_segment(I386_SS);
	case 3: return i386_make_segment(I386_DS);
	case 4: return i386_make_segment(I386_FS);
	case 5: return i386_make_segment(I386_GS);
	case 6:
	case 7:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		return n;
	default:
		printf("seg_node: illegal seg %d\n", seg_no);
		exit(1);
	}
}

DEFUN
(static n386_t *creg_node, (reg_no),
	int reg_no
)
{
	n386_t *n;
	int reg;

	n= n386_alloc();
	
	n->n_type= I386_CREG;
	switch(reg_no)
	{
	case 0: reg= I386_CR0; break;
	case 1: reg= I386_CR1; break;
	case 2: reg= I386_CR2; break;
	case 3: reg= I386_CR3; break;
	case 4: reg= I386_CR4; break;
	case 5: reg= I386_CR5; break;
	case 6: reg= I386_CR6; break;
	case 7: reg= I386_CR7; break;
	default:
		printf("creg_node: illegal reg %d\n", reg_no);
		exit(1);
	}
	n->n_u.n_reg= reg;
	return n;
}

DEFUN
(static n386_t *dreg_node, (reg_no),
	int reg_no
)
{
	n386_t *n;
	int reg;

	n= n386_alloc();
	
	n->n_type= I386_DREG;
	switch(reg_no)
	{
	case 0: reg= I386_DR0; break;
	case 1: reg= I386_DR1; break;
	case 2: reg= I386_DR2; break;
	case 3: reg= I386_DR3; break;
	case 4: reg= I386_DR4; break;
	case 5: reg= I386_DR5; break;
	case 6: reg= I386_DR6; break;
	case 7: reg= I386_DR7; break;
	default:
		printf("dreg_node: illegal reg %d\n", reg_no);
		exit(1);
	}
	n->n_u.n_reg= reg;
	return n;
}

DEFUN
(static n386_t *treg_node, (reg_no),
	int reg_no
)
{
	n386_t *n;
	int reg;

	n= n386_alloc();
	
	n->n_type= I386_TREG;
	switch(reg_no)
	{
	case 0: reg= I386_TR0; break;
	case 1: reg= I386_TR1; break;
	case 2: reg= I386_TR2; break;
	case 3: reg= I486_TR3; break;
	case 4: reg= I486_TR4; break;
	case 5: reg= I486_TR5; break;
	case 6: reg= I386_TR6; break;
	case 7: reg= I386_TR7; break;
	default:
		printf("treg_node: illegal reg %d\n", reg_no);
		exit(1);
	}
	n->n_u.n_reg= reg;
	return n;
}

DEFUN
(static n386_t *f_reg_node, (reg_no),
	int reg_no
)
{
	n386_t *n;

	n= n386_alloc();
	
	n->n_type= I386_REG_ST;
	n->n_u.n_freg= reg_no;
	return n;
}

DEFUN
(static n386_t *sib, (block, size, actsize_p, mod),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int mod AND
	int word
)
{
	u32_t displ;
	n386_t *n, *snode, *rnode, *dnode;
	u8_t sib_word;
	int ss, index, base;
	int scale;
	r386_t reg;
	unsigned actsize;
	
	if (size < 1)
		return 0;
		
	sib_word= *block;
	ss= sib_word >> 6;
	index= (sib_word >> 3) & 0x7;
	base= sib_word & 0x7;
	
	switch(mod)
	{
	case 0:
		actsize= 0;
		dnode= 0;
		if (base == 5)
		{
			if (index == 4 && ss != 0)
				; /* Error */
			else
			{
				dnode= i386_const32(block+1, size-1, &actsize);
				if (dnode == 0)
					return 0;
			}
		}
		if (base == 4)
			snode= i386_make_segment(I386_SS);
		else
			snode= i386_make_segment(I386_DS);
		break;
	case 1:
		if (index == 4 && ss != 0)
		{
			actsize= 0; /* Error */
			dnode= 0;
		}
		else
		{
			dnode= i386_const_i8(block+1, size-1, &actsize);
			if (dnode == 0)
				return 0;
		}
		if (base == 4 || base == 5)
			snode= i386_make_segment(I386_SS);
		else
			snode= i386_make_segment(I386_DS);
		break;
	case 2:
		if (index == 4 && ss != 0)
		{
			actsize= 0; /* Error */
			dnode= 0;
		}
		else
		{
			dnode= i386_const32(block+1, size-1, &actsize);
			if (dnode == 0)
				return 0;
		}
		if (base == 4 || base == 5)
			snode= i386_make_segment(I386_SS);
		else
			snode= i386_make_segment(I386_DS);
		break;
	default:
		printf("sib: illegal mod 0x%x\n", mod);
	}
	*actsize_p= actsize+1;
	
	n= n386_alloc();
	if (word)
		n->n_type= I386_ADDRESS32;
	else
		n->n_type= I386_ADDRESS8;
	n->n_u.n_address.n_segment= snode;
	n->n_u.n_address.n_disp= dnode;
	
	switch(ss)
	{
	case 0:	scale= 1; break;
	case 1:	scale= 2; break;
	case 2:	scale= 4; break;
	case 3:	scale= 8; break;
	default:
		printf("sib: illegal scale: 0x%x\n", ss);
		exit(1);
	}
	n->n_u.n_address.n_scale= scale;
	
	if (index == 4)
	{
		if (scale != 1)
		{
			n->n_u.n_address.n_base= 0;
			n->n_u.n_address.n_index= 0;
			n386_freetree(n);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			return n;
		}
		snode= 0;
	}
	else
		snode= i386_reg32_node(index);
	n->n_u.n_address.n_index= snode;
	
	if (mod == 0 && base == 0x5)
		rnode= 0;	/* Nothing, no base */
	else
		rnode= i386_reg32_node(base);
	n->n_u.n_address.n_base= rnode;
	return n;
}

DEFUN
(static n386_t *Grp1, (block, size, actsize_p, word),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int word
)
{
	u8_t byte;
	int opc;
	n386_t *n, *o;
	unsigned actsize;
	int type;
	
	if (size < 1)
		return 0;
	
	o= modrm(block, size, &actsize, word);
	if (o == 0)
		return 0;
	if (o->n_type == I386_ILLEGAL)
	{
		*actsize_p= actsize;
		return o;
	}
		
	n= n386_alloc();
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;
	switch(opc)
	{
	case 0: type= I386_ADD_G1_0; break;
	case 1: type= I386_OR_G1_1; break;
	case 2: type= I386_ADC_G1_2; break;
	case 3: type= I386_SBB_G1_3; break;
	case 4: type= I386_AND_G1_4; break;
	case 5: type= I386_SUB_G1_5; break;
	case 6: type= I386_XOR_G1_6; break;
	case 7: type= I386_CMP_G1_7; break;
	default:
		printf("Grp1: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	n->n_type= type;
	n->n_u.n_2addr.n_first= o;
	n->n_u.n_2addr.n_second= 0;
	*actsize_p= actsize;
	return n;
}

DEFUN
(static n386_t *Grp2, (block, size, actsize_p, word),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int word
)
{
	u8_t byte;
	int opc;
	n386_t *n, *o;
	unsigned actsize;
	int type;
	
	if (size < 1)
		return 0;
	byte= block[0];
	opc= (byte >> 3) & 0x7;
	if (opc == 6)
	{
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}
	
	o= modrm(block, size, &actsize, word);
	if (o == 0)
		return 0;
	*actsize_p= actsize;
	if (o->n_type == I386_ILLEGAL)
		return o;
		
	n= n386_alloc();
	
	switch(opc)
	{
	case 0: type= I386_ROL_G2_0; break;
	case 1: type= I386_ROR_G2_1; break;
	case 2: type= I386_RCL_G2_2; break;
	case 3: type= I386_RCR_G2_3; break;
	case 4: type= I386_SHL_G2_4; break;
	case 5: type= I386_SHR_G2_5; break;
	case 7: type= I386_SAR_G2_7; break;
	default:
		printf("Grp2: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	n->n_type= type;
	n->n_u.n_2addr.n_first= o;
	n->n_u.n_2addr.n_second= 0;
	return n;
}

DEFUN
(static n386_t *Grp3, (block, size, actsize_p, word),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int word
)
{
	u8_t byte;
	int opc, type;
	n386_t *n, *o, *c, *r;
	unsigned actsize, actsize1;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;
	switch(opc)
	{
	case 0:
		o= modrm(block, size, &actsize, word);
		if (o == 0)
			return 0;
		if (o->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize;
			return o;
		}
		c= i386_data_const(block+actsize, size-actsize, &actsize1, 
									word);
		if (c == 0)
		{
			n386_freetree(o);
			return 0;
		}
		n= n386_alloc();
		n->n_type= I386_TEST_G3_0;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= c;
		*actsize_p= actsize+actsize1;
		return n;
	case 1:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	case 2:
	case 3:
		o= modrm(block, size, &actsize, word);
		if (o == 0)
			return 0;
		*actsize_p= actsize;
		if (o->n_type == I386_ILLEGAL)
			return o;
		n= n386_alloc();
		if (opc & 1)
			n->n_type= I386_NEG_G3_3;
		else
			n->n_type= I386_NOT_G3_2;
		n->n_u.n_1addr= o;
		return n;
	case 4:
	case 5:
	case 6:
	case 7:
		o= modrm(block, size, &actsize, word);
		if (o == 0)
			return 0;
		*actsize_p= actsize;
		if (o->n_type == I386_ILLEGAL)
			return o;
		r= i386_data_reg_node(0, word);
		n= n386_alloc();
		switch(opc)
		{
		case 4: type= I386_MUL_G3_4; break;
		case 5: type= I386_IMUL_G3_5; break;
		case 6: type= I386_DIV_G3_6; break;
		case 7: type= I386_IDIV_G3_7; break;
		default:
			printf("Grp3: illegal mul/div opc %d\n", opc);
			exit(1);
		}
		n->n_type= type;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= o;
		return n;
	default:
		printf("Grp3: illegal opc: 0x%x\n", opc);
		exit(1);
	}
}

DEFUN
(static n386_t *Grp4, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte;
	int opc, opcode;
	n386_t *n, *o;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;

	if (opc >= 2)
	{
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}
	
	switch(opc)
	{
	case 0: opcode= I386_INC_G4_0; break;
	case 1: opcode= I386_DEC_G4_1; break;
	default:
		printf("Grp4: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	o= modrm(block, size, &actsize, 0);
	if (o == 0)
		return 0;
	*actsize_p= actsize;
	if (o->n_type == I386_ILLEGAL)
		return o;
	n= n386_alloc();
	n->n_type= opcode;
	n->n_u.n_1addr= o;
	return n;
}

DEFUN
(static n386_t *Grp5, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte;
	int opc, type;
	n386_t *n, *o;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;
	switch(opc)
	{
	case 0:
	case 1:
	case 2:
	case 4:
	case 6:
		o= modrm(block, size, &actsize, 1);
		if (o == 0)
			return 0;
		*actsize_p= actsize;
		if (o->n_type == I386_ILLEGAL)
			return o;
		switch(opc)
		{
		case 0: type= I386_INC_G5_0; break;
		case 1: type= I386_DEC_G5_1; break;
		case 2: type= I386_CALL_G5_2; break;
		case 4: type= I386_JMP; break;
		case 6: type= I386_PUSH; break;
		default:
			printf("Grp5: illegal opcode with Ev 0x%x\n", opc);
			exit(1);
		}
		n= n386_alloc();
		n->n_type= type;
		n->n_u.n_1addr= o;
		return n;
	case 3:
	case 5:
		o= modrm_far(block, size, &actsize);
		if (o == 0)
			return 0;
		*actsize_p= actsize;
		if (o->n_type == I386_ILLEGAL)
			return o;
		if (o->n_type == I386_REG32)
		{
			n386_freetree(o);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			return n;
		}
		n= n386_alloc();
		if (opc == 3)
			n->n_type= I386_CALLF_G5_3;
		else
			n->n_type= I386_JMPF_G5_5;
		n->n_u.n_1addr= o;
		return n;
	case 7:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	default:
		printf("Grp5: illegal opc: 0x%x\n", opc);
		exit(1);
	}
}

DEFUN
(static n386_t *Grp6, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte;
	int opc, opcode;
	n386_t *n, *o;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;

	if (opc == 6 || opc == 7)
	{
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}
	
	switch(opc)
	{
	case 0x0: opcode= I386_SLDT_G6_0; break;
	case 0x1: opcode= I386_STR_G6_1; break;
	case 0x2: opcode= I386_LLDT_G6_2; break;
	case 0x3: opcode= I386_LTR_G6_3; break;
	case 0x4: opcode= I386_VERR_G6_4; break;
	case 0x5: opcode= I386_VERW_G6_5; break;
	default:
		printf("Grp6: illegal opc: %d\n", opc);
		exit(1);
	}
	
	/* Force 16 bit data transfer */
	o= modrm_d16(block, size, &actsize);
	if (o == 0)
		return 0;
	*actsize_p= actsize;
	if (o->n_type == I386_ILLEGAL)
		return o;
	n= n386_alloc();
	n->n_type= opcode;
	n->n_u.n_1addr= o;
	return n;
}

DEFUN
(static n386_t *Grp7, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte;
	int opc, opcode;
	n386_t *n, *o;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;

	if (opc == 5 || opc == 7)
	{
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}
	
	if (opc == 4 || opc == 6)
	{
		if (opc == 4)
			opcode= I386_SMSW_G7_4;
		else
			opcode= I386_LMSW_G7_6;
	
		/* Force 16 bit data transfer */
		o= modrm_d16(block, size, &actsize);
		if (o == 0)
			return 0;
		*actsize_p= actsize;
		if (o->n_type == I386_ILLEGAL)
			return o;
		n= n386_alloc();
		n->n_type= opcode;
		n->n_u.n_1addr= o;
		return n;
	}
	
	switch(opc)
	{
	case 0: opcode= I386_SGDT_G7_0; break;
	case 1: opcode= I386_SIDT_G7_1; break;
	case 2: opcode= I386_LGDT_G7_2; break;
	case 3: opcode= I386_LIDT_G7_3; break;
	default:
		printf("Grp7: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	
	o= modrm(block, size, &actsize, 1);
	if (o == 0)
		return 0;
	*actsize_p= actsize;
	if (o->n_type == I386_ILLEGAL)
		return o;
	if (o->n_type == I386_REG32 || o->n_type == I386_REG16)
	{
		n386_freetree(o);
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		return n;
	}
	o->n_type= I386_ADDRESS16_32;
	n= n386_alloc();
	n->n_type= opcode;
	n->n_u.n_1addr= o;
	return n;
}

DEFUN
(static n386_t *Grp8, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte;
	int opc, opcode;
	n386_t *n, *o;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	
	byte= block[0];
	opc= (byte >> 3) & 0x7;

	if (opc >= 0 && opc < 4)
	{
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}
	
	switch(opc)
	{
	case 4: opcode= I386_BT_G8_4; break;
	case 5: opcode= I386_BTS_G8_5; break;
	case 6: opcode= I386_BTR_G8_6; break;
	case 7: opcode= I386_BTC_G8_7; break;
	default:
		printf("Grp8: illegal opc: %d\n", opc);
		exit(1);
	}
	
	o= modrm(block, size, &actsize, 1);
	if (o == 0)
		return 0;
	*actsize_p= actsize;
	if (o->n_type == I386_ILLEGAL)
		return o;
	n= n386_alloc();
	n->n_type= opcode;
	n->n_u.n_2addr.n_first= o;
	return n;
}

DEFUN
(static n386_t *pcrel, (block, size, actsize_p, word),
	char *block AND
	unsigned size AND
	unsigned *actsize_p AND
	int word

)
{
	n386_t *n, *o;

	o= i386_addr_const(block, size, actsize_p, word);
	if (o == 0)
		return 0;
	n= n386_alloc();
	switch(o->n_type)
	{
	case I386_CONST_I8: n->n_type= I386_PCREL8; break;
	case I386_CONST16: n->n_type= I386_PCREL16; break;
	case I386_CONST32: n->n_type= I386_PCREL32; break;
	default:
		printf("pcrel: illegal type: %d\n", o->n_type);
		exit(1);
	}
	n->n_u.n_1addr= o;
	return n;
}

DEFUN
(static n386_t *two_byte, (block, size, actsize_p),
	char *block AND
	unsigned size AND 
	unsigned *actsize_p
)
{
	n386_t *n, *r, *m, *o, *c;
	u8_t byte1, byte2;
	unsigned actsize, actsize1;
	r386_t reg;
	int type, word, opc;

	if (size < 1)
		return 0;
	byte1= *block;

	switch(byte1 & 0xF0)
	{
	case 0x10:
	case 0x30:
	case 0x40:
	case 0x50:
	case 0x60:
	case 0x70:
	case 0xD0:
	case 0xE0:
	case 0xF0:
		n= n386_alloc();
		n->n_type= I386_ILLEGAL;
		*actsize_p= 1;
		return n;
	}	
	switch(byte1)
	{
	case 0x0:
		n= Grp6(block+1, size-1, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	case 0x1:
		n= Grp7(block+1, size-1, &actsize);
		if (n == 0)
			return 0;
		*actsize_p= actsize+1;
		return n;
	case 0x2:
	case 0x3:
		m= modrm_d16(block+1, size-1, &actsize);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (byte1 == 2)
			n->n_type= I386_LAR_F_2;
		else	
			n->n_type= I386_LSL_F_3;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
		*actsize_p= actsize+1;
		return n;
	case 0x4:
	case 0x5:
		break;	
	case 0x6:
		n= n386_alloc();
		n->n_type= I386_CLTS_F_6;
		*actsize_p= 1;
		return n;
	case 0x7:
		break;
#if BUG_COMPATIBILITY		
	case 0x8:
		n= n386_alloc();
		n->n_type= I486_INVD_F_8;
		*actsize_p= 1;
		return n;
	case 0x9:
		n= n386_alloc();
		n->n_type= I486_WBINVD_F_9;
		*actsize_p= 1;
		return n;
#else
	case 0x8:
	case 0x9:
		break;		
#endif		
	case 0xA:
	case 0xB:
	case 0xC:
	case 0xD:
	case 0xE:
	case 0xF:
		break;
	case 0x20:
	case 0x21:
	case 0x22:
	case 0x23:
	case 0x24:
	case 0x26:
		m= modrm_d32(block+1, size-1, &actsize);
		if (m == 0)
			return 0;
		if (m->n_type != I386_REG32)
		{
			n386_freetree(m);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			*actsize_p= actsize+1;
			return n;
		}
		switch(byte1 & ~2)
		{
		case 0x20:
			r= modcreg(block+1);
			switch(r->n_u.n_reg)
			{
			case I386_CR1:
			case I386_CR4:
			case I386_CR5:
			case I386_CR6:
			case I386_CR7:
				n386_freetree(m);
				n386_freetree(r);
				n= n386_alloc();
				n->n_type= I386_ILLEGAL;
				*actsize_p= actsize+1;
				return n;
			}
			break;
		case 0x21:
			r= moddreg(block+1);
			switch(r->n_u.n_reg)
			{
			case I386_DR4:
			case I386_DR5:
				n386_freetree(m);
				n386_freetree(r);
				n= n386_alloc();
				n->n_type= I386_ILLEGAL;
				*actsize_p= actsize+1;
				return n;
			}
			break;
		case 0x24: 
			r= modtreg(block+1); 
			switch(r->n_u.n_reg)
			{
			case I386_TR0:
			case I386_TR1:
			case I386_TR2:
#if BUG_COMPATIBLE
			case I486_TR3:
			case I486_TR4:
			case I486_TR5:
#endif		
				n386_freetree(m);
				n386_freetree(r);
				n= n386_alloc();
				n->n_type= I386_ILLEGAL;
				*actsize_p= actsize+1;
				return n;
			}
			break;
		default:
			printf("two_byte: illegal special reg opcode 0x%x\n",
				byte1);
			exit(1);
		}
		n= n386_alloc();
		n->n_type= I386_MOV_F_2x;
		if (byte1 & 2)
		{
			n->n_u.n_mov.n_dst= r;
			n->n_u.n_mov.n_src= m;
		}
		else
		{
			n->n_u.n_mov.n_dst= m;
			n->n_u.n_mov.n_src= r;
		}
		*actsize_p= actsize+1;
		return n;
	case 0x25:
	case 0x27:	
	case 0x28:	
	case 0x29:	
	case 0x2A:	
	case 0x2B:	
	case 0x2C:	
	case 0x2D:	
	case 0x2E:	
	case 0x2F:	
		break;	/* Illegal instruction */
	case 0x80:
	case 0x81:
	case 0x82:
	case 0x83:
	case 0x84:
	case 0x85:
	case 0x86:
	case 0x87:
	case 0x88:
	case 0x89:
	case 0x8A:
	case 0x8B:
	case 0x8C:
	case 0x8D:
	case 0x8E:
	case 0x8F:
		o= pcrel(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		switch(byte1)
		{
		case 0x80: type= I386_JO_F_80; break;
		case 0x81: type= I386_JNO_F_81; break;
		case 0x82: type= I386_JB_F_82; break;
		case 0x83: type= I386_JNB_F_83; break;
		case 0x84: type= I386_JZ_F_84; break;
		case 0x85: type= I386_JNZ_F_85; break;
		case 0x86: type= I386_JBE_F_86; break;
		case 0x87: type= I386_JNBE_F_87; break;
		case 0x88: type= I386_JS_F_88; break;
		case 0x89: type= I386_JNS_F_89; break;
		case 0x8A: type= I386_JP_F_8A; break;
		case 0x8B: type= I386_JNP_F_8B; break;
		case 0x8C: type= I386_JL_F_8C; break;
		case 0x8D: type= I386_JNL_F_8D; break;
		case 0x8E: type= I386_JLE_F_8E; break;
		case 0x8F: type= I386_JNLE_F_8F; break;
		default:
			printf("two_byte: illegal value for jmp 0x%x\n",	
				byte1);
			exit(1);
		}
		n= n386_alloc();
		n->n_type= type;
		n->n_u.n_1addr= o;
		*actsize_p= actsize+1;
		return n;
	case 0x90:
	case 0x91:
	case 0x92:
	case 0x93:
	case 0x94:
	case 0x95:
	case 0x96:
	case 0x97:
	case 0x98:
	case 0x99:
	case 0x9A:
	case 0x9B:
	case 0x9C:
	case 0x9D:
	case 0x9E:
	case 0x9F:
		if (size < 2)
			return 0;
		byte2= block[1];
		opc= (byte2 >> 3) & 0x7;
		if (opc != 0)
		{
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			*actsize_p= 2;
			return n;
		}
		m= modrm(block+1, size-1, &actsize, 0);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}	
		switch(byte1)
		{
		case 0x90: type= I386_SETO_F_90; break;
		case 0x91: type= I386_SETNO_F_91; break;
		case 0x92: type= I386_SETB_F_92; break;
		case 0x93: type= I386_SETNB_F_93; break;
		case 0x94: type= I386_SETZ_F_94; break;
		case 0x95: type= I386_SETNZ_F_95; break;
		case 0x96: type= I386_SETBE_F_96; break;
		case 0x97: type= I386_SETNBE_F_97; break;
		case 0x98: type= I386_SETS_F_98; break;
		case 0x99: type= I386_SETNS_F_99; break;
		case 0x9A: type= I386_SETP_F_9A; break;
		case 0x9B: type= I386_SETNP_F_9B; break;
		case 0x9C: type= I386_SETL_F_9C; break;
		case 0x9D: type= I386_SETNL_F_9D; break;
		case 0x9E: type= I386_SETLE_F_9E; break;
		case 0x9F: type= I386_SETNLE_F_9F; break;
		default:
			printf("two_byte: illegal value for set 0x%x\n",	
				byte1);
			exit(1);
		}
		n= n386_alloc();
		n->n_type= type;
		n->n_u.n_1addr= m;
		*actsize_p= actsize+1;
		return n;
	case 0xA0:
	case 0xA1:
	case 0xA8:
	case 0xA9:
		if (byte1 & 8)
			reg= I386_GS;
		else
			reg= I386_FS;
		if (byte1 & 1)
			type= I386_POP;
		else
			type= I386_PUSH;
		r= i386_make_segment(reg);
		n= n386_alloc();
		n->n_type= type;
		n->n_u.n_1addr= r;
		*actsize_p= 1;
		return n;
	case 0xA2:
		break;	
	case 0xA3:
	case 0xAB:
	case 0xB3:
	case 0xBB:	
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		switch(byte1)
		{
		case 0xA3: n->n_type= I386_BT_F_A3; break;
		case 0xAB: n->n_type= I386_BTS_F_AB; break;
		case 0xB3: n->n_type= I386_BTR_F_B3; break;
		case 0xBB: n->n_type= I386_BTC_F_BB; break;
		default:
			printf("two_byte: illegal BTx opcode: 0x%x\n", byte1);
			exit(1);
		}
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
		*actsize_p= actsize+1;
		return n;
	case 0xA4:	
	case 0xA5:	
	case 0xAC:
	case 0xAD:
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		if (byte1 & 1)
		{
			o= i386_make_register(I386_CL);	
			actsize1= 0;
		}	
		else
		{
			o= i386_const_i8(block+1+actsize, size-1-actsize, 
								&actsize1);	
			if (o == 0)
			{
				n386_freetree(m);
				return 0;
			}
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (byte1 & 8)
			n->n_type= I386_SHRD_F_Ax;
		else	
			n->n_type= I386_SHLD_F_Ax;
		n->n_u.n_3addr.n_first= m;					
		n->n_u.n_3addr.n_second= r;					
		n->n_u.n_3addr.n_third= o;					
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xA6:
	case 0xA7:
		if (byte1 & 1)
			word= 1;
		else
			word= 0;
		m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, word);	
		n= n386_alloc();
#if BUG_COMPATIBLE
		n386_freetree(m);
		n386_freetree(r);
		n->n_type= I386_ILLEGAL;
#else		
		n->n_type= I486_CMPXCHG_F_Ax;
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
#endif		
		*actsize_p= actsize+1;
		return n;
	case 0xAA:
		break;	/* illegal instruction */
	case 0xAE:
		break;	/* illegal instruction */
	case 0xAF:
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}	
		r= modreg(block+1, 1);
		n =n386_alloc();
		n->n_type= I386_IMUL_F_AF;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
		*actsize_p= actsize+1;
		return n;
	case 0xB0:
	case 0xB1:
		break;	/* illegal instruction */	
	case 0xB2:
	case 0xB4:
	case 0xB5:
		o= modrm(block+1, size-1, &actsize, 1);
		if (o == 0)
			return 0;
		*actsize_p= actsize+1;
		if (o->n_type == I386_ILLEGAL)
			return o;
		if (o->n_type == I386_ADDRESS32)
			o->n_type= I386_ADDRESS_FAR32;
		else if (o->n_type == I386_ADDRESS16)
			o->n_type= I386_ADDRESS_FAR16;
		else
		{
			n386_freetree(o);
			n= n386_alloc();
			n->n_type= I386_ILLEGAL;
			return n;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		switch(byte1)
		{
		case 0xB2: n->n_type= I386_LSS_F_B2; break;
		case 0xB4: n->n_type= I386_LFS_F_B4; break;
		case 0xB5: n->n_type= I386_LGS_F_B5; break;
		default:
			printf("two_byte: illegal LxS opcode: 0x%x\n", byte1);
			exit(1);
		}
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= o;
		return n;
	case 0xB6:
	case 0xB7:
	case 0xBE:
	case 0xBF:
		if (size < 2)
			return 0;
		if (byte1& 1)
			word= 1;
		else	
			word= 0;
		if (word)
			m= modrm_d16(block+1, size-1, &actsize);
		else
			m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}	
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (byte1 & 8)
			n->n_type= I386_MOVSX_F_Bx;
		else
			n->n_type= I386_MOVZX_F_Bx;
		n->n_u.n_mov.n_dst= r;
		n->n_u.n_mov.n_src= m;
		*actsize_p= actsize+1;
		return n;
	case 0xB8:
	case 0xB9:
		break;	/* illegal instruction */
	case 0xBA:
		n= Grp8(block+1, size-1, &actsize);	
		if (n == 0)
			return 0;
		if (n->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return n;
		}
		c= i386_const_i8(block+1+actsize, size-1-actsize, &actsize1);
		if (c == 0)
		{
			n->n_u.n_2addr.n_second= 0;
			n386_freetree(n);
			return 0;
		}
		n->n_u.n_2addr.n_second= c;
		*actsize_p= actsize+actsize1+1;
		return n;
	case 0xBC:
	case 0xBD:
		m= modrm(block+1, size-1, &actsize, 1);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, 1);
		n= n386_alloc();
		if (byte1 == 0xBC)
			n->n_type= I386_BSF_F_BC;
		else	
			n->n_type= I386_BSR_F_BD;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
		*actsize_p= actsize+1;
		return n;
	case 0xC0:
	case 0xC1:
		if (byte1 & 1)
			word= 1;
		else
			word= 0;
		m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, word);
		n= n386_alloc();
		n->n_type= I486_XADD_F_Cx;
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
		*actsize_p= actsize+1;
		return n;
	case 0xC2:	
	case 0xC3:	
	case 0xC4:	
	case 0xC5:	
	case 0xC6:	
	case 0xC7:	
		break;	/* illegal instruction */
	case 0xC8:	
	case 0xC9:	
	case 0xCA:	
	case 0xCB:	
	case 0xCC:	
	case 0xCD:	
	case 0xCE:	
	case 0xCF:	
		r= i386_reg32_node(byte1 & 0x7);
		n= n386_alloc();
		n->n_type= I486_BSWAP_F_Cx;
		n->n_u.n_1addr= r;
		*actsize_p= 1;
		return n;
	default:
		printf("two_byte: illegal opcode 0x%x\n", byte1);
		exit(1);
	}
	n= n386_alloc();
	n->n_type= I386_ILLEGAL;
	*actsize_p= 1;
	return n;
}

DEFUN
(static n386_t *binop, (opcode, block, size, actsize_p), 
	int opcode AND
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)	
{
	u8_t byte0;
	n386_t *r, *m, *n;
	int reg_first, word;
	unsigned actsize;
	
	if (size < 1)
		return 0;
	byte0= block[0];
	if (byte0 & 1)
		word= 1;
	else
		word= 0;
	if ((byte0 & 0x6) == 4)
	{
		m= i386_data_const(block+1, size-1, &actsize, word);
		if (m == 0)
			return 0;
		r= i386_data_reg_node(0, word);
		reg_first= 1;
	}
	else
	{
		if (size < 2)
			return 0;
		m= modrm(block+1, size-1, &actsize, word);
		if (m == 0)
		{
			return 0;
		}
		if (m->n_type == I386_ILLEGAL)
		{
			*actsize_p= actsize+1;
			return m;
		}
		r= modreg(block+1, word);
		if (byte0 & 2)
			reg_first= 1;
		else
			reg_first= 0;
	}
	n= n386_alloc();
	n->n_type= opcode;
	if (reg_first)
	{
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= m;
	}
	else
	{
		n->n_u.n_2addr.n_first= m;
		n->n_u.n_2addr.n_second= r;
	}
	*actsize_p= actsize+1;
	return n;
}

DEFUN
(static n386_t *f_reg, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte0, byte1;
	int opc, reg, type;
	n386_t *n, *r, *r1;

	byte0= block[0];
	byte1= block[1];
	
	opc= ((byte0 & 0x7) << 3) | ((byte1 >> 3) & 0x7);
	reg= byte1 & 0x7;
	*actsize_p= 2;
	switch(opc)
	{
	case 0x00:
	case 0x20:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FADD_Dx;
		if (opc == 0x00)
		{
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}
		else
		{	
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}	
		return n;
	case 0x01:	
	case 0x21:	
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FMUL_Dx;
		if (opc == 0x01)
		{	
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}	
		else
		{	
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}	
		return n;
	case 0x02:	
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FCOM_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x03:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FCOMP_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x04:	
	case 0x25:	
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FSUB_Dx;
		if (opc == 0x04)
		{
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}	
		else
		{
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}	
		return n;
	case 0x05:	
	case 0x24:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FSUBR_Dx;
		if (opc == 0x05)
		{
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}	
		else
		{
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}	
		return n;
	case 0x06:	
	case 0x27:	
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FDIV_Dx;
		if (opc == 0x06)
		{
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}	
		else
		{
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}	
		return n;
	case 0x07:	
	case 0x26:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FDIVR_Dx;
		if (opc == 0x07)
		{
			n->n_u.n_2addr.n_first= r1;
			n->n_u.n_2addr.n_second= r;
		}
		else
		{
			n->n_u.n_2addr.n_first= r;
			n->n_u.n_2addr.n_second= r1;
		}
		return n;
	case 0x08:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FLD_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x09:	
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FXCH_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x0A:
		if (reg == 0)
		{
			n= n386_alloc();
			n->n_type= I386_FNOP_D9_D0;
			return n;
		}
		break;
	case 0x0B:	
		break;
	case 0x0C:
		type= I386_ILLEGAL;
		switch(reg)
		{
		case 0: type= I386_FCHS_D9_E0; break;
		case 1: type= I386_FABS_D9_E1; break;
		case 4: type= I386_FTST_D9_E4; break;
		case 5: type= I386_FXAM_D9_E5; break;
		}
		if (type == I386_ILLEGAL)
			break;
		n= n386_alloc();
		n->n_type= type;
		return n;
	case 0x0D:
		type= I386_ILLEGAL;
		switch(reg)
		{
		case 0: type= I386_FLD1_D9_E8; break;
		case 1: type= I386_FLDL2T_D9_E9; break;
		case 2: type= I386_FLDL2E_D9_EA; break;
		case 3: type= I386_FLDPI_D9_EB; break;
		case 4: type= I386_FLDLG2_D9_EC; break;
		case 5: type= I386_FLDLN2_D9_ED; break;
		case 6: type= I386_FLDZ_D9_EE; break;
		}
		if (type == I386_ILLEGAL)
			break;
		n= n386_alloc();
		n->n_type= type;
		return n;
	case 0x0E:
		type= I386_ILLEGAL;
		switch(reg)
		{
		case 0: type= I386_F2XM1_D9_F0; break;
		case 1: type= I386_FYL2X_D9_F1; break;
		case 2: type= I386_FPTAN_D9_F2; break;
		case 3: type= I386_FPATAN_D9_F3; break;
		case 4: type= I386_FXTRACT_D9_F4; break;
#if BUG_COMPATIBLE
		case 5: break;
#else		
		case 5: type= I386_FPREM1_D9_F5; break;
#endif		
		case 6: type= I386_FDECSTP_D9_F6; break;
		case 7: type= I386_FINCSTP_D9_F7; break;
		}
		if (type == I386_ILLEGAL)
			break;
		n= n386_alloc();
		n->n_type= type;
		return n;
	case 0x0F:
		type= I386_ILLEGAL;
		switch(reg)
		{
		case 0: type= I386_FPREM_D9_F8; break;
#if BUG_COMPATIBLE
		case 1: break;
#else		
		case 1: type= I386_FYL2XP1_D9_F9; break;
#endif		
		case 2: type= I386_FSQRT_D9_FA; break;
		case 3: type= I386_FSINCOS_D9_FB; break;
		case 4: type= I386_FRNDINT_D9_FC; break;
		case 5: type= I386_FSCALE_D9_FD; break;
		case 6: type= I386_FSIN_D9_FE; break;
		case 7: type= I386_FCOS_D9_FF; break;
		}
		if (type == I386_ILLEGAL)
			break;
		n= n386_alloc();
		n->n_type= type;
		return n;
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
		break;
#if BUG_COMPATIBLE
	case 0x15:
		break;
#else		
	case 0x15:
		if (reg == 1)
		{
			n= n386_alloc();
			n->n_type= I386_FUCOMPP_DA_E9;
			return n;
		}
		break;
#endif /* BUG_COMPATIBLE */		
	case 0x16:
	case 0x17:
	case 0x18:
	case 0x19:
	case 0x1A:
	case 0x1B:
		break;
	case 0x1C:
		if (reg == 2)
		{
			n= n386_alloc();
			n->n_type= I386_FCLEX_DB_E2;
			return n;
		}
		else if (reg == 3)
		{
			n= n386_alloc();
			n->n_type= I386_FINIT_DB_E3;
			return n;
		}
		break;
	case 0x1D:
	case 0x1E:
	case 0x1F:
		break;
	case 0x22:
	case 0x23:
		break;
	case 0x28:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FFREE_DD_0;
		n->n_u.n_1addr= r;
		return n;
	case 0x29:
		break;	
	case 0x2A:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FST_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x2B:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FSTP_Dx;
		n->n_u.n_1addr= r;
		return n;
#if BUG_COMPATIBLE
	case 0x2C:
	case 0x2D:
		break;
#else		
	case 0x2C:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FUCOM_DD_4;
		n->n_u.n_1addr= r;
		return n;
	case 0x2D:
		r= f_reg_node(reg);
		n= n386_alloc();
		n->n_type= I386_FUCOMP_DD_5;
		n->n_u.n_1addr= r;
		return n;
#endif /* BUG_COMPATIBLE */		
	case 0x2E:
	case 0x2F:
		break;	
	case 0x30:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FADDP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x31:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FMULP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x32:
		break;
	case 0x33:
		if (reg != 1)
			break;
		n= n386_alloc();
		n->n_type= I386_FCOMPP_DE_D9;
		return n;	
	case 0x34:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FSUBRP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x35:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FSUBP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x36:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FDIVRP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x37:
		r= f_reg_node(reg);
		r1= n386_alloc();
		r1->n_type= I386_REG_ST0;
		n= n386_alloc();
		n->n_type= I386_FDIVP_Dx;
		n->n_u.n_2addr.n_first= r;
		n->n_u.n_2addr.n_second= r1;
		return n;
	case 0x38:
	case 0x39:
	case 0x3A:
	case 0x3B:
		break;
	case 0x3C:
		if (reg != 0)
			break;
		r= i386_make_register(I386_EAX);
		n= n386_alloc();
		n->n_type= I386_FSTSW_Dx;
		n->n_u.n_1addr= r;
		return n;
	case 0x3D:
	case 0x3E:
	case 0x3F:
		break;
	default:
		printf("f_reg: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	n= n386_alloc();
	n->n_type= I386_ILLEGAL;
	return n;
}	

DEFUN
(static n386_t *f_modrm, (block, size, actsize_p),
	char *block AND
	unsigned size AND
	unsigned *actsize_p
)
{
	u8_t byte0, byte1;
	int opc, reg;
	n386_t *n, *r, *r1, *o;
	unsigned actsize;

	byte0= block[0];
	byte1= block[1];
	
	opc= ((byte0 & 0x7) << 3) | ((byte1 >> 3) & 0x7);
	o= modrm(block+1, size-1, &actsize, 0);
	if (o == 0)
		return 0;
	*actsize_p= actsize+1;
	if (o->n_type == I386_ILLEGAL)
		return o;
		
	switch(opc)
	{
	case 0x00:
	case 0x20:
		n= n386_alloc();
		n->n_type= I386_FADD_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x00)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x01:	
	case 0x21:
		n= n386_alloc();
		n->n_type= I386_FMUL_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x01)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x02:
	case 0x22:
		n= n386_alloc();
		n->n_type= I386_FCOM_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x02)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x03:	
	case 0x23:
		n= n386_alloc();
		n->n_type= I386_FCOMP_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x03)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x04:	
	case 0x24:
		n= n386_alloc();
		n->n_type= I386_FSUB_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x04)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x05:	
	case 0x25:
		n= n386_alloc();
		n->n_type= I386_FSUBR_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x05)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x06:	
	case 0x26:
		n= n386_alloc();
		n->n_type= I386_FDIV_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x06)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x07:	
	case 0x27:
		n= n386_alloc();
		n->n_type= I386_FDIVR_Dx;
		n->n_u.n_2addr.n_first= o;
		n->n_u.n_2addr.n_second= NULL;
		if (opc == 0x07)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x08:
	case 0x1D:	
	case 0x28:	
		n= n386_alloc();
		n->n_type= I386_FLD_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x08)
			o->n_type= I386_ADDRESS32;
		else if (opc == 0x1D)
			o->n_type= I386_ADDRESS80;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x09:
		break;	
	case 0x0A:	
		n= n386_alloc();
		n->n_type= I386_FST_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x0A)
			o->n_type= I386_ADDRESS32;
		else 
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x0B:
	case 0x1F:	
	case 0x2B:
		n= n386_alloc();
		n->n_type= I386_FSTP_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x0B)
			o->n_type= I386_ADDRESS32;
		else if (opc == 0x1F)
			o->n_type= I386_ADDRESS80;
		else	
			o->n_type= I386_ADDRESS64;
		return n;
	case 0x0C:	
	case 0x0E:
		n= n386_alloc();
		if (opc == 0x0C)
			n->n_type= I386_LDENV_D9_4;
		else	
			n->n_type= I386_STENV_D9_6;
		n->n_u.n_1addr= o;
		if ((i386_data_32 ^ i386_opsize_prefix) == 0) 
			o->n_type= I386_ADDRESS14B;
		else	
			o->n_type= I386_ADDRESS28B;
		return n;
	case 0x0D:	
	case 0x0F:
		n= n386_alloc();
		if (opc == 0x0D)
			n->n_type= I386_FLDCW_D9_5;
		else	
			n->n_type= I386_FSTCW_D9_7;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS16;
		return n;
	case 0x10:
	case 0x30:
		n= n386_alloc();
		n->n_type= I386_FIADD_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x10)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x11:	
	case 0x31:
		n= n386_alloc();
		n->n_type= I386_FIMUL_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x11)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x12:	
	case 0x32:
		n= n386_alloc();
		n->n_type= I386_FICOM_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x12)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x13:	
	case 0x33:
		n= n386_alloc();
		n->n_type= I386_FICOMP_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x13)
			o->n_type= I386_ADDRESS32;
		else
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x14:	
	case 0x34:
		n= n386_alloc();
		n->n_type= I386_FISUB_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x14)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x15:	
	case 0x35:
		n= n386_alloc();
		n->n_type= I386_FISUBR_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x15)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x16:	
	case 0x36:
		n= n386_alloc();
		n->n_type= I386_FIDIV_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x16)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x17:	
	case 0x37:
		n= n386_alloc();
		n->n_type= I386_FIDIVR_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x17)
			o->n_type= I386_ADDRESS32;
		else	
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x18:
	case 0x38:
		n= n386_alloc();
		n->n_type= I386_FILD_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x18)
			o->n_type= I386_ADDRESS32;
		else
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x19:
		break;
	case 0x1A:	
	case 0x3A:	
		n= n386_alloc();
		n->n_type= I386_FIST_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x1A)
			o->n_type= I386_ADDRESS32;
		else
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x1B:	
	case 0x3B:
		n= n386_alloc();
		n->n_type= I386_FISTP_Dx;
		n->n_u.n_1addr= o;
		if (opc == 0x1B)
			o->n_type= I386_ADDRESS32;
		else
			o->n_type= I386_ADDRESS16;
		return n;
	case 0x1C:
	case 0x2E:
		n= n386_alloc();
		if (opc == 0x1C)
			n->n_type= I386_FRSTOR_DB_4;
		else	
			n->n_type= I386_FSAVE_DD_6;
		n->n_u.n_1addr= o;
		if ((i386_data_32 ^ i386_opsize_prefix) == 0) 
			o->n_type= I386_ADDRESS94B;
		else	
			o->n_type= I386_ADDRESS108B;
		return n;
	case 0x1E:
		break;	
	case 0x29:
		break;
	case 0x2C:
	case 0x2D:
		break;	
#if BUG_COMPATIBLE		
	case 0x2F:
		break;
#else
	case 0x2F:
		n= n386_alloc();
		n->n_type= I386_FSTSW_Dx;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS16;
		return n;
#endif /* BUG_COMPATIBLE */		
	case 0x39:
		break;
	case 0x3C:
		n= n386_alloc();
		n->n_type= I386_FBLD_DF_4;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS80;
		return n;
	case 0x3D:
		n= n386_alloc();
		n->n_type= I386_FILD_Dx;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS64;
		return n;
	case 0x3E:
		n= n386_alloc();
		n->n_type= I386_FBSTP_DF_6;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS80;
		return n;
	case 0x3F:
		n= n386_alloc();
		n->n_type= I386_FISTP_Dx;
		n->n_u.n_1addr= o;
		o->n_type= I386_ADDRESS64;
		return n;
	default:
		printf("f_modrm: illegal opc: 0x%x\n", opc);
		exit(1);
	}
	n386_freetree(o);
	n= n386_alloc();
	n->n_type= I386_ILLEGAL;
	return n;
}	
