/* This file header doesn't contain the usual boilerplate. */

#include "mm.h"
#include <sys/ptrace.h>
#include <signal.h>
#include "mproc.h"
#include "param.h"
#include "assert.h"
INIT_ASSERT

#define NIL_MPROC	((struct mproc *) 0)

/*===========================================================================*
 *				do_trace  				     *
 *===========================================================================*/
PUBLIC int do_trace()
{
  register struct mproc *child;
  long data;
  int r;

  assert(mm_call == PTRACE);

  if (trace_request == T_OK) {	/* enable tracing by parent for this process */
	mp->mp_flags |= TRACED;
	mm_out.m2_l2 = 0;
	return(OK);
  }
  if ((child = find_proc(trace_pid)) == NIL_MPROC ||
  	!(child->mp_flags & STOPPED)) {
	if (child == NULL)
		printf("mm, do_trace: process %d not found\n", trace_pid);
	else
		printf("mm, do_trace: process is not stopped\n");

	return(ESRCH);
  }
  if (trace_request == T_EXIT) {	/* exit */
	mm_exit(child, trace_data);
	mm_out.m2_l2 = 0;
	return(OK);
  }

  if (trace_request == T_RESUME || trace_request == T_STEP) {
  	/* resume execution */
	if (trace_data < 0 || trace_data > _NSIG) return(EIO);
	if (trace_data > 0) {		/* issue signal */
		child->mp_flags &= ~TRACED;  /* so signal is not diverted */
		sig_proc(child, (int) trace_data);
		child->mp_flags |= TRACED;
	}
	child->mp_flags &= ~STOPPED;
  }

  if ((r= sys_trace(trace_request, (int) (child - mproc), trace_addr,
  	&data)) != OK)
  {
	printf("mm, do_trace: sys_trace(%d, %d, 0x%lx, 0x%lx): %d\n",
		trace_request, (int)(child-mproc), (long)trace_addr,
		(long)&data, r);
	return(r);
  }	
  mm_out.m2_l2 = data;

  if (trace_request == T_SYS) {	/* resume execution */
	if (trace_data < 0 || trace_data > _NSIG) return(EIO);
	if (trace_data > 0) {		/* issue signal */
		child->mp_flags &= ~TRACED;  /* so signal is not diverted */

 { where(); printf("stopping proc #%d with signal %d\n",
 	child-mproc, trace_data); }

		sig_proc(child, (int) trace_data);
		child->mp_flags |= TRACED;
	}
	child->mp_flags &= ~STOPPED;
  }
  return(OK);
}

/*===========================================================================*
 *				stop_proc  				     *
 *===========================================================================*/
PUBLIC void stop_proc(rmp, signo)
register struct mproc *rmp;
int signo;
{
/* A traced process got a signal so stop it. */

  register struct mproc *rpmp = mproc + rmp->mp_parent;

  if (sys_trace(-1, (int) (rmp - mproc), 0L, (long *) 0) != OK) return;
  rmp->mp_flags |= STOPPED;
  if (rpmp->mp_flags & WAITING) {
	rpmp->mp_flags &= ~WAITING;	/* parent is no longer waiting */
	reply(rmp->mp_parent, rmp->mp_pid, 0177 | (signo << 8), NIL_PTR);
  } else {
	rmp->mp_sigstatus = signo;
  }
  return;
}

/*
 * $PchId: trace.c,v 1.4 1995/11/28 06:59:32 philip Exp $
 */
