/* Function prototypes. */

struct mproc;		/* need types outside of parameter list --kub */
struct stat;

/* alloc.c */
_PROTOTYPE( phys_clicks alloc_mem, (phys_clicks clicks)			);
_PROTOTYPE( void free_mem, (phys_clicks base, phys_clicks clicks)	);
_PROTOTYPE( phys_clicks max_hole, (void)				);
_PROTOTYPE( void mem_init, (void)					);
_PROTOTYPE( phys_clicks mem_left, (void)				);
_PROTOTYPE( int do_brk3, (void)						);
#if PCH_DEBUG
_PROTOTYPE( void print_mem, (void)					);
#endif /* PCH_DEBUG */

/* break.c */
_PROTOTYPE( int adjust_data, (struct mproc *rmp, vir_bytes break_ptr)	);
_PROTOTYPE( int adjust_stack, (struct mproc *rmp, vir_bytes stack_ptr)	);
_PROTOTYPE( int do_brk, (void)						);
#if (CHIP == INTEL) && VIRT_MEM
/* size_ok is not used */
#else /* !(CHIP == INTEL && VIRT_MEM) */
_PROTOTYPE( int size_ok, (int file_type, vir_clicks tc, vir_clicks dc,
			vir_clicks sc, vir_clicks dvir, vir_clicks s_vir) );
#endif /* INTEL && VIRT_MEM */

#if VMDEXT_SYSCALL
/* compat.c */
_PROTOTYPE( int do_cpt_waitpid, (void)					);
_PROTOTYPE( int do_cpt_setsid, (void)					);
_PROTOTYPE( int do_cpt_getpgrp, (void)					);
_PROTOTYPE( int do_cpt_sigaction, (void)				);
_PROTOTYPE( int do_cpt_sigsuspend, (void)				);
_PROTOTYPE( int do_cpt_sigpending, (void)				);
_PROTOTYPE( int do_cpt_sigprocmask, (void)				);
_PROTOTYPE( int do_cpt_sigreturn, (void)				);
_PROTOTYPE( int do_cpt_reboot, (void)					);
#endif /* VMDEXT_SYSCALL */

/* exec.c */
_PROTOTYPE( int do_exec, (void)						);
_PROTOTYPE( void ec_adjust_usage, (void)				);
_PROTOTYPE( void ec_free_pslot, (void)					);

/* forkexit.c */
_PROTOTYPE( int do_fork, (void)						);
_PROTOTYPE( int do_mm_exit, (void)					);
_PROTOTYPE( int do_waitpid, (void)					);
_PROTOTYPE( void mm_exit, (struct mproc *rmp, int exit_status)		);

/* getset.c */
_PROTOTYPE( int do_getset, (void)					);
#if VMDEXT_TTY_SESSION
_PROTOTYPE( int do_setsid, (void)					);
_PROTOTYPE( int do_getpgrp, (void)					);
#endif /* VMDEXT_TTY_SESSION */

/* main.c */
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( int get_mem, (phys_clicks *base, phys_clicks *size)		);

#if (MACHINE == MACINTOSH)
_PROTOTYPE( phys_clicks start_click, (void)				);
#endif

_PROTOTYPE( void reply, (int proc_nr, int result, int res2, char *respt));

/* misc.c */
_PROTOTYPE( int do_nice, (void)						);
_PROTOTYPE( int do_reboot, (void)					);
_PROTOTYPE( int do_sysenv, (void)					);
#if PAGING_VM
_PROTOTYPE( int do_swapoff, (void)					);
#endif /* PAGING_VM */
_PROTOTYPE( int do_svrctl, (void)					);

/* putk.c */
_PROTOTYPE( void putk, (int c)						);

/* signal.c */
_PROTOTYPE( int do_alarm, (void)					);
_PROTOTYPE( int do_kill, (void)						);
_PROTOTYPE( int do_ksig, (void)						);
_PROTOTYPE( int do_pause, (void)					);
_PROTOTYPE( int do_signal, (void)					);
_PROTOTYPE( int set_alarm, (int proc_nr, int sec)			);
_PROTOTYPE( void sig_proc, (struct mproc *rmp, int sig_nr)		);
_PROTOTYPE( int do_sigaction, (void)					);
_PROTOTYPE( int do_sigpending, (void)					);
_PROTOTYPE( int do_sigprocmask, (void)					);
_PROTOTYPE( int do_sigreturn, (void)					);
_PROTOTYPE( int do_sigsuspend, (void)					);

/* trace.c */
_PROTOTYPE( int do_trace, (void)					);
_PROTOTYPE( void stop_proc, (struct mproc *rmp, int sig_nr)		);

/* utility.c */
_PROTOTYPE( int allowed, (char *name_buf, struct stat *s_buf, int mask)	);
_PROTOTYPE( struct mproc * find_proc, (int pid)				);
_PROTOTYPE( int no_sys, (void)						);
_PROTOTYPE( void panic, (char *format, int num)				);
_PROTOTYPE( time_t get_time, (void)					);
_PROTOTYPE( void tell_fs, (int what, int p1, int p2, int p3)		);


/*
 * $PchId: proto.h,v 1.4 1995/11/28 07:05:55 philip Exp $
 */
