/* EXTERN should be extern except in table.c */
#ifdef _TABLE
#undef EXTERN
#define EXTERN
#endif

/* Global variables. */
EXTERN struct mproc *mp;	/* ptr to 'mproc' slot of current process */
EXTERN int dont_reply;		/* normally 0; set to 1 to inhibit reply */
EXTERN struct mproc *mproc_exec; /* temporary address space for exec */
EXTERN phys_bytes ec_limit;	/* exec cache limit */
EXTERN phys_bytes ec_usage;	/* exec cache usage */

/* Lists of processes */
EXTERN struct mproc *mproc_freelist;	/* Empty process slots */
EXTERN struct mproc *mproc_deadlist;	/* Dead processes waiting for their
					 * parents
					 */
EXTERN struct mproc *mproc_syslist;	/* System processes and init */
EXTERN struct mproc *mproc_eclist;	/* Executable cache processes */
EXTERN struct mproc *mproc_inuse;	/* Normal user processes */

/* The parameters of the call are kept here. */
EXTERN message mm_in;		/* the incoming message itself is kept here. */
EXTERN message mm_out;		/* the reply message is built up here. */
EXTERN int who;			/* caller's proc number */
EXTERN int mm_call;		/* system call number */

/* The following variables are used for returning results to the caller. */
EXTERN int err_code;		/* temporary storage for error number */
EXTERN int result2;		/* secondary result */
EXTERN char *res_ptr;		/* result, if pointer */

#if VMDEXT_SYSCALL
extern _PROTOTYPE (int (*scall_table[]), (void) ); /* system call handlers */
#else /* !VMDEXT_SYSCALL */
extern _PROTOTYPE (int (*call_vec[]), (void) );	/* system call handlers */
#endif /* VMDEXT_SYSCALL */
extern char core_name[];	/* file name where core images are produced */
EXTERN sigset_t core_bits;	/* which signals cause core images */
#if VMDEXT_MM_SIGNAL
EXTERN sigset_t default_ignore;	/* signals which are ignored if not caught */
#endif /* VMDEXT_MM_SIGNAL */
extern clck_tasknr;
extern synal_tasknr;

/*
 * $PchId: glo.h,v 1.3 1995/11/28 07:14:03 philip Exp $
 */
