/* General constants used by the kernel. */

#ifndef CHIP
#include <CHIP is not defined>
#endif
#if (CHIP) == 0
#include <CHIP has an illegal value>
#endif

#if (CHIP == INTEL)

#if VIRT_MEM
#define K_STACK_BYTES	10240
#else /* !VIRT_MEM */
#define K_STACK_BYTES    1024	/* how many bytes for the kernel stack */
#endif /* VIRT_MEM */

#define INIT_PSW      0x0200	/* initial psw */
#define INIT_TASK_PSW 0x1200	/* initial psw for tasks (with IOPL 1) */
#define TRACEBIT       0x100	/* OR this with psw in proc[] for tracing */
#define SETPSW(rp, new)	/* permits only certain bits to be set */ \
	((rp)->p_reg.sf_psw = ((rp)->p_reg.sf_psw & ~0xCD5) | ((new) & 0xCD5))

#define HCLICK_SHIFT       4	/* log2 of HCLICK_SIZE */
#define HCLICK_SIZE       16	/* hardware segment conversion magic */
#if CLICK_SIZE >= HCLICK_SIZE
#define click_to_hclick(n) ((n) << (CLICK_SHIFT - HCLICK_SHIFT))
#else
#define click_to_hclick(n) ((n) >> (HCLICK_SHIFT - CLICK_SHIFT))
#endif
#define hclick_to_physb(n) ((phys_bytes) (n) << HCLICK_SHIFT)
#define physb_to_hclick(n) ((n) >> HCLICK_SHIFT)

/* Interrupt vectors defined/reserved by processor. */
#define DIVIDE_VECTOR      0	/* divide error */
#define DEBUG_VECTOR       1	/* single step (trace) */
#define NMI_VECTOR         2	/* non-maskable interrupt */
#define BREAKPOINT_VECTOR  3	/* software breakpoint */
#define OVERFLOW_VECTOR    4	/* from INTO */

/* Fixed system call vector. */
#define SYS_VECTOR        32	/* system calls are made with int SYSVEC */
#define SYS386_VECTOR     33	/* except 386 system calls use this */
#define LEVEL0_VECTOR     34	/* for execution of a function at level 0 */

/* Suitable irq bases for hardware interrupts.  Reprogram the 8259(s) from
 * the PC BIOS defaults since the BIOS doesn't respect all the processor's
 * reserved vectors (0 to 31).
 */
#define BIOS_IRQ0_VEC   0x08	/* base of IRQ0-7 vectors used by BIOS */
#define BIOS_IRQ8_VEC   0x70	/* base of IRQ8-15 vectors used by BIOS */
#define IRQ0_VECTOR     0x50	/* popular vector to relocate the IRQ's */
#define IRQ8_VECTOR     0x58

/* Hardware interrupt numbers. */
#define NR_IRQ_VECTORS	  16
#define CLOCK_IRQ          0
#define KEYBOARD_IRQ       1
#define CASCADE_IRQ        2	/* cascade enable for 2nd AT controller */
#define FLOPPY_IRQ         6	/* floppy disk */
#define PRINTER_IRQ        7
#define REALTIME_IRQ	   8	/* timer channel on the real time clock. */
#define KBD_AUX_IRQ	  12	/* keyboard aux interrupt (PS/2 mouse) */
#define FPU_EX_IRQ	  13	/* floating point exception */
#define AT_WINI_IRQ       14	/* at winchester */

/* Interrupt number to hardware vector. */
#define BIOS_VECTOR(irq)	\
	(((irq) < 8 ? BIOS_IRQ0_VEC : BIOS_IRQ8_VEC) + ((irq) & 0x07))
#define VECTOR(irq)	\
	(((irq) < 8 ? IRQ0_VECTOR : IRQ8_VECTOR) + ((irq) & 0x07))

/* BIOS hard disk parameter vectors. */
#define WINI_0_PARM_VEC 0x41
#define WINI_1_PARM_VEC 0x46

/* 8259A interrupt controller ports. */
#define INT_CTL         0x20	/* I/O port for interrupt controller */
#define INT_CTLMASK     0x21	/* setting bits in this port disables ints */
#define INT2_CTL        0xA0	/* I/O port for second interrupt controller */
#define INT2_CTLMASK    0xA1	/* setting bits in this port disables ints */

/* Magic numbers for interrupt controller. */
#define ENABLE          0x20	/* code used to re-enable after an interrupt */

/* Memory tables. */
#define CHUNK_NR	16	/* number of chunks of memory */

/* Miscellaneous ports. */
#define PCR		0x65	/* Planar Control Register */
#define PORT_B          0x61	/* I/O port for 8255 port B (kbd, beeper...) */
#define TIMER0          0x40	/* I/O port for timer channel 0 */
#define TIMER2          0x42	/* I/O port for timer channel 2 */
#define TIMER_CTRL      0x43	/* I/O port for timer mode control */

#endif /* (CHIP == INTEL) */

#if (CHIP == M68000)

#define K_STACK_BYTES   1024	/* how many bytes for the kernel stack */

/* Sizes of memory tables. */
#define NR_MEMS            2	/* number of chunks of memory */

/* p_reg contains: d0-d7, a0-a6,   in that order. */
#define NR_REGS           15	/* number of general regs in each proc slot */
 
#define TRACEBIT      0x8000	/* or this with psw in proc[] for tracing */
#define SETPSW(rp, new)		/* permits only certain bits to be set */ \
	((rp)->p_reg.psw = (rp)->p_reg.psw & ~0xFF | (new) & 0xFF)
 
#define MEM_BYTES  0xffffffff	/* memory size for /dev/mem */
 
#if _VMD_EXT
/* XXX - this __ACK__ is for some M68000 compiler inadequacy and is unrelated 
 * to the _ACK used to distinguish the 386 ACK compiler.
 */
#endif /* _VMD_EXT */
#ifdef __ACK__
#define FSTRUCOPY
#endif

#endif /* (CHIP == M68000) */

#if NEW_SCHED
#define MAX_SCHEDULE_ROUND	255	/* When MAX_SCHEDULE_ROUND is reached
					 * all values related to schedule
					 * rounds are divided by 2.
					 */
#endif /* NEW_SCHED */

#if LOADAV
/* Indices in the loadav array */
#define LDAV_CURR	0		/* run queue lenght at this moment */
#define LDAV_6		1		/* av. run q len over 64 ticks (~ 1s) */
#define LDAV_12 	2		/* av. run q len over 4096 ticks */
#define LDAV_16		3		/* av. run q len over 65536 ticks */
#define LDAV_TOT	4		/* cummulative run q lenght */
#define LDAV_NR		5		/* size of the loadav array */
#define LDAV_SCALE_SHFT	8		/* values are scaled by 256 */
#endif /* LOADAV */

/* Env_parse() return values. */
#define EP_UNSET	0		/* variable not set */
#define EP_OFF		1		/* var = off */
#define EP_ON		2		/* var = on (or field left blank) */
#define EP_SET		3		/* var = 1:2:3 (nonblank field) */

/* To translate an address in kernel space to a physical address.  This is
 * the same as umap(proc_ptr, SEG_D, vir, sizeof(*vir)), but a lot less costly.
 */
#if VMDEXT_KERNEL_LINMAP
#define vir2phys(vir)	((phys_bytes) (vir))
#else
#define vir2phys(vir)	(kernel_data_base + (vir_bytes) (vir))
#endif

#define printf        printk	/* the kernel really uses printk, not printf */

#if _VMD_EXT
#define printW()	(printf("%s %d: ", __FILE__, __LINE__))
#endif /* _VMD_EXT */

/*
 * $PchId: const.h,v 1.5 1996/01/19 23:27:01 philip Exp $
 */
