/*	config.h - Configure drivers.			Author: Kees J. Bot
 */
#ifndef CONFIG_H
#define CONFIG_H

#if CHIP == INTEL

/* Set a variable to 1 to include, or 0 to exclude a driver from the kernel.
 * More than one winchester driver may be included, but only one may be used
 * at runtime as selected by the 'hd' boot variable.
 */
#define ENABLE_AT_WINI		 1	/* enable AT winchester driver */
#define ENABLE_BIOS_WINI	 1	/* enable BIOS winchester driver */
#define ENABLE_ESDI_WINI	 1	/* enable ESDI winchester driver */

#define ENABLE_ADAPTEC_SCSI	 1	/* enable ADAPTEC SCSI driver */

#define ENABLE_MITSUMI_CDROM	 0	/* enable Mitsumi CD-ROM driver */

#define ENABLE_DOSDSK		 1	/* enable DOS virtual disk driver */

#define ENABLE_SB_AUDIO    	 0	/* enable Soundblaster audio driver */

/* Size of the DMA buffer in sectors, 1 <= DMA_SECTORS <= 128.  If set to 2
 * or higher then the DMA based drivers (BIOS and ESDI) will use the buffer
 * to increase the request size.
 */
#define DMA_SECTORS		16

/* Number of virtual consoles, 1 <= NR_CONSOLES <= 8. */
#define NR_CONSOLES		 2

#endif /* CHIP == INTEL */

#define ENABLE_VDISK		 1	/* enable generic virtual disk driver */

/* Number of pseudo ttys, 1 <= NR_PTYS <= 128. */
#define NR_PTYS			32

#endif /* CONFIG_H */

/*
 * $PchId: config.h,v 1.5 1995/12/22 09:55:28 philip Exp $
 */
