/* This is the filp table.  It is an intermediary between file descriptors and
 * inodes.  A slot is free if filp_count == 0.
 */

#include "pipe.h"

EXTERN struct filp {
  mode_t filp_mode;		/* RW bits, telling how file is opened */
  short filp_flags;		/* flags from open and fcntl */
  short filp_int_flags;		/* internal flags */
  short filp_count;		/* how many file descriptors share this slot?*/
  struct inode *filp_ino;	/* pointer to the inode */
  u64_t filp_pos;		/* file position */
#if PCH_DEBUG
  int filp_checkcnt;		/* used for checking link counts. */
#endif
} filp_table[NR_FILPS];

#define NIL_FILP (struct filp *) 0	/* indicates absence of a filp slot */

#define FIF_CLOSED	1	/* underlying device is closed */
#define FIF_CLOSING	2	/* underlying device is going to be closed */

EXTERN struct od
{
	unsigned int od_flags;
	int od_result[3];
	struct filp *od_filp;
	struct pod od_pod;
#if PCH_DEBUG
	int od_inuse;
#endif
} od_table[NR_ODS];

#define NIL_ODP (struct od *) 0	/* indicates absence of an od slot */

#define ODF_RD_IP	0x1
#define ODF_RD_COMPL	0x2
#define ODF_WR_IP	0x4
#define ODF_WR_COMPL	0x8
#define ODF_IOC_IP	0x10
#define ODF_IOC_COMPL	0x20
#define ODF_INUSE	0x100
#define ODF_ASYNCH	0x200

/*
 * $PchId: file.h,v 1.4 1995/11/28 08:15:32 philip Exp $
 */
