/* Device table.  This table is indexed by major device number.  It provides
 * the link between major device numbers and the routines that process them.
 */

typedef _PROTOTYPE (int (*dmap_opcl_t), (int open_close, Dev_t device, 
				int dev_task, int user_task, int flags)	);
typedef _PROTOTYPE( int (*dmap_rw_t), (int op, Dev_t device, 
			int dev_task, int user_task, u64_t pos, 
			char *buf, unsigned bytes, int ref, int flags)	);
typedef _PROTOTYPE( int (*dmap_ioctl_t), (Dev_t device, int dev_task, 
				int user_task, ioreq_t function, 
				char *buf, int ref, int flags)		);
typedef _PROTOTYPE( int (*dmap_cancel_t), (int operation, Dev_t device, 
				int dev_task, int user_task, int ref)	);
typedef _PROTOTYPE (int (*dmap_mess_t), (Dev_t device, int dev_task,
					int user_task, message *m_ptr)	);

struct dmap {
  dmap_opcl_t	dmap_open;
  dmap_opcl_t	dmap_close;
  dmap_rw_t	dmap_rw;
  dmap_ioctl_t	dmap_ioctl;
  dmap_cancel_t dmap_cancel;
  dmap_mess_t	dmap_mess;
  int dmap_task;
  int dmap_major;
  char *dmap_taskname;
};

extern struct dmap *dmap[256];
extern struct dmap dmap_table[];


/*
 * $PchId: dev.h,v 1.4 1995/11/28 08:22:23 philip Exp $
 */
