/*
fs/compat.c

Implement binary compatibility with older versions of Minix.

Created:	Nov 26, 1992 by Philip Homburg
*/

#include "fs.h"
#include <stdlib.h>
#include "fproc.h"
#include "assert.h"
INIT_ASSERT

#if DEBUG
FORWARD _PROTOTYPE(void print_cpt, (char *name)				);

PRIVATE void print_cpt(name)
char *name;
{
	static print_level= -1;
	char *fschkcpt;

	if (print_level == 0)
		return;
	else if (print_level == -1)
	{
		fschkcpt= getenv("fschkcpt");
		if (fschkcpt == NULL)
		{
			print_level= 0;
			return;
		}
		print_level= 1;
	}
	printf(
	"(warning) old version of %s(#%d) called by process %d(slot %d)\n",
		name, fs_call, fp->fp_pid, who);
}
#else /* !DEBUG */
#define print_cpt(name)		(void)0
#endif /* DEBUG */


/*===========================================================================*
 *				do_cpt_rename				     *
 *===========================================================================*/
int do_cpt_rename()
{
  assert(fs_call == V7_UNDEFINED_38);

  print_cpt("rename");

  fs_call= m.m_type= RENAME;
  return do_rename();
}


/*===========================================================================*
 *				do_cpt_mkdir				     *
 *===========================================================================*/
int do_cpt_mkdir()
{
  assert(fs_call == V7_UNDEFINED_39);

  print_cpt("mkdir");

  fs_call= m.m_type= MKDIR;
  return do_mkdir();
}


/*===========================================================================*
 *				do_cpt_rmdir				     *
 *===========================================================================*/
int do_cpt_rmdir()
{
  assert(fs_call == V7_UNDEFINED_40);

  print_cpt("rmdir");

  fs_call= m.m_type= RMDIR;
  return do_unlink();
}


/*===========================================================================*
 *				do_cpt_fcntl				     *
 *===========================================================================*/
int do_cpt_fcntl()
{
  assert(fs_call == V7_UNDEFINED_55);

  print_cpt("fcntl");

  fs_call= m.m_type= FCNTL;
  return do_fcntl();
}

/*
 * $PchId: compat.c,v 1.3 1995/11/28 08:24:44 philip Exp $
 */
