/* Buffer (block) cache.  To acquire a block, a routine calls get_block(),
 * telling which block it wants.  The block is then regarded as "in use"
 * and has its 'b_count' field incremented.  All the blocks that are not
 * in use are chained together in an LRU list, with 'front' pointing
 * to the least recently used block, and 'rear' to the most recently used
 * block.  A reverse chain, using the field b_prev is also maintained.
 * Usage for LRU is measured by the time the put_block() is done.  If a block
 * is modified, the modifying routine must set b_dirt to DIRTY, so the block
 * will eventually be rewritten to the disk.
 */

#include <dirent.h>			/* need struct _fl_direct */

union block {
  /* Data portion of the buffer. */
  char b__data[BLOCK_SIZE];		     /* ordinary user data */
  struct _v7_direct b__dir[NR_DIR_ENTRIES];    /* directory block */
  struct _fl_direct b__fl_dir[FL_NR_DIR_ENTRIES]; /* flex directory block */
  zone1_t b__v1_ind[V1_INDIRECTS];	     /* V1 indirect block */
  zone_t  b__v2_ind[V2_INDIRECTS];	     /* V2 indirect block */
  d1_inode b__v1_ino[V1_INODES_PER_BLOCK]; /* V1 inode block */
  d2_inode b__v2_ino[V2_INODES_PER_BLOCK]; /* V2 inode block */
  bitchunk_t b__bitmap[BITMAP_CHUNKS];     /* bit map block */
};

#ifdef _SYSTEM
EXTERN int nr_bufs;			/* number of buffers */
EXTERN union block *cache;		/* the block cache */

EXTERN struct buf {
  /* Header portion of the buffer. */
  struct buf *b_hash;		/* used to link bufs on hash chains */
  struct buf *b_list;		/* used to make temporary lists */
  union block *b;		/* associated cache block */
  block_t b_blocknr;		/* block number of its (minor) device */
  dev_t b_dev;			/* major | minor device where block resides */
  unsigned b_usage;		/* how often is the buffer used */
  char b_dirt;			/* CLEAN or DIRTY */
  char b_count;			/* number of users of this buffer */
  char b_valid;			/* is the contents of this buffer valid */
} *buf, *buf_limit;

EXTERN struct buf **buf_hash;	/* the buffer hash table */
EXTERN int nr_buf_hash, hash_mask;

#else /* !_SYSTEM */
  /* 'Struct buf' is used outside FS too, but in its old form. */
struct buf {
  union block b[1];
};
#endif /* !_SYSTEM */

/* A block is free if b_dev == NO_DEV. */

#define NIL_BUF ((struct buf *) 0)	/* indicates absence of a buffer */

/* These defs make it possible to use to bp->b_data instead of bp->b->b__data */
#define b_data   b->b__data
#define b_dir    b->b__dir
#define b_fl_dir b->b__fl_dir
#define b_v1_ind b->b__v1_ind
#define b_v2_ind b->b__v2_ind
#define b_v1_ino b->b__v1_ino
#define b_v2_ino b->b__v2_ino
#define b_bitmap b->b__bitmap

EXTERN int bufs_in_use;		/* # bufs currently in use (not on free list)*/

#define HASH_MASK (NR_BUF_HASH - 1)	/* mask for hashing block numbers */

/*
 * $PchId: buf.h,v 1.7 1996/01/19 23:15:00 philip Exp $
 */
