#include "syslib.h"

int sys_exec(proc, srcproc, initial_sp, traced, name, initial_pc)
int proc;			/* process that did exec */
int srcproc;			/* slot to fetch map from */
vir_bytes initial_sp;		/* new stack pointer */
int traced;			/* is tracing enabled? */
char *name;			/* name of the new program */
vir_bytes initial_pc;
{
/* A process has exec'd.  Tell the kernel. */

  message m;

  m.m1_i1 = proc;
  m.m1_i2 = traced;
  m.m1_i3 = srcproc;
  m.m1_p1 = (char *)initial_sp;
  m.m1_p2 = name;
  m.m1_p3 = (char *)initial_pc;

  return _taskcall(SYSTASK, SYS_EXEC, &m);
}
