/*
syscall/_sigpending.c

Created:	Oct 5, 1993 by Philip Homburg <philip@cs.vu.nl>
*/

#include <minix/stubs.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <minix/type.h>
#include <minix/callnr.h>
#include <minix/minlib.h>

int sigpending(sigset_t *set)
{
	message m;
	int r;

	/* Clear unused fields */
	m.m2_i1 = 0;
	m.m2_i2 = 0;
	m.m2_i3 = 0;
	m.m2_l1 = 0;
	m.m2_l2 = 0;
	m.m2_p1 = NULL;

	r= _syscall(PROC_MM, SIGPENDING, &m);
	if (r == -1)
		return -1;
	*set= m.m2_l1;
	return r;
}

/*
 * $PchId: _sigpending.c,v 1.4 1995/11/27 19:44:04 philip Exp $
 */
